/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.attachment;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderException;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentContent;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;

public class FreemarkerAttachmentRenderer
implements AttachmentRenderer<AttachmentData> {
    private final Configuration configuration;
    private final String templateName;

    public FreemarkerAttachmentRenderer(String templateName) {
        this.templateName = templateName;
        this.configuration = new Configuration(Configuration.VERSION_2_3_23);
        this.configuration.setLocalizedLookup(false);
        this.configuration.setTemplateUpdateDelayMilliseconds(0L);
        this.configuration.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), "tpl");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultAttachmentContent render(AttachmentData data) {
        try (StringWriter writer = new StringWriter();){
            Template template = this.configuration.getTemplate(this.templateName);
            template.process(Collections.singletonMap("data", data), (Writer)writer);
            DefaultAttachmentContent defaultAttachmentContent = new DefaultAttachmentContent(((Object)writer).toString(), "text/html", ".html");
            return defaultAttachmentContent;
        }
        catch (Exception e) {
            throw new AttachmentRenderException("Could't render http attachment file", e);
        }
    }
}

