/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.maven;

import io.qameta.allure.maven.AllureGenerateMojo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class AllureReportMojo
extends AllureGenerateMojo {
    private static final String FOUND_DIRECTORY = "Found results directory %s";
    private static final String DIRECTORY_NOT_FOUND = "Directory %s not found";
    @Parameter(property="allure.results.inputDirectories")
    protected String inputDirectories;

    @Override
    protected List<Path> getInputDirectories() {
        if (StringUtils.isNotBlank((CharSequence)this.inputDirectories)) {
            return this.fromInputDirectories();
        }
        Path path = this.getInputDirectoryAbsolutePath();
        if (this.isDirectoryExists(path)) {
            this.getLog().info((CharSequence)String.format(FOUND_DIRECTORY, path));
            return Collections.singletonList(path);
        }
        this.getLog().error((CharSequence)String.format(DIRECTORY_NOT_FOUND, path));
        return Collections.emptyList();
    }

    private List<Path> fromInputDirectories() {
        ArrayList<Path> results = new ArrayList<Path>();
        for (String dir : this.inputDirectories.split(",")) {
            Path path = Paths.get(dir, new String[0]).toAbsolutePath();
            if (this.isDirectoryExists(path)) {
                results.add(path);
                this.getLog().info((CharSequence)String.format(FOUND_DIRECTORY, path));
                continue;
            }
            this.getLog().error((CharSequence)String.format(DIRECTORY_NOT_FOUND, path));
        }
        return results;
    }

    @Override
    protected String getMojoName() {
        return "report";
    }

    private Path getInputDirectoryAbsolutePath() {
        Path path = Paths.get(this.resultsDirectory, new String[0]);
        return path.isAbsolute() ? path : Paths.get(this.buildDirectory, new String[0]).resolve(path);
    }
}

