/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.okhttp3;

import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentProcessor;
import io.qameta.allure.attachment.FreemarkerAttachmentRenderer;
import io.qameta.allure.attachment.http.HttpRequestAttachment;
import io.qameta.allure.attachment.http.HttpResponseAttachment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class AllureOkHttp3
implements Interceptor {
    private String requestTemplatePath = "http-request.ftl";
    private String responseTemplatePath = "http-response.ftl";

    public AllureOkHttp3 setRequestTemplate(String templatePath) {
        this.requestTemplatePath = templatePath;
        return this;
    }

    public AllureOkHttp3 setResponseTemplate(String templatePath) {
        this.responseTemplatePath = templatePath;
        return this;
    }

    @Deprecated
    public AllureOkHttp3 withRequestTemplate(String templatePath) {
        return this.setRequestTemplate(templatePath);
    }

    @Deprecated
    public AllureOkHttp3 withResponseTemplate(String templatePath) {
        return this.setResponseTemplate(templatePath);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        DefaultAttachmentProcessor processor = new DefaultAttachmentProcessor();
        Request request = chain.request();
        String requestUrl = request.url().toString();
        HttpRequestAttachment.Builder requestAttachmentBuilder = HttpRequestAttachment.Builder.create((String)"Request", (String)requestUrl).setMethod(request.method()).setHeaders(AllureOkHttp3.toMapConverter(request.headers().toMultimap()));
        RequestBody requestBody = request.body();
        if (Objects.nonNull(requestBody)) {
            requestAttachmentBuilder.setBody(AllureOkHttp3.readRequestBody(requestBody));
        }
        HttpRequestAttachment requestAttachment = requestAttachmentBuilder.build();
        processor.addAttachment((AttachmentData)requestAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer(this.requestTemplatePath));
        Response response = chain.proceed(request);
        HttpResponseAttachment.Builder responseAttachmentBuilder = HttpResponseAttachment.Builder.create((String)"Response").setResponseCode(response.code()).setHeaders(AllureOkHttp3.toMapConverter(response.headers().toMultimap()));
        Response.Builder responseBuilder = response.newBuilder();
        ResponseBody responseBody = response.body();
        if (Objects.nonNull(responseBody)) {
            byte[] bytes = responseBody.bytes();
            responseAttachmentBuilder.setBody(new String(bytes, StandardCharsets.UTF_8));
            responseBuilder.body(ResponseBody.create((MediaType)responseBody.contentType(), (byte[])bytes));
        }
        HttpResponseAttachment responseAttachment = responseAttachmentBuilder.build();
        processor.addAttachment((AttachmentData)responseAttachment, (AttachmentRenderer)new FreemarkerAttachmentRenderer(this.responseTemplatePath));
        return responseBuilder.build();
    }

    private static Map<String, String> toMapConverter(Map<String, List<String>> items) {
        HashMap<String, String> result = new HashMap<String, String>();
        items.forEach((key, value) -> result.put((String)key, String.join((CharSequence)"; ", value)));
        return result;
    }

    private static String readRequestBody(RequestBody requestBody) throws IOException {
        Buffer buffer = new Buffer();
        requestBody.writeTo((BufferedSink)buffer);
        return buffer.readString(StandardCharsets.UTF_8);
    }
}

