/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkiverse.jberet.runtime.JBeretConfigSourceProvider;
import io.quarkiverse.jberet.runtime.JBeretDataHolder;
import io.quarkiverse.jberet.runtime.QuarkusJobOperator;
import io.quarkiverse.jberet.runtime.QuarkusJobScheduler;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.operations.JobOperator;
import javax.transaction.TransactionManager;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jberet.job.model.Decision;
import org.jberet.job.model.Flow;
import org.jberet.job.model.InheritableJobElement;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobElement;
import org.jberet.job.model.RefArtifact;
import org.jberet.job.model.Split;
import org.jberet.job.model.Step;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduleConfigBuilder;
import org.jberet.schedule.JobScheduler;
import org.jberet.spi.JobOperatorContext;

@Recorder
public class JBeretRecorder {
    public void registerJobs(List<Job> jobs) {
        JBeretDataHolder.registerJobs(jobs);
    }

    public RuntimeValue<ConfigSourceProvider> config() {
        HashSet<String> properties = new HashSet<String>();
        List<Job> jobs = JBeretDataHolder.getJobs();
        for (Job job : jobs) {
            JBeretRecorder.addConfigNames(properties, (InheritableJobElement)job);
            for (JobElement jobElement : job.getJobElements()) {
                JBeretRecorder.addConfigNames(properties, jobElement);
            }
            for (InheritableJobElement inheritingJobElement : job.getInheritingJobElements()) {
                JBeretRecorder.addConfigNames(properties, inheritingJobElement);
            }
        }
        return new RuntimeValue((Object)new JBeretConfigSourceProvider(properties));
    }

    public void initJobOperator(JBeretConfig config, ThreadPoolConfig threadPoolConfig, BeanContainer beanContainer) {
        ManagedExecutor managedExecutor = (ManagedExecutor)beanContainer.instance(ManagedExecutor.class, new Annotation[0]);
        TransactionManager transactionManager = (TransactionManager)beanContainer.instance(TransactionManager.class, new Annotation[0]);
        QuarkusJobOperator operator = new QuarkusJobOperator(config, threadPoolConfig, managedExecutor, transactionManager, JBeretDataHolder.getJobs());
        JobOperatorContext operatorContext = JobOperatorContext.create((JobOperator)operator);
        JobOperatorContext.setJobOperatorContextSelector(() -> operatorContext);
    }

    public void initScheduler(JBeretConfig config) {
        if (config.job.values().stream().noneMatch(jobConfig -> jobConfig.cron.isPresent())) {
            return;
        }
        QuarkusJobScheduler jobScheduler = (QuarkusJobScheduler)JobScheduler.getJobScheduler(QuarkusJobScheduler.class, new ConcurrentHashMap(), null);
        CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
        for (Job job : JBeretDataHolder.getJobs()) {
            JBeretConfig.JobConfig jobConfig2 = config.job.get(job.getJobXmlName());
            if (jobConfig2 == null || !jobConfig2.cron.isPresent()) continue;
            Cron cron = parser.parse(jobConfig2.cron.get());
            Properties jobParameters = new Properties();
            if (jobConfig2.params != null && !jobConfig2.params.isEmpty()) {
                jobParameters.putAll(jobConfig2.params);
            }
            JobScheduleConfig scheduleConfig = JobScheduleConfigBuilder.newInstance().jobName(job.getJobXmlName()).jobParameters(jobParameters).build();
            jobScheduler.schedule(scheduleConfig, cron);
        }
    }

    private static void addConfigNames(Set<String> properties, JobElement jobElement) {
        if (jobElement instanceof Step) {
            Step step = (Step)jobElement;
            JBeretRecorder.addConfigNames(properties, (InheritableJobElement)step);
            JBeretRecorder.addConfigNames(properties, step.getBatchlet());
            if (step.getChunk() != null) {
                JBeretRecorder.addConfigNames(properties, step.getChunk().getReader());
                JBeretRecorder.addConfigNames(properties, step.getChunk().getProcessor());
                JBeretRecorder.addConfigNames(properties, step.getChunk().getWriter());
                JBeretRecorder.addConfigNames(properties, step.getChunk().getCheckpointAlgorithm());
            }
            if (step.getPartition() != null) {
                JBeretRecorder.addConfigNames(properties, step.getPartition().getMapper());
                JBeretRecorder.addConfigNames(properties, step.getPartition().getCollector());
                JBeretRecorder.addConfigNames(properties, step.getPartition().getAnalyzer());
                JBeretRecorder.addConfigNames(properties, step.getPartition().getReducer());
            }
        }
        if (jobElement instanceof Flow) {
            Flow flow = (Flow)jobElement;
            JBeretRecorder.addConfigNames(properties, (InheritableJobElement)flow);
            for (JobElement flowElement : flow.getJobElements()) {
                JBeretRecorder.addConfigNames(properties, flowElement);
            }
        }
        if (jobElement instanceof Split) {
            Split split = (Split)jobElement;
            JBeretRecorder.addConfigNames(properties, split.getProperties());
            for (Flow flow : split.getFlows()) {
                JBeretRecorder.addConfigNames(properties, (JobElement)flow);
            }
        }
        if (jobElement instanceof Decision) {
            Decision decision = (Decision)jobElement;
            JBeretRecorder.addConfigNames(properties, decision.getProperties());
        }
    }

    private static void addConfigNames(Set<String> properties, InheritableJobElement inheritableJobElement) {
        if (inheritableJobElement != null) {
            if (inheritableJobElement.getProperties() != null) {
                JBeretRecorder.addConfigNames(properties, inheritableJobElement.getProperties());
            }
            if (inheritableJobElement.getListeners() != null) {
                for (RefArtifact refArtifact : inheritableJobElement.getListeners().getListeners()) {
                    JBeretRecorder.addConfigNames(properties, refArtifact);
                }
            }
        }
    }

    private static void addConfigNames(Set<String> properties, RefArtifact refArtifact) {
        if (refArtifact != null && refArtifact.getProperties() != null) {
            JBeretRecorder.addConfigNames(properties, refArtifact.getProperties());
        }
    }

    private static void addConfigNames(Set<String> properties, org.jberet.job.model.Properties propertiesHolder) {
        if (propertiesHolder != null) {
            properties.addAll(propertiesHolder.getNameValues().keySet());
        }
    }
}

