/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkiverse.jberet.runtime.JBeretRepositoryFactory;
import io.quarkus.arc.Arc;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jberet.creation.AbstractArtifactFactory;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jberet.spi.JobXmlResolver;

class QuarkusBatchEnvironment
implements BatchEnvironment {
    private final ArtifactFactory artifactFactory = new QuarkusArtifactFactory();
    private final JobExecutor jobExecutor;
    private final JobRepository jobRepository;
    private final TransactionManager transactionManager;
    private static final Properties PROPS = new Properties();

    public QuarkusBatchEnvironment(JBeretConfig config, JobExecutor jobExecutor, TransactionManager transactionManager) {
        this.jobExecutor = jobExecutor;
        this.jobRepository = JBeretRepositoryFactory.getJobRepository(config);
        this.transactionManager = transactionManager;
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = QuarkusBatchEnvironment.class.getClassLoader();
        }
        return cl;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void submitTask(JobTask jobTask) {
        this.jobExecutor.execute(jobTask);
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public JobXmlResolver getJobXmlResolver() {
        throw new UnsupportedOperationException();
    }

    public Properties getBatchConfigurationProperties() {
        return PROPS;
    }

    public String getApplicationName() {
        return ConfigProvider.getConfig().getConfigValue("quarkus.application.name").getValue();
    }

    static class QuarkusArtifactFactory
    extends AbstractArtifactFactory {
        QuarkusArtifactFactory() {
        }

        public Object create(String ref, Class<?> cls, ClassLoader classLoader) {
            BeanManager bm = Arc.container().beanManager();
            Bean bean = bm.resolve(bm.getBeans(ref));
            return bean == null ? null : bm.getReference(bean, (Type)bean.getBeanClass(), bm.createCreationalContext((Contextual)bean));
        }

        public Class<?> getArtifactClass(String ref, ClassLoader classLoader) {
            BeanManager bm = Arc.container().beanManager();
            Bean bean = bm.resolve(bm.getBeans(ref));
            return bean == null ? null : bean.getBeanClass();
        }
    }
}

