/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import io.quarkiverse.jberet.runtime.JBeretConfig;
import io.quarkiverse.jberet.runtime.QuarkusBatchEnvironment;
import io.quarkiverse.jberet.runtime.QuarkusJobExecutor;
import io.quarkus.runtime.ThreadPoolConfig;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.enterprise.inject.Vetoed;
import javax.transaction.TransactionManager;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.jberet._private.BatchMessages;
import org.jberet.job.model.Job;
import org.jberet.operations.AbstractJobOperator;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.spi.BatchEnvironment;

@Vetoed
public class QuarkusJobOperator
extends AbstractJobOperator {
    private final BatchEnvironment batchEnvironment;
    private final Map<String, Job> jobs;
    private final JBeretConfig config;

    public QuarkusJobOperator(JBeretConfig config, ThreadPoolConfig threadPoolConfig, ManagedExecutor managedExecutor, TransactionManager transactionManager, List<Job> jobs) {
        this.batchEnvironment = new QuarkusBatchEnvironment(config, new QuarkusJobExecutor((Executor)managedExecutor, threadPoolConfig), transactionManager);
        this.jobs = jobs.stream().collect(Collectors.toMap(Job::getJobXmlName, job -> job));
        this.config = config;
    }

    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        return this.start(jobXMLName, jobParameters, null);
    }

    public long start(String jobXMLName, Properties jobParameters, String user) throws JobStartException, JobSecurityException {
        Job jobDefinition;
        JBeretConfig.JobConfig jobConfig = this.config.job.get(jobXMLName);
        if (jobConfig != null && jobConfig.params != null) {
            for (Map.Entry<String, String> param : jobConfig.params.entrySet()) {
                if (jobParameters.containsKey(param.getKey())) continue;
                jobParameters.setProperty(param.getKey(), param.getValue());
            }
        }
        if ((jobDefinition = this.jobs.get(jobXMLName)) != null) {
            return super.start(jobDefinition, jobParameters, user);
        }
        throw new NoSuchJobException("Job with xml name " + jobXMLName + " was not found");
    }

    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        return this.restart(executionId, restartParameters, null);
    }

    public long restart(long executionId, Properties restartParameters, String user) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        JobExecutionImpl originalToRestart = this.getJobExecutionImpl(executionId);
        JobInstanceImpl jobInstance = originalToRestart.getJobInstance();
        if (jobInstance == null) {
            throw BatchMessages.MESSAGES.noSuchJobInstance(null);
        }
        String jobName = originalToRestart.getJobName();
        Job jobDefinition = jobInstance.getUnsubstitutedJob();
        if (jobDefinition == null) {
            ApplicationAndJobName applicationAndJobName = new ApplicationAndJobName(jobInstance.getApplicationName(), jobName);
            JobRepository repository = this.getJobRepository();
            jobDefinition = repository.getJob(applicationAndJobName);
            if (jobDefinition == null) {
                jobDefinition = this.jobs.get(jobName);
                repository.addJob(applicationAndJobName, jobDefinition);
            }
            jobInstance.setUnsubstitutedJob(jobDefinition);
        }
        if (jobDefinition != null) {
            return super.restart(executionId, restartParameters, user);
        }
        throw new NoSuchJobException("Job with xml name " + jobName + " was not found");
    }

    public BatchEnvironment getBatchEnvironment() {
        return this.batchEnvironment;
    }
}

