/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jberet.runtime;

import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduler;

public class QuarkusJobScheduler
extends JobScheduler {
    private final ScheduledExecutorService executorService;
    private final ConcurrentMap<String, JobSchedule> schedules = new ConcurrentHashMap<String, JobSchedule>();
    private final AtomicInteger ids = new AtomicInteger(1);

    public QuarkusJobScheduler() {
        this(Executors.newSingleThreadScheduledExecutor());
    }

    public QuarkusJobScheduler(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    public JobSchedule schedule(JobScheduleConfig scheduleConfig) {
        JobSchedule jobSchedule = new JobSchedule(String.valueOf(this.ids.getAndIncrement()), scheduleConfig);
        JobTask task = new JobTask(jobSchedule);
        if (scheduleConfig.getInterval() <= 0L && scheduleConfig.getAfterDelay() <= 0L) {
            this.executorService.schedule(task, scheduleConfig.getInitialDelay(), timeUnit);
        } else if (scheduleConfig.getInterval() > 0L) {
            this.executorService.scheduleAtFixedRate(task, scheduleConfig.getInitialDelay(), scheduleConfig.getInterval(), timeUnit);
        } else {
            this.executorService.scheduleWithFixedDelay(task, scheduleConfig.getInitialDelay(), scheduleConfig.getAfterDelay(), timeUnit);
        }
        this.schedules.put(jobSchedule.getId(), jobSchedule);
        return jobSchedule;
    }

    public JobSchedule schedule(JobScheduleConfig scheduleConfig, Cron cron) {
        JobSchedule jobSchedule = new JobSchedule(String.valueOf(this.ids.getAndIncrement()), scheduleConfig);
        CronJobTask task = new CronJobTask(jobSchedule, cron);
        this.executorService.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.SECONDS);
        this.schedules.put(jobSchedule.getId(), jobSchedule);
        return jobSchedule;
    }

    public List<JobSchedule> getJobSchedules() {
        return Collections.unmodifiableList(new ArrayList(this.schedules.values()));
    }

    public boolean cancel(String scheduleId) {
        throw new UnsupportedOperationException();
    }

    public JobSchedule getJobSchedule(String scheduleId) {
        return (JobSchedule)this.schedules.get(scheduleId);
    }

    static class CronJobTask
    extends JobTask {
        private final ExecutionTime executionTime;
        private transient ZonedDateTime lastExecution = null;

        public CronJobTask(JobSchedule jobSchedule, Cron cron) {
            super(jobSchedule);
            this.executionTime = ExecutionTime.forCron((Cron)cron);
        }

        @Override
        public void run() {
            ZonedDateTime now = ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
            Optional lastExecution = this.executionTime.lastExecution(now);
            if (lastExecution.isPresent()) {
                ZonedDateTime cron = ((ZonedDateTime)lastExecution.get()).truncatedTo(ChronoUnit.SECONDS);
                if (this.lastExecution != null && cron.isEqual(this.lastExecution)) {
                    return;
                }
                if (now.isAfter(cron)) {
                    this.lastExecution = cron;
                    super.run();
                }
            }
        }
    }

    static class JobTask
    implements Runnable {
        private final JobSchedule jobSchedule;

        public JobTask(JobSchedule jobSchedule) {
            this.jobSchedule = jobSchedule;
        }

        @Override
        public void run() {
            JobScheduleConfig config = this.jobSchedule.getJobScheduleConfig();
            if (config.getJobExecutionId() > 0L) {
                this.jobSchedule.addJobExecutionIds(JobScheduler.getJobOperator().restart(config.getJobExecutionId(), config.getJobParameters()));
            } else {
                this.jobSchedule.addJobExecutionIds(JobScheduler.getJobOperator().start(config.getJobName(), config.getJobParameters()));
            }
        }
    }
}

