/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.ollama;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import io.quarkiverse.langchain4j.ollama.ChatRequest;
import io.quarkiverse.langchain4j.ollama.ChatResponse;
import io.quarkiverse.langchain4j.ollama.MessageMapper;
import io.quarkiverse.langchain4j.ollama.OllamaClient;
import io.quarkiverse.langchain4j.ollama.Options;
import java.time.Duration;
import java.util.List;

public class OllamaChatLanguageModel
implements ChatLanguageModel {
    private final OllamaClient client;
    private final String model;
    private final String format;
    private final Options options;

    private OllamaChatLanguageModel(Builder builder) {
        this.client = new OllamaClient(builder.baseUrl, builder.timeout, builder.logRequests, builder.logResponses);
        this.model = builder.model;
        this.format = builder.format;
        this.options = builder.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ChatRequest request = ChatRequest.builder().model(this.model).messages(MessageMapper.toOllamaMessages(messages)).options(this.options).format(this.format).stream(false).build();
        ChatResponse response = this.client.chat(request);
        return Response.from((Object)AiMessage.from((String)response.message().content()), (TokenUsage)new TokenUsage(response.promptEvalCount(), response.evalCount()));
    }

    public static final class Builder {
        private String baseUrl = "http://localhost:11434";
        private Duration timeout = Duration.ofSeconds(10L);
        private String model;
        private String format;
        private Options options;
        private boolean logRequests = false;
        private boolean logResponses = false;

        private Builder() {
        }

        public Builder baseUrl(String val) {
            this.baseUrl = val;
            return this;
        }

        public Builder timeout(Duration val) {
            this.timeout = val;
            return this;
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder format(String val) {
            this.format = val;
            return this;
        }

        public Builder options(Options val) {
            this.options = val;
            return this;
        }

        public Builder logRequests(boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public Builder logResponses(boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OllamaChatLanguageModel build() {
            return new OllamaChatLanguageModel(this);
        }
    }
}

