/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.providers;

import io.quarkiverse.loggingjson.Config;
import io.quarkiverse.loggingjson.Enabled;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.JsonWritingUtils;
import java.io.IOException;
import org.jboss.logmanager.ExtLogRecord;

public class MDCJsonProvider
implements JsonProvider,
Enabled {
    private final String fieldName;
    private final Config.MDCConfig config;

    public MDCJsonProvider(Config.MDCConfig config) {
        this.config = config;
        this.fieldName = config.flatFields ? null : config.fieldName.orElse("mdc");
    }

    @Override
    public void writeTo(JsonGenerator generator, ExtLogRecord event) throws IOException {
        JsonWritingUtils.writeMapStringFields(generator, this.fieldName, event.getMdcCopy());
    }

    @Override
    public boolean isEnabled() {
        return this.config.enabled.orElse(true);
    }
}

