/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.loggingjson.providers;

import io.quarkiverse.loggingjson.Config;
import io.quarkiverse.loggingjson.JsonGenerator;
import io.quarkiverse.loggingjson.JsonProvider;
import io.quarkiverse.loggingjson.JsonWritingUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class TimestampJsonProvider
implements JsonProvider {
    private final String fieldName;
    private final DateTimeFormatter dateTimeFormatter;

    public TimestampJsonProvider(Config.TimestampField config) {
        this.fieldName = config.fieldName.orElse("timestamp");
        ZoneId zoneId = config.zoneId == null || "default".equals(config.zoneId) ? ZoneId.systemDefault() : ZoneId.of(config.zoneId);
        this.dateTimeFormatter = config.dateFormat != null && !config.dateFormat.equals("default") ? DateTimeFormatter.ofPattern(config.dateFormat).withZone(zoneId) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId);
    }

    @Override
    public void writeTo(JsonGenerator generator, ExtLogRecord event) throws IOException {
        long millis = event.getMillis();
        JsonWritingUtils.writeStringField(generator, this.fieldName, this.dateTimeFormatter.format(Instant.ofEpochMilli(millis)));
    }
}

