/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ActivateRequestContextInterceptor;
import io.quarkus.arc.InjectableRequestContextController;
import io.quarkus.arc.processor.BeanProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.control.ActivateRequestContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Intercepted;
import javax.inject.Named;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;

public final class BeanArchives {
    public static IndexView buildBeanArchiveIndex(IndexView ... applicationIndexes) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        Collections.addAll(indexes, applicationIndexes);
        indexes.add(BeanArchives.buildAdditionalIndex());
        return new IndexWrapper((IndexView)CompositeIndex.create(indexes));
    }

    private static IndexView buildAdditionalIndex() {
        Indexer indexer = new Indexer();
        BeanArchives.index(indexer, ActivateRequestContext.class.getName());
        BeanArchives.index(indexer, Default.class.getName());
        BeanArchives.index(indexer, Any.class.getName());
        BeanArchives.index(indexer, Named.class.getName());
        BeanArchives.index(indexer, Initialized.class.getName());
        BeanArchives.index(indexer, BeforeDestroyed.class.getName());
        BeanArchives.index(indexer, Destroyed.class.getName());
        BeanArchives.index(indexer, Intercepted.class.getName());
        BeanArchives.index(indexer, ActivateRequestContextInterceptor.class.getName());
        BeanArchives.index(indexer, InjectableRequestContextController.class.getName());
        return indexer.complete();
    }

    static void index(Indexer indexer, String className) {
        try (InputStream stream = BeanProcessor.class.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");){
            indexer.index(stream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to index: " + className, e);
        }
    }

    static class IndexWrapper
    implements IndexView {
        private final Map<DotName, ClassInfo> additionalClasses;
        private final IndexView index;

        public IndexWrapper(IndexView index) {
            this.index = index;
            this.additionalClasses = new ConcurrentHashMap<DotName, ClassInfo>();
        }

        public Collection<ClassInfo> getKnownClasses() {
            return this.index.getKnownClasses();
        }

        public ClassInfo getClassByName(DotName className) {
            ClassInfo classInfo = this.index.getClassByName(className);
            if (classInfo == null) {
                return this.additionalClasses.computeIfAbsent(className, name -> {
                    BeanProcessor.LOGGER.debugf("Index: %s", (Object)className);
                    Indexer indexer = new Indexer();
                    BeanArchives.index(indexer, className.toString());
                    Index index = indexer.complete();
                    return index.getClassByName(name);
                });
            }
            return classInfo;
        }

        public Collection<ClassInfo> getKnownDirectSubclasses(DotName className) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getKnownDirectSubclasses(className);
            }
            HashSet<ClassInfo> directSubclasses = new HashSet<ClassInfo>(this.index.getKnownDirectSubclasses(className));
            for (ClassInfo additional : this.additionalClasses.values()) {
                if (!className.equals((Object)additional.superName())) continue;
                directSubclasses.add(additional);
            }
            return directSubclasses;
        }

        public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getAllKnownSubclasses(className);
            }
            HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
            HashSet<DotName> processedClasses = new HashSet<DotName>();
            this.getAllKnownSubClasses(className, allKnown, processedClasses);
            return allKnown;
        }

        public Collection<ClassInfo> getKnownDirectImplementors(DotName className) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getKnownDirectImplementors(className);
            }
            HashSet<ClassInfo> directImplementors = new HashSet<ClassInfo>(this.index.getKnownDirectImplementors(className));
            block0: for (ClassInfo additional : this.additionalClasses.values()) {
                for (Type interfaceType : additional.interfaceTypes()) {
                    if (!className.equals((Object)interfaceType.name())) continue;
                    directImplementors.add(additional);
                    continue block0;
                }
            }
            return directImplementors;
        }

        public Collection<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
            if (this.additionalClasses.isEmpty()) {
                return this.index.getAllKnownImplementors(interfaceName);
            }
            HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
            HashSet<DotName> subInterfacesToProcess = new HashSet<DotName>();
            HashSet<DotName> processedClasses = new HashSet<DotName>();
            subInterfacesToProcess.add(interfaceName);
            while (!subInterfacesToProcess.isEmpty()) {
                Iterator toProcess = subInterfacesToProcess.iterator();
                DotName name = (DotName)toProcess.next();
                toProcess.remove();
                processedClasses.add(name);
                this.getKnownImplementors(name, allKnown, subInterfacesToProcess, processedClasses);
            }
            return allKnown;
        }

        public Collection<AnnotationInstance> getAnnotations(DotName annotationName) {
            return this.index.getAnnotations(annotationName);
        }

        private void getAllKnownSubClasses(DotName className, Set<ClassInfo> allKnown, Set<DotName> processedClasses) {
            HashSet<DotName> subClassesToProcess = new HashSet<DotName>();
            subClassesToProcess.add(className);
            while (!subClassesToProcess.isEmpty()) {
                Iterator toProcess = subClassesToProcess.iterator();
                DotName name = (DotName)toProcess.next();
                toProcess.remove();
                processedClasses.add(name);
                this.getAllKnownSubClasses(name, allKnown, subClassesToProcess, processedClasses);
            }
        }

        private void getAllKnownSubClasses(DotName name, Set<ClassInfo> allKnown, Set<DotName> subClassesToProcess, Set<DotName> processedClasses) {
            Collection<ClassInfo> directSubclasses = this.getKnownDirectSubclasses(name);
            if (directSubclasses != null) {
                for (ClassInfo clazz : directSubclasses) {
                    DotName className = clazz.name();
                    if (processedClasses.contains(className)) continue;
                    allKnown.add(clazz);
                    subClassesToProcess.add(className);
                }
            }
        }

        private void getKnownImplementors(DotName name, Set<ClassInfo> allKnown, Set<DotName> subInterfacesToProcess, Set<DotName> processedClasses) {
            Collection<ClassInfo> list = this.getKnownDirectImplementors(name);
            if (list != null) {
                for (ClassInfo clazz : list) {
                    DotName className = clazz.name();
                    if (processedClasses.contains(className)) continue;
                    if (Modifier.isInterface(clazz.flags())) {
                        subInterfacesToProcess.add(className);
                        continue;
                    }
                    if (allKnown.contains(clazz)) continue;
                    allKnown.add(clazz);
                    processedClasses.add(className);
                    this.getAllKnownSubClasses(className, allKnown, processedClasses);
                }
            }
        }
    }
}

