/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.ClassOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ResourceClassOutput
implements ClassOutput {
    private static final Function<String, ResourceOutput.Resource.SpecialType> NO_SPECIAL_TYPE = cn -> null;
    private final List<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
    private final Map<String, StringWriter> sources;
    private final boolean applicationClass;
    private final Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction;

    public ResourceClassOutput(boolean applicationClass, boolean generateSource) {
        this(applicationClass, NO_SPECIAL_TYPE, generateSource);
    }

    public ResourceClassOutput(boolean applicationClass, Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction, boolean generateSource) {
        this.applicationClass = applicationClass;
        this.specialTypeFunction = specialTypeFunction;
        this.sources = generateSource ? new HashMap() : null;
    }

    public void write(String name, byte[] data) {
        this.resources.add(ResourceImpl.javaClass(name, data, this.specialTypeFunction.apply(name), this.applicationClass, this.getSource(name)));
    }

    public Writer getSourceWriter(String className) {
        if (this.sources != null) {
            StringWriter writer = new StringWriter();
            this.sources.put(className, writer);
            return writer;
        }
        return super.getSourceWriter(className);
    }

    List<ResourceOutput.Resource> getResources() {
        return this.resources;
    }

    String getSource(String className) {
        if (this.sources == null) {
            return null;
        }
        StringWriter source = this.sources.get(className);
        return source != null ? source.toString() : null;
    }
}

