/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InterceptorInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Type;

public class InterceptorResolver {
    private final BeanDeployment beanDeployment;

    public InterceptorResolver(BeanDeployment beanDeployment) {
        this.beanDeployment = beanDeployment;
    }

    public List<InterceptorInfo> resolve(InterceptionType interceptionType, Set<AnnotationInstance> bindings) {
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        for (InterceptorInfo interceptor : this.beanDeployment.getInterceptors()) {
            if (!interceptor.intercepts(interceptionType)) continue;
            boolean matches = false;
            for (AnnotationInstance interceptorBinding : interceptor.getBindings()) {
                if (!this.hasInterceptorBinding(bindings, interceptorBinding)) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            interceptors.add(interceptor);
        }
        if (interceptors.isEmpty()) {
            return Collections.emptyList();
        }
        interceptors.sort(this::compare);
        return interceptors;
    }

    private int compare(InterceptorInfo i1, InterceptorInfo i2) {
        return Integer.compare(i1.getPriority(), i2.getPriority());
    }

    private boolean hasInterceptorBinding(Collection<AnnotationInstance> bindings, AnnotationInstance interceptorBinding) {
        for (AnnotationInstance binding : bindings) {
            if (this.isInterceptorBinding(interceptorBinding, binding)) {
                return true;
            }
            Set<AnnotationInstance> transitiveInterceptorBindings = this.beanDeployment.getTransitiveInterceptorBindings(binding.name());
            if (transitiveInterceptorBindings == null) continue;
            for (AnnotationInstance transitiveBindingInstance : transitiveInterceptorBindings) {
                if (!this.isInterceptorBinding(interceptorBinding, transitiveBindingInstance)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInterceptorBinding(AnnotationInstance interceptorBinding, AnnotationInstance candidate) {
        ClassInfo interceptorBindingClass = this.beanDeployment.getInterceptorBinding(interceptorBinding.name());
        if (candidate.name().equals((Object)interceptorBinding.name())) {
            boolean matches = true;
            Set<String> nonBindingFields = this.beanDeployment.getNonBindingFields(interceptorBinding.name());
            for (AnnotationValue value : candidate.valuesWithDefaults(this.beanDeployment.getIndex())) {
                String annotationField = value.name();
                if (interceptorBindingClass.method(annotationField, new Type[0]).hasAnnotation(DotNames.NONBINDING) || nonBindingFields.contains(annotationField) || value.equals((Object)interceptorBinding.valueWithDefault(this.beanDeployment.getIndex(), annotationField))) continue;
                matches = false;
                break;
            }
            if (matches) {
                return true;
            }
        }
        return false;
    }
}

