/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.ResourceImpl;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.ClassOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ResourceClassOutput
implements ClassOutput {
    private final List<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
    private final boolean applicationClass;
    private final Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction;

    public ResourceClassOutput(boolean applicationClass) {
        this(applicationClass, null);
    }

    public ResourceClassOutput(boolean applicationClass, Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction) {
        this.applicationClass = applicationClass;
        this.specialTypeFunction = specialTypeFunction;
    }

    public void write(String name, byte[] data) {
        this.resources.add(ResourceImpl.javaClass(name, data, this.specialTypeFunction != null ? this.specialTypeFunction.apply(name) : null, this.applicationClass));
    }

    List<ResourceOutput.Resource> getResources() {
        return this.resources;
    }
}

