/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.Sets;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InterceptionType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class InterceptorInfo
extends BeanInfo
implements Comparable<InterceptorInfo> {
    private static final Logger LOGGER = Logger.getLogger(InterceptorInfo.class);
    private final Set<AnnotationInstance> bindings;
    private final MethodInfo aroundInvoke;
    private final MethodInfo aroundConstruct;
    private final MethodInfo postConstruct;
    private final MethodInfo preDestroy;

    InterceptorInfo(AnnotationTarget target, BeanDeployment beanDeployment, Set<AnnotationInstance> bindings, List<Injection> injections, int priority) {
        super(target, beanDeployment, BuiltinScope.DEPENDENT.getInfo(), Sets.singletonHashSet((Object)Type.create((DotName)target.asClass().name(), (Type.Kind)Type.Kind.CLASS)), new HashSet<AnnotationInstance>(), injections, null, null, false, Collections.emptyList(), null, false, null, priority);
        this.bindings = bindings;
        AnnotationStore store = beanDeployment.getAnnotationStore();
        ArrayList<MethodInfo> aroundInvokes = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> aroundConstructs = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> postConstructs = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> preDestroys = new ArrayList<MethodInfo>();
        ClassInfo aClass = target.asClass();
        while (aClass != null) {
            for (MethodInfo method : aClass.methods()) {
                if (Modifier.isStatic(method.flags())) continue;
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES) || store.hasAnnotation((AnnotationTarget)method, DotNames.DISPOSES)) {
                    throw new DefinitionException("An interceptor method cannot be marked @Produces or @Disposes - " + method + " in class: " + aClass);
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.AROUND_INVOKE)) {
                    aroundInvokes.add(this.validateSignature(method));
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.AROUND_CONSTRUCT)) {
                    aroundConstructs.add(this.validateSignature(method));
                }
                if (store.hasAnnotation((AnnotationTarget)method, DotNames.POST_CONSTRUCT)) {
                    postConstructs.add(this.validateSignature(method));
                }
                if (!store.hasAnnotation((AnnotationTarget)method, DotNames.PRE_DESTROY)) continue;
                preDestroys.add(this.validateSignature(method));
            }
            for (FieldInfo field : aClass.fields()) {
                if (!store.hasAnnotation((AnnotationTarget)field, DotNames.PRODUCES)) continue;
                throw new DefinitionException("An interceptor field cannot be marked @Produces - " + field + " in class: " + aClass);
            }
            DotName superTypeName = aClass.superName();
            aClass = superTypeName == null || DotNames.OBJECT.equals((Object)superTypeName) ? null : IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superTypeName);
        }
        this.aroundInvoke = aroundInvokes.isEmpty() ? null : (MethodInfo)aroundInvokes.get(0);
        this.aroundConstruct = aroundConstructs.isEmpty() ? null : (MethodInfo)aroundConstructs.get(0);
        this.postConstruct = postConstructs.isEmpty() ? null : (MethodInfo)postConstructs.get(0);
        MethodInfo methodInfo = this.preDestroy = preDestroys.isEmpty() ? null : (MethodInfo)preDestroys.get(0);
        if (this.aroundConstruct == null && this.aroundInvoke == null && this.preDestroy == null && this.postConstruct == null) {
            LOGGER.warnf("%s declares no around-invoke method nor a lifecycle callback!", (Object)this);
        }
    }

    private MethodInfo validateSignature(MethodInfo method) {
        List parameters = method.parameterTypes();
        if (parameters.size() != 1 || !((Type)parameters.get(0)).name().equals((Object)DotNames.INVOCATION_CONTEXT) && !((Type)parameters.get(0)).name().equals((Object)DotNames.ARC_INVOCATION_CONTEXT)) {
            throw new IllegalStateException("An interceptor method must accept exactly one parameter of type jakarta.interceptor.InvocationContext: " + method + " declared on " + method.declaringClass());
        }
        if (!method.returnType().kind().equals((Object)Type.Kind.VOID) && !method.returnType().name().equals((Object)DotNames.OBJECT)) {
            throw new IllegalStateException("The return type of an interceptor method must be java.lang.Object or void: " + method + " declared on " + method.declaringClass());
        }
        return method;
    }

    public Set<AnnotationInstance> getBindings() {
        return this.bindings;
    }

    public MethodInfo getAroundInvoke() {
        return this.aroundInvoke;
    }

    public MethodInfo getAroundConstruct() {
        return this.aroundConstruct;
    }

    public MethodInfo getPostConstruct() {
        return this.postConstruct;
    }

    public MethodInfo getPreDestroy() {
        return this.preDestroy;
    }

    public boolean intercepts(InterceptionType interceptionType) {
        switch (interceptionType) {
            case AROUND_INVOKE: {
                return this.aroundInvoke != null;
            }
            case AROUND_CONSTRUCT: {
                return this.aroundConstruct != null;
            }
            case POST_CONSTRUCT: {
                return this.postConstruct != null;
            }
            case PRE_DESTROY: {
                return this.preDestroy != null;
            }
        }
        return false;
    }

    @Override
    public boolean isInterceptor() {
        return true;
    }

    @Override
    public String toString() {
        return "INTERCEPTOR bean [bindings=" + this.bindings + ", target=" + this.getTarget() + "]";
    }

    @Override
    public int compareTo(InterceptorInfo other) {
        return this.getTarget().toString().compareTo(other.getTarget().toString());
    }
}

