/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.TypesReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class AnnotationsReflection {
    AnnotationsReflection() {
    }

    static AnnotationInstance jandexAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = AnnotationsReflection.annotationType(annotation);
        DotName name = DotName.createSimple((String)annotationType.getName());
        AnnotationValue[] jandexAnnotationValues = AnnotationsReflection.jandexAnnotationValues(annotationType, annotation);
        return AnnotationInstance.create((DotName)name, null, (AnnotationValue[])jandexAnnotationValues);
    }

    private static Class<? extends Annotation> annotationType(Annotation annotation) {
        Class annotationType = null;
        ArrayDeque candidates = new ArrayDeque();
        candidates.add(annotation.getClass());
        while (!candidates.isEmpty()) {
            Class candidate = (Class)candidates.remove();
            if (candidate.isAnnotation()) {
                annotationType = candidate;
                break;
            }
            Collections.addAll(candidates, candidate.getInterfaces());
        }
        if (annotationType == null) {
            throw new IllegalArgumentException("Not an annotation: " + annotation);
        }
        return annotationType;
    }

    private static <A extends Annotation> AnnotationValue[] jandexAnnotationValues(Class<A> annotationType, A annotationInstance) {
        ArrayList<AnnotationValue> result = new ArrayList<AnnotationValue>();
        for (Method member : annotationType.getDeclaredMethods()) {
            try {
                if (!member.canAccess(annotationInstance)) {
                    member.setAccessible(true);
                }
                result.add(AnnotationsReflection.jandexAnnotationValue(member.getName(), member.invoke(annotationInstance, new Object[0])));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        return result.toArray(new AnnotationValue[0]);
    }

    private static AnnotationValue jandexAnnotationValue(String name, Object value) {
        if (value instanceof Boolean) {
            return AnnotationValue.createBooleanValue((String)name, (boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return AnnotationValue.createByteValue((String)name, (byte)((Byte)value));
        }
        if (value instanceof Short) {
            return AnnotationValue.createShortValue((String)name, (short)((Short)value));
        }
        if (value instanceof Integer) {
            return AnnotationValue.createIntegerValue((String)name, (int)((Integer)value));
        }
        if (value instanceof Long) {
            return AnnotationValue.createLongValue((String)name, (long)((Long)value));
        }
        if (value instanceof Float) {
            return AnnotationValue.createFloatValue((String)name, (float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return AnnotationValue.createDoubleValue((String)name, (double)((Double)value));
        }
        if (value instanceof Character) {
            return AnnotationValue.createCharacterValue((String)name, (char)((Character)value).charValue());
        }
        if (value instanceof String) {
            return AnnotationValue.createStringValue((String)name, (String)((String)value));
        }
        if (value instanceof Enum) {
            return AnnotationValue.createEnumValue((String)name, (DotName)DotName.createSimple((String)((Enum)value).getDeclaringClass().getName()), (String)((Enum)value).name());
        }
        if (value instanceof Class) {
            return AnnotationValue.createClassValue((String)name, (Type)TypesReflection.jandexType((Class)value));
        }
        if (value.getClass().isAnnotation()) {
            Class<? extends Annotation> annotationType = AnnotationsReflection.annotationType((Annotation)value);
            AnnotationValue[] jandexAnnotationValues = AnnotationsReflection.jandexAnnotationValues(annotationType, (Annotation)value);
            AnnotationInstance jandexAnnotation = AnnotationInstance.create((DotName)DotName.createSimple((String)annotationType.getName()), null, (AnnotationValue[])jandexAnnotationValues);
            return AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)jandexAnnotation);
        }
        if (value.getClass().isArray()) {
            AnnotationValue[] jandexAnnotationValues = (AnnotationValue[])Arrays.stream(AnnotationsReflection.boxArray(value)).map(it -> AnnotationsReflection.jandexAnnotationValue(name, it)).toArray(AnnotationValue[]::new);
            return AnnotationValue.createArrayValue((String)name, (AnnotationValue[])jandexAnnotationValues);
        }
        throw new IllegalArgumentException("Unknown annotation attribute value: " + value);
    }

    private static Object[] boxArray(Object value) {
        if (value instanceof boolean[]) {
            boolean[] primitiveArray = (boolean[])value;
            Object[] boxedArray = new Boolean[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof byte[]) {
            byte[] primitiveArray = (byte[])value;
            Object[] boxedArray = new Byte[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof short[]) {
            short[] primitiveArray = (short[])value;
            Object[] boxedArray = new Short[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof int[]) {
            int[] primitiveArray = (int[])value;
            Object[] boxedArray = new Integer[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof long[]) {
            long[] primitiveArray = (long[])value;
            Object[] boxedArray = new Long[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof float[]) {
            float[] primitiveArray = (float[])value;
            Object[] boxedArray = new Float[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = Float.valueOf(primitiveArray[i]);
            }
            return boxedArray;
        }
        if (value instanceof double[]) {
            double[] primitiveArray = (double[])value;
            Object[] boxedArray = new Double[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = primitiveArray[i];
            }
            return boxedArray;
        }
        if (value instanceof char[]) {
            char[] primitiveArray = (char[])value;
            Object[] boxedArray = new Character[primitiveArray.length];
            for (int i = 0; i < primitiveArray.length; ++i) {
                boxedArray[i] = Character.valueOf(primitiveArray[i]);
            }
            return boxedArray;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        throw new IllegalArgumentException("Not an array: " + value);
    }
}

