/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusDevModeLauncher;
import io.quarkus.maven.MavenDevModeLauncher;
import io.quarkus.maven.MojoLogger;
import io.quarkus.maven.QuarkusBootstrapProvider;
import io.quarkus.maven.components.CompilerOptions;
import io.quarkus.maven.components.MavenVersionEnforcer;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aesh.readline.terminal.impl.ExecPty;
import org.aesh.readline.terminal.impl.Pty;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.utils.ANSI;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="dev", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class DevMojo
extends AbstractMojo {
    private static final String EXT_PROPERTIES_PATH = "META-INF/quarkus-extension.properties";
    private static final String KOTLIN_MAVEN_PLUGIN_GA = "org.jetbrains.kotlin:kotlin-maven-plugin";
    private static final List<String> POST_COMPILE_PHASES = List.of("compile", "process-classes", "generate-test-sources", "process-test-sources", "generate-test-resources", "process-test-resources", "test-compile", "process-test-classes", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    private static final List<String> POST_TEST_COMPILE_PHASES = List.of("test-compile", "process-test-classes", "test", "prepare-package", "package", "pre-integration-test", "integration-test", "post-integration-test", "verify", "install", "deploy");
    private static final String QUARKUS_GENERATE_CODE_GOAL = "generate-code";
    private static final String QUARKUS_GENERATE_CODE_TESTS_GOAL = "generate-code-tests";
    private static final String ORG_APACHE_MAVEN_PLUGINS = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN = "maven-compiler-plugin";
    private static final String MAVEN_RESOURCES_PLUGIN = "maven-resources-plugin";
    private static final String MAVEN_TOOLCHAINS_PLUGIN = "maven-toolchains-plugin";
    private static final String ORG_JETBRAINS_KOTLIN = "org.jetbrains.kotlin";
    private static final String KOTLIN_MAVEN_PLUGIN = "kotlin-maven-plugin";
    private static final String ORG_JBOSS_JANDEX = "org.jboss.jandex";
    private static final String JANDEX_MAVEN_PLUGIN = "jandex-maven-plugin";
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${debug}")
    private String debug;
    @Parameter(defaultValue="${open-lang-package}")
    private boolean openJavaLang;
    @Parameter(defaultValue="${suspend}")
    private String suspend;
    @Parameter(defaultValue="${debugHost}")
    private String debugHost;
    @Parameter(defaultValue="${debugPort}")
    private String debugPort;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDir;
    @Parameter
    private File workingDir;
    @Parameter(defaultValue="${jvm.args}")
    private String jvmArgs;
    @Parameter(defaultValue="${quarkus.args}")
    private String argsString;
    @Parameter
    private Map<String, String> environmentVariables = Collections.emptyMap();
    @Parameter
    private Map<String, String> systemProperties = Collections.emptyMap();
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="TRUE")
    private boolean deleteDevJar;
    @Component
    private MavenVersionEnforcer mavenVersionEnforcer;
    @Component
    private RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepositoryManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${preventnoverify}")
    private boolean preventnoverify = false;
    @Parameter(defaultValue="${noDeps}")
    private boolean noDeps = false;
    @Parameter
    private List<String> compilerArgs;
    @Parameter
    private List<CompilerOptions> compilerOptions;
    @Parameter(defaultValue="${maven.compiler.release}")
    private String release;
    @Parameter(defaultValue="${maven.compiler.source}")
    private String source;
    @Parameter(defaultValue="${maven.compiler.target}")
    private String target;
    @Parameter(defaultValue="${quarkus.enforceBuildGoal}")
    private boolean enforceBuildGoal = true;
    @Component
    private WorkspaceReader wsReader;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ToolchainManager toolchainManager;
    private Map<GACT, Plugin> pluginMap;
    @Component
    protected QuarkusBootstrapProvider bootstrapProvider;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    MojoExecution mojoExecution;
    private Attributes attributes;
    private int windowsAttributes;
    private boolean windowsAttributesSet;
    private Pty pty;
    private boolean windowsColorSupport;

    public void setLog(Log log) {
        super.setLog(log);
        MojoLogger.delegate = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        PluginDescriptor pluginDescr;
        Plugin pluginDef;
        this.mavenVersionEnforcer.ensureMavenVersion(this.getLog(), this.session);
        this.initToolchain();
        this.handleAutoCompile();
        if (this.enforceBuildGoal && ((pluginDef = this.getConfiguredPluginOrNull((pluginDescr = this.getPluginDescriptor()).getGroupId(), pluginDescr.getArtifactId())) == null || !this.isGoalConfigured(pluginDef, "build"))) {
            this.getLog().warn((CharSequence)"The quarkus-maven-plugin build goal was not configured for this project, skipping quarkus:dev as this is assumed to be a support library. If you want to run quarkus:dev on this project make sure the quarkus-maven-plugin is configured with the build goal or disable the enforceBuildGoal flag (via plugin configuration or via -Dquarkus.enforceBuildGoal=false).");
            return;
        }
        this.saveTerminalState();
        try {
            DevModeRunner runner = new DevModeRunner();
            Map<Path, Long> pomFiles = this.readPomFileTimestamps(runner);
            runner.run();
            long nextCheck = System.currentTimeMillis() + 100L;
            while (true) {
                DevModeRunner newRunner;
                this.suspend = "n";
                long sleep = Math.max(0L, nextCheck - System.currentTimeMillis()) + 1L;
                Thread.sleep(sleep);
                if (System.currentTimeMillis() <= nextCheck) continue;
                nextCheck = System.currentTimeMillis() + 100L;
                if (!runner.alive()) {
                    this.restoreTerminalState();
                    if (!runner.isExpectedExitValue()) {
                        throw new MojoExecutionException("Dev mode process did not complete successfully");
                    }
                    return;
                }
                HashSet<Path> changed = new HashSet<Path>();
                for (Map.Entry<Path, Long> e : pomFiles.entrySet()) {
                    long t = Files.getLastModifiedTime(e.getKey(), new LinkOption[0]).toMillis();
                    if (t <= e.getValue()) continue;
                    changed.add(e.getKey());
                    pomFiles.put(e.getKey(), t);
                }
                if (changed.isEmpty()) continue;
                this.getLog().info((CharSequence)("Changes detected to " + changed + ", restarting dev mode"));
                try {
                    this.triggerCompile(false, false);
                    this.triggerCompile(true, false);
                    newRunner = new DevModeRunner();
                }
                catch (Exception e) {
                    this.getLog().info((CharSequence)"Could not load changed pom.xml file, changes not applied", (Throwable)e);
                    continue;
                }
                runner.stop();
                newRunner.run();
                runner = newRunner;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to run", (Throwable)e);
        }
    }

    private void saveTerminalState() {
        try {
            long hConsole;
            this.windowsAttributes = WindowsSupport.getConsoleMode();
            this.windowsAttributesSet = true;
            if (this.windowsAttributes > 0 && (hConsole = Kernel32.GetStdHandle(Kernel32.STD_INPUT_HANDLE)) != (long)Kernel32.INVALID_HANDLE_VALUE) {
                int VIRTUAL_TERMINAL_PROCESSING = 4;
                if (Kernel32.SetConsoleMode(hConsole, this.windowsAttributes | 4) != 0) {
                    this.windowsColorSupport = true;
                }
            }
        }
        catch (Throwable t) {
            try {
                Pty pty = ExecPty.current();
                this.attributes = pty.getAttr();
                this.pty = pty;
            }
            catch (Exception e) {
                this.getLog().debug((CharSequence)"Failed to get a local tty", (Throwable)e);
            }
        }
    }

    private void restoreTerminalState() {
        if (this.windowsAttributesSet) {
            WindowsSupport.setConsoleMode(this.windowsAttributes);
        } else {
            if (this.attributes == null || this.pty == null) {
                return;
            }
            Pty finalPty = this.pty;
            try (Pty pty = finalPty;){
                finalPty.setAttr(this.attributes);
                int height = finalPty.getSize().getHeight();
                String sb = ANSI.MAIN_BUFFER + "\u001b[?25h\u001b[0m\u001b[" + height + ";0H";
                finalPty.getSlaveOutput().write(sb.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Error restoring console state", (Throwable)e);
            }
        }
    }

    private void handleAutoCompile() throws MojoExecutionException {
        boolean compileNeeded = true;
        boolean testCompileNeeded = true;
        boolean prepareNeeded = true;
        boolean prepareTestsNeeded = true;
        String jandexGoalPhase = this.getGoalPhaseOrNull(ORG_JBOSS_JANDEX, JANDEX_MAVEN_PLUGIN, "jandex", "process-classes");
        boolean indexClassNeeded = jandexGoalPhase != null;
        List<String> goals = this.session.getGoals();
        if (goals.isEmpty() && !StringUtils.isEmpty((CharSequence)this.project.getDefaultGoal())) {
            goals = List.of(StringUtils.split((String)this.project.getDefaultGoal()));
        }
        for (String goal : goals) {
            if (goal.endsWith("quarkus:generate-code")) {
                prepareNeeded = false;
            }
            if (goal.endsWith("quarkus:generate-code-tests")) {
                prepareTestsNeeded = false;
            }
            if (POST_COMPILE_PHASES.contains(goal)) {
                compileNeeded = false;
            }
            if (jandexGoalPhase != null && POST_COMPILE_PHASES.indexOf(goal) >= POST_COMPILE_PHASES.indexOf(jandexGoalPhase)) {
                indexClassNeeded = false;
            }
            if (POST_TEST_COMPILE_PHASES.contains(goal)) {
                testCompileNeeded = false;
            }
            if (!goal.endsWith("quarkus:dev")) continue;
            break;
        }
        if (compileNeeded) {
            this.triggerCompile(false, prepareNeeded);
        }
        if (indexClassNeeded) {
            this.initClassIndexes();
        }
        if (testCompileNeeded) {
            try {
                this.triggerCompile(true, prepareTestsNeeded);
            }
            catch (Throwable t) {
                this.getLog().error((CharSequence)"Test compile failed, you will need to fix your tests before you can use continuous testing", t);
            }
        }
    }

    private void initToolchain() throws MojoExecutionException {
        this.executeIfConfigured(ORG_APACHE_MAVEN_PLUGINS, MAVEN_TOOLCHAINS_PLUGIN, "toolchain", Collections.emptyMap());
    }

    private void triggerPrepare(boolean test) throws MojoExecutionException {
        PluginDescriptor pluginDescr = this.getPluginDescriptor();
        this.executeIfConfigured(pluginDescr.getGroupId(), pluginDescr.getArtifactId(), test ? QUARKUS_GENERATE_CODE_TESTS_GOAL : QUARKUS_GENERATE_CODE_GOAL, Map.of("mode", LaunchMode.DEVELOPMENT.name(), "closeBootstrappedApp", "false"));
    }

    private void initClassIndexes() throws MojoExecutionException {
        this.executeIfConfigured(ORG_JBOSS_JANDEX, JANDEX_MAVEN_PLUGIN, "jandex", Collections.emptyMap());
    }

    private PluginDescriptor getPluginDescriptor() {
        return this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
    }

    private void triggerCompile(boolean test, boolean prepareNeeded) throws MojoExecutionException {
        this.handleResources(test);
        if (prepareNeeded) {
            this.triggerPrepare(test);
        }
        this.executeIfConfigured(ORG_JETBRAINS_KOTLIN, KOTLIN_MAVEN_PLUGIN, test ? "test-compile" : "compile", Collections.emptyMap());
        this.executeIfConfigured(ORG_APACHE_MAVEN_PLUGINS, MAVEN_COMPILER_PLUGIN, test ? "testCompile" : "compile", Collections.emptyMap());
    }

    private void handleResources(boolean test) throws MojoExecutionException {
        List resources = this.project.getResources();
        if (resources.isEmpty()) {
            return;
        }
        this.executeIfConfigured(ORG_APACHE_MAVEN_PLUGINS, MAVEN_RESOURCES_PLUGIN, test ? "testResources" : "resources", Collections.emptyMap());
    }

    private void executeIfConfigured(String pluginGroupId, String pluginArtifactId, String goal, Map<String, String> params) throws MojoExecutionException {
        Plugin plugin = this.getConfiguredPluginOrNull(pluginGroupId, pluginArtifactId);
        if (!this.isGoalConfigured(plugin, goal)) {
            return;
        }
        this.getLog().info((CharSequence)("Invoking " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion() + ":" + goal + ") @ " + this.project.getArtifactId()));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)pluginGroupId), (String)MojoExecutor.artifactId((String)pluginArtifactId), (String)MojoExecutor.version((String)plugin.getVersion()), (List)plugin.getDependencies()), (String)MojoExecutor.goal((String)goal), (Xpp3Dom)this.getPluginConfig(plugin, goal, params), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private String getGoalPhaseOrNull(String groupId, String artifactId, String goal, String defaultPhase) {
        Plugin plugin = this.getConfiguredPluginOrNull(groupId, artifactId);
        if (plugin == null) {
            return null;
        }
        for (PluginExecution pluginExecution : plugin.getExecutions()) {
            if (!pluginExecution.getGoals().contains(goal)) continue;
            String configuredPhase = pluginExecution.getPhase();
            return configuredPhase != null ? configuredPhase : defaultPhase;
        }
        return null;
    }

    public boolean isGoalConfigured(Plugin plugin, String goal) {
        if (plugin == null) {
            return false;
        }
        for (PluginExecution pluginExecution : plugin.getExecutions()) {
            if (!pluginExecution.getGoals().contains(goal)) continue;
            return true;
        }
        return false;
    }

    private Xpp3Dom getPluginConfig(Plugin plugin, String goal, Map<String, String> params) throws MojoExecutionException {
        Xpp3Dom mergedConfig = null;
        if (!plugin.getExecutions().isEmpty()) {
            for (PluginExecution exec : plugin.getExecutions()) {
                if (exec.getConfiguration() == null || !exec.getGoals().contains(goal)) continue;
                mergedConfig = mergedConfig == null ? (Xpp3Dom)exec.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)exec.getConfiguration()), (Boolean)true);
            }
        }
        if ((Xpp3Dom)plugin.getConfiguration() != null) {
            mergedConfig = mergedConfig == null ? (Xpp3Dom)plugin.getConfiguration() : Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)((Xpp3Dom)plugin.getConfiguration()), (Boolean)true);
        }
        Xpp3Dom configuration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]);
        if (mergedConfig != null) {
            Set supportedParams = null;
            for (Xpp3Dom child : mergedConfig.getChildren()) {
                if (child.getName().startsWith("test")) continue;
                if (supportedParams == null) {
                    supportedParams = this.getMojoDescriptor(plugin, goal).getParameterMap().keySet();
                }
                if (!supportedParams.contains(child.getName())) continue;
                configuration.addChild(child);
            }
        }
        for (Map.Entry<String, String> param : params.entrySet()) {
            Xpp3Dom p = new Xpp3Dom(param.getKey());
            p.setValue(param.getValue());
            configuration.addChild(p);
        }
        return configuration;
    }

    private MojoDescriptor getMojoDescriptor(Plugin plugin, String goal) throws MojoExecutionException {
        try {
            return this.pluginManager.getMojoDescriptor(plugin, goal, this.pluginRepos, this.repoSession);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to obtain descriptor for Maven plugin " + plugin.getId() + " goal " + goal, e);
        }
    }

    private Plugin getConfiguredPluginOrNull(String groupId, String artifactId) {
        if (this.pluginMap == null) {
            this.pluginMap = new HashMap<GACT, Plugin>();
            for (Plugin p : this.project.getBuildPlugins()) {
                this.pluginMap.put(new GACT(p.getGroupId(), p.getArtifactId()), p);
            }
        }
        return this.pluginMap.get(new GACT(groupId, artifactId));
    }

    private Map<Path, Long> readPomFileTimestamps(DevModeRunner runner) throws IOException {
        HashMap<Path, Long> ret = new HashMap<Path, Long>();
        for (Path i : runner.pomFiles()) {
            ret.put(i, Files.getLastModifiedTime(i, new LinkOption[0]).toMillis());
        }
        return ret;
    }

    private String getSourceEncoding() {
        Object sourceEncodingProperty = this.project.getProperties().get("project.build.sourceEncoding");
        if (sourceEncodingProperty != null) {
            return (String)sourceEncodingProperty;
        }
        return null;
    }

    private void addProject(MavenDevModeLauncher.Builder builder, ResolvedDependency module, boolean root) throws Exception {
        Path sourceParent;
        Set<Path> testSourcePaths;
        Set<Path> sourcePaths;
        String projectDirectory;
        if (!module.isJar()) {
            return;
        }
        String classesPath = null;
        String testClassesPath = null;
        List activeProfiles = Collections.emptyList();
        MavenProject mavenProject = module.getClassifier().isEmpty() ? (MavenProject)this.session.getProjectMap().get(String.format("%s:%s:%s", module.getGroupId(), module.getArtifactId(), module.getVersion())) : null;
        ArtifactSources sources = module.getSources();
        if (mavenProject == null) {
            if (sources == null) {
                this.getLog().debug((CharSequence)("Local dependency " + module.toCompactCoords() + " does not appear to have any sources"));
                return;
            }
            projectDirectory = module.getWorkspaceModule().getModuleDir().getAbsolutePath();
            sourcePaths = new LinkedHashSet();
            for (Object src : sources.getSourceDirs()) {
                for (Object p : src.getSourceTree().getRoots()) {
                    sourcePaths.add(p.toAbsolutePath());
                }
            }
            testSourcePaths = new LinkedHashSet();
            ArtifactSources testSources = module.getWorkspaceModule().getTestSources();
            if (testSources != null) {
                for (Object src : testSources.getSourceDirs()) {
                    for (Object p : src.getSourceTree().getRoots()) {
                        testSourcePaths.add(p.toAbsolutePath());
                    }
                }
            }
        } else {
            projectDirectory = mavenProject.getBasedir().getPath();
            sourcePaths = mavenProject.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toCollection(LinkedHashSet::new));
            testSourcePaths = mavenProject.getTestCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toCollection(LinkedHashSet::new));
            activeProfiles = mavenProject.getActiveProfiles();
        }
        if (sourcePaths.isEmpty()) {
            if (sources == null || sources.getResourceDirs() == null) {
                throw new MojoExecutionException("Local dependency " + module.toCompactCoords() + " does not appear to have any sources");
            }
            sourceParent = ((SourceDir)sources.getResourceDirs().iterator().next()).getDir().toAbsolutePath().getParent();
        } else {
            sourceParent = ((Path)sourcePaths.iterator().next()).toAbsolutePath().getParent();
        }
        Path classesDir = null;
        LinkedHashSet<Path> resourcePaths = new LinkedHashSet<Path>();
        if (sources != null) {
            classesDir = ((SourceDir)sources.getSourceDirs().iterator().next()).getOutputDir().toAbsolutePath();
            if (Files.isDirectory(classesDir, new LinkOption[0])) {
                classesPath = classesDir.toString();
            }
            for (SourceDir src : sources.getResourceDirs()) {
                for (Object p : src.getSourceTree().getRoots()) {
                    resourcePaths.add(p.toAbsolutePath());
                }
            }
        }
        if (module.getWorkspaceModule().hasTestSources()) {
            Path testClassesDir = ((SourceDir)module.getWorkspaceModule().getTestSources().getSourceDirs().iterator().next()).getOutputDir().toAbsolutePath();
            testClassesPath = testClassesDir.toString();
        }
        LinkedHashSet<Path> testResourcePaths = new LinkedHashSet<Path>();
        ArtifactSources testSources = module.getWorkspaceModule().getTestSources();
        if (testSources != null) {
            for (SourceDir src : testSources.getResourceDirs()) {
                for (Path p : src.getSourceTree().getRoots()) {
                    testResourcePaths.add(p.toAbsolutePath());
                }
            }
        }
        for (Profile profile : activeProfiles) {
            BuildBase build = profile.getBuild();
            if (build == null) continue;
            resourcePaths.addAll(build.getResources().stream().map(FileSet::getDirectory).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toList()));
            testResourcePaths.addAll(build.getTestResources().stream().map(FileSet::getDirectory).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).collect(Collectors.toList()));
        }
        if (!(classesPath != null || sourcePaths.isEmpty() && resourcePaths.isEmpty())) {
            throw new MojoExecutionException("Hot reloadable dependency " + module.getWorkspaceModule().getId() + " has not been compiled yet (the classes directory " + (Comparable)(classesDir == null ? "" : classesDir) + " does not exist)");
        }
        Path targetDir = Path.of(this.project.getBuild().getDirectory(), new String[0]);
        DevModeContext.ModuleInfo moduleInfo = new DevModeContext.ModuleInfo.Builder().setArtifactKey(module.getKey()).setProjectDirectory(projectDirectory).setSourcePaths((PathCollection)PathList.from(sourcePaths)).setClassesPath(classesPath).setResourcesOutputPath(classesPath).setResourcePaths((PathCollection)PathList.from(resourcePaths)).setSourceParents((PathCollection)PathList.of((Path[])new Path[]{sourceParent.toAbsolutePath()})).setPreBuildOutputDir(targetDir.resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(targetDir.toAbsolutePath().toString()).setTestSourcePaths((PathCollection)PathList.from(testSourcePaths)).setTestClassesPath(testClassesPath).setTestResourcesOutputPath(testClassesPath).setTestResourcePaths((PathCollection)PathList.from(testResourcePaths)).build();
        if (root) {
            builder.mainModule(moduleInfo);
        } else {
            builder.dependency(moduleInfo);
        }
    }

    private QuarkusDevModeLauncher newLauncher() throws Exception {
        MavenArtifactResolver.Builder resolverBuilder;
        Xpp3Dom compilerPluginArgsConfiguration;
        Toolchain toolchain;
        String java = null;
        if (this.toolchainManager != null && (toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session)) != null) {
            java = toolchain.findTool("java");
            this.getLog().info((CharSequence)("JVM from toolchain: " + java));
        }
        MavenDevModeLauncher.Builder builder = (MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)((MavenDevModeLauncher.Builder)MavenDevModeLauncher.builder(java, this.getLog()).preventnoverify(this.preventnoverify)).buildDir(this.buildDir)).outputDir(this.outputDirectory)).suspend(this.suspend)).debug(this.debug)).debugHost(this.debugHost)).debugPort(this.debugPort)).deleteDevJar(this.deleteDevJar);
        this.setJvmArgs(builder);
        if (this.windowsColorSupport) {
            builder.jvmArgs("-Dio.quarkus.force-color-support=true");
        }
        if (this.openJavaLang) {
            builder.jvmArgs("--add-opens");
            builder.jvmArgs("java.base/java.lang=ALL-UNNAMED");
        }
        builder.projectDir(this.project.getFile().getParentFile());
        builder.buildSystemProperties(this.project.getProperties());
        builder.applicationName(this.project.getArtifactId());
        builder.applicationVersion(this.project.getVersion());
        builder.sourceEncoding(this.getSourceEncoding());
        if (this.compilerOptions != null) {
            for (CompilerOptions compilerOption : this.compilerOptions) {
                builder.compilerOptions(compilerOption.getName(), compilerOption.getArgs());
            }
        }
        Optional<Xpp3Dom> compilerPluginConfiguration = this.findCompilerPluginConfiguration();
        if (this.compilerArgs != null) {
            builder.compilerOptions("java", this.compilerArgs);
        } else if (compilerPluginConfiguration.isPresent() && (compilerPluginArgsConfiguration = compilerPluginConfiguration.get().getChild("compilerArgs")) != null) {
            ArrayList<String> compilerPluginArgs = new ArrayList<String>();
            for (Xpp3Dom argConfiguration : compilerPluginArgsConfiguration.getChildren()) {
                compilerPluginArgs.add(argConfiguration.getValue());
            }
            if (compilerPluginArgsConfiguration.getValue() != null && !compilerPluginArgsConfiguration.getValue().isEmpty()) {
                compilerPluginArgs.add(compilerPluginArgsConfiguration.getValue().trim());
            }
            builder.compilerOptions("java", compilerPluginArgs);
        }
        if (this.release != null) {
            builder.releaseJavaVersion(this.release);
        } else if (compilerPluginConfiguration.isPresent()) {
            this.applyCompilerFlag(compilerPluginConfiguration, "release", arg_0 -> ((MavenDevModeLauncher.Builder)builder).releaseJavaVersion(arg_0));
        }
        if (this.source != null) {
            builder.sourceJavaVersion(this.source);
        } else if (compilerPluginConfiguration.isPresent()) {
            this.applyCompilerFlag(compilerPluginConfiguration, "source", arg_0 -> ((MavenDevModeLauncher.Builder)builder).sourceJavaVersion(arg_0));
        }
        if (this.target != null) {
            builder.targetJavaVersion(this.target);
        } else if (compilerPluginConfiguration.isPresent()) {
            this.applyCompilerFlag(compilerPluginConfiguration, "target", arg_0 -> ((MavenDevModeLauncher.Builder)builder).targetJavaVersion(arg_0));
        }
        this.setKotlinSpecificFlags(builder);
        Path appModelLocation = this.resolveSerializedModelLocation();
        ApplicationModel appModel = this.bootstrapProvider.getResolvedApplicationModel(QuarkusBootstrapProvider.getProjectId(this.project), LaunchMode.DEVELOPMENT);
        if (appModel != null) {
            this.bootstrapProvider.close();
        } else {
            resolverBuilder = (MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositories(this.repos)).setRemoteRepositoryManager(this.remoteRepositoryManager)).setWorkspaceDiscovery(true)).setPreferPomsFromWorkspace(true)).setCurrentProject(this.project.getFile().toString());
            boolean reinitializeMavenSession = Files.exists(appModelLocation, new LinkOption[0]);
            if (reinitializeMavenSession) {
                Files.delete(appModelLocation);
            } else {
                ((MavenArtifactResolver.Builder)resolverBuilder.setRepositorySystemSession(this.repoSession)).setRepositorySystem(this.repoSystem);
            }
            appModel = new BootstrapAppModelResolver(resolverBuilder.build()).setDevMode(true).setCollectReloadableDependencies(!this.noDeps).resolveModel(GACTV.jar((String)this.project.getGroupId(), (String)this.project.getArtifactId(), (String)this.project.getVersion()));
        }
        BootstrapUtils.serializeAppModel((ApplicationModel)appModel, (Path)appModelLocation);
        builder.jvmArgs("-Dquarkus-internal.serialized-app-model.path=" + appModelLocation);
        if (this.noDeps) {
            this.addProject(builder, appModel.getAppArtifact(), true);
            appModel.getApplicationModule().getBuildFiles().forEach(p -> builder.watchedBuildFile((Path)p));
            builder.localArtifact(ArtifactKey.of((String)this.project.getGroupId(), (String)this.project.getArtifactId(), null, (String)"jar"));
        } else {
            resolverBuilder = DependenciesFilter.getReloadableModules((ApplicationModel)appModel).iterator();
            while (resolverBuilder.hasNext()) {
                ResolvedDependency project;
                this.addProject(builder, project, (project = (ResolvedDependency)resolverBuilder.next()) == appModel.getAppArtifact());
                project.getWorkspaceModule().getBuildFiles().forEach(p -> builder.watchedBuildFile((Path)p));
                builder.localArtifact(project.getKey());
            }
        }
        this.addQuarkusDevModeDeps(builder);
        HashSet<Path> resourceDirs = new HashSet<Path>();
        for (Resource resource : this.project.getResources()) {
            String dir = resource.getDirectory();
            Path path = Paths.get(dir, new String[0]);
            resourceDirs.add(path);
        }
        Collection configuredParentFirst = ConfiguredClassLoading.builder().setApplicationModel(appModel).setApplicationRoot((PathCollection)PathsCollection.from(resourceDirs)).setMode(QuarkusBootstrap.Mode.DEV).build().getParentFirstArtifacts();
        for (Artifact appDep : this.project.getArtifacts()) {
            ArtifactKey key = ArtifactKey.of((String)appDep.getGroupId(), (String)appDep.getArtifactId(), (String)appDep.getClassifier(), (String)appDep.getArtifactHandler().getExtension());
            if (builder.isLocal(key) || !configuredParentFirst.contains(key)) continue;
            builder.classpathEntry(appDep.getFile());
        }
        builder.baseName(this.project.getBuild().getFinalName());
        this.modifyDevModeContext(builder);
        if (this.argsString != null) {
            builder.applicationArgs(this.argsString);
        }
        this.propagateUserProperties(builder);
        return builder.build();
    }

    private void setJvmArgs(MavenDevModeLauncher.Builder builder) throws Exception {
        String jvmArgs = this.jvmArgs;
        if (!this.systemProperties.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            if (jvmArgs != null) {
                buf.append(jvmArgs);
            }
            for (Map.Entry<String, String> prop : this.systemProperties.entrySet()) {
                buf.append(" -D").append(prop.getKey()).append("=\"").append(prop.getValue()).append("\"");
            }
            jvmArgs = buf.toString();
        }
        if (jvmArgs != null) {
            builder.jvmArgs(Arrays.asList(CommandLineUtils.translateCommandline((String)jvmArgs)));
        }
    }

    private void propagateUserProperties(MavenDevModeLauncher.Builder builder) {
        Properties userProps = BootstrapMavenOptions.newInstance().getSystemProperties();
        if (userProps == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("-D");
        for (Object o : userProps.keySet()) {
            String name = o.toString();
            String value = userProps.getProperty(name);
            buf.setLength(2);
            buf.append(name);
            if (value != null && !value.isEmpty()) {
                buf.append('=');
                buf.append(value);
            }
            builder.jvmArgs(buf.toString());
        }
    }

    private void applyCompilerFlag(Optional<Xpp3Dom> compilerPluginConfiguration, String flagName, Consumer<String> builderCall) {
        compilerPluginConfiguration.map(cfg -> cfg.getChild(flagName)).map(Xpp3Dom::getValue).map(String::trim).filter(Predicate.not(String::isEmpty)).ifPresent(builderCall);
    }

    private void addQuarkusDevModeDeps(MavenDevModeLauncher.Builder builder) throws MojoExecutionException, DependencyResolutionException {
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties";
        InputStream devModePomPropsIs = DevModeMain.class.getClassLoader().getResourceAsStream("META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties");
        if (devModePomPropsIs == null) {
            throw new MojoExecutionException("Failed to locate META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties on the classpath");
        }
        Properties devModeProps = new Properties();
        try (InputStream is = devModePomPropsIs;){
            devModeProps.load(is);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties from the classpath", (Exception)e);
        }
        String devModeGroupId = devModeProps.getProperty("groupId");
        if (devModeGroupId == null) {
            throw new MojoExecutionException("Classpath resource META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties is missing groupId");
        }
        String devModeArtifactId = devModeProps.getProperty("artifactId");
        if (devModeArtifactId == null) {
            throw new MojoExecutionException("Classpath resource META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties is missing artifactId");
        }
        String devModeVersion = devModeProps.getProperty("version");
        if (devModeVersion == null) {
            throw new MojoExecutionException("Classpath resource META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties is missing version");
        }
        DefaultArtifact devModeJar = new DefaultArtifact(devModeGroupId, devModeArtifactId, "jar", devModeVersion);
        DependencyResult cpRes = this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(new CollectRequest().setRoot(new Dependency((org.eclipse.aether.artifact.Artifact)devModeJar, "runtime")).setRepositories(this.repos)));
        for (ArtifactResult appDep : cpRes.getArtifactResults()) {
            if (appDep.getArtifact().getGroupId().equals("io.quarkus") && appDep.getArtifact().getArtifactId().equals("quarkus-ide-launcher")) continue;
            if (appDep.getArtifact().getGroupId().equals("io.quarkus") && appDep.getArtifact().getArtifactId().equals("quarkus-class-change-agent")) {
                builder.jvmArgs("-javaagent:" + appDep.getArtifact().getFile().getAbsolutePath());
                continue;
            }
            builder.classpathEntry(appDep.getArtifact().getFile());
        }
    }

    private void setKotlinSpecificFlags(MavenDevModeLauncher.Builder builder) {
        Xpp3Dom compilerPluginArgsConfiguration;
        Plugin kotlinMavenPlugin = null;
        for (Plugin plugin : this.project.getBuildPlugins()) {
            if (!plugin.getKey().equals(KOTLIN_MAVEN_PLUGIN_GA)) continue;
            kotlinMavenPlugin = plugin;
            break;
        }
        if (kotlinMavenPlugin == null) {
            return;
        }
        this.getLog().debug((CharSequence)"Kotlin Maven plugin detected");
        ArrayList<String> compilerPluginArtifacts = new ArrayList<String>();
        List dependencies = kotlinMavenPlugin.getDependencies();
        for (org.apache.maven.model.Dependency dependency : dependencies) {
            try {
                ArtifactResult resolvedArtifact = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest().setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion())).setRepositories(this.repos));
                compilerPluginArtifacts.add(resolvedArtifact.getArtifact().getFile().toPath().toAbsolutePath().toString());
            }
            catch (ArtifactResolutionException e) {
                this.getLog().warn((CharSequence)"Unable to properly setup dev-mode for Kotlin", (Throwable)e);
                return;
            }
        }
        builder.compilerPluginArtifacts(compilerPluginArtifacts);
        ArrayList<String> options = new ArrayList<String>();
        Xpp3Dom compilerPluginConfiguration = (Xpp3Dom)kotlinMavenPlugin.getConfiguration();
        if (compilerPluginConfiguration != null && (compilerPluginArgsConfiguration = compilerPluginConfiguration.getChild("pluginOptions")) != null) {
            for (Xpp3Dom argConfiguration : compilerPluginArgsConfiguration.getChildren()) {
                options.add(argConfiguration.getValue());
            }
        }
        builder.compilerPluginOptions(options);
    }

    protected void modifyDevModeContext(MavenDevModeLauncher.Builder builder) {
    }

    private Optional<Xpp3Dom> findCompilerPluginConfiguration() {
        for (Plugin plugin : this.project.getBuildPlugins()) {
            Xpp3Dom compilerPluginConfiguration;
            if (!plugin.getKey().equals("org.apache.maven.plugins:maven-compiler-plugin") || (compilerPluginConfiguration = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
            return Optional.of(compilerPluginConfiguration);
        }
        return Optional.empty();
    }

    private Path resolveSerializedModelLocation() {
        Path p = BootstrapUtils.resolveSerializedAppModelPath((Path)Paths.get(this.project.getBuild().getDirectory(), new String[0]));
        p.toFile().deleteOnExit();
        return p;
    }

    private class DevModeRunner {
        final QuarkusDevModeLauncher launcher;
        private Process process;

        private DevModeRunner() throws Exception {
            this.launcher = DevMojo.this.newLauncher();
        }

        Collection<Path> pomFiles() {
            return this.launcher.watchedBuildFiles();
        }

        boolean alive() {
            return this.process != null && this.process.isAlive();
        }

        int exitValue() {
            return this.process == null ? -1 : this.process.exitValue();
        }

        boolean isExpectedExitValue() {
            return this.exitValue() == 0 || this.exitValue() == 130;
        }

        void run() throws Exception {
            if (DevMojo.this.getLog().isDebugEnabled()) {
                DevMojo.this.getLog().debug((CharSequence)("Launching JVM with command line: " + String.join((CharSequence)" ", this.launcher.args())));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(this.launcher.args()).redirectErrorStream(true).inheritIO().directory(DevMojo.this.workingDir == null ? DevMojo.this.project.getBasedir() : DevMojo.this.workingDir);
            if (!DevMojo.this.environmentVariables.isEmpty()) {
                processBuilder.environment().putAll(DevMojo.this.environmentVariables);
            }
            this.process = processBuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    DevModeRunner.this.process.destroy();
                    try {
                        DevModeRunner.this.process.waitFor();
                    }
                    catch (InterruptedException e) {
                        DevMojo.this.getLog().warn((CharSequence)"Unable to properly wait for dev-mode end", (Throwable)e);
                    }
                }
            }, "Development Mode Shutdown Hook"));
        }

        void stop() throws InterruptedException {
            this.process.destroy();
            this.process.waitFor();
        }
    }
}

