/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

@Recorder
public class AmazonLambdaMapperRecorder {
    private static final Logger log = Logger.getLogger(AmazonLambdaMapperRecorder.class);
    public static ObjectMapper objectMapper;
    public static ObjectReader cognitoIdReader;
    public static ObjectReader clientCtxReader;

    public void initObjectMapper() {
        objectMapper = this.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).registerModule((Module)new JodaModule());
    }

    public void initContextReaders() {
        cognitoIdReader = objectMapper.readerFor(CognitoIdentity.class);
        clientCtxReader = objectMapper.readerFor(ClientContext.class);
    }

    private ObjectMapper getObjectMapper() {
        InstanceHandle instance = Arc.container().instance(ObjectMapper.class, new Annotation[0]);
        if (instance.isAvailable()) {
            return ((ObjectMapper)instance.get()).copy();
        }
        return new ObjectMapper();
    }
}

