/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.CognitoIdentity;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaApi;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaContext;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.runtime.LambdaConfig;
import io.quarkus.amazon.lambda.runtime.TraceId;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

@Recorder
public class AmazonLambdaRecorder {
    private static final Logger log = Logger.getLogger(AmazonLambdaRecorder.class);
    private static Class<? extends RequestHandler<?, ?>> handlerClass;
    private static BeanContainer beanContainer;
    private static ObjectMapper objectMapper;
    private static ObjectReader objectReader;
    private static ObjectWriter objectWriter;

    public void setHandlerClass(Class<? extends RequestHandler<?, ?>> handler, BeanContainer container) {
        handlerClass = handler;
        beanContainer = container;
        objectMapper = this.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        Method handlerMethod = this.discoverHandlerMethod(handlerClass);
        objectReader = objectMapper.readerFor(handlerMethod.getParameterTypes()[0]);
        objectWriter = objectMapper.writerFor(handlerMethod.getReturnType());
    }

    private ObjectMapper getObjectMapper() {
        InstanceHandle instance = Arc.container().instance(ObjectMapper.class, new Annotation[0]);
        if (instance.isAvailable()) {
            return ((ObjectMapper)instance.get()).copy();
        }
        return new ObjectMapper();
    }

    public static void handle(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        Object request = objectReader.readValue(inputStream);
        RequestHandler handler = (RequestHandler)beanContainer.instance(handlerClass, new Annotation[0]);
        Object response = handler.handleRequest(request, context);
        objectWriter.writeValue(outputStream, response);
    }

    private Method discoverHandlerMethod(Class<? extends RequestHandler<?, ?>> handlerClass) {
        Method[] methods = handlerClass.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length && method == null; ++i) {
            Class<?>[] types;
            if (!methods[i].getName().equals("handleRequest") || (types = methods[i].getParameterTypes()).length != 2 || types[0].equals(Object.class)) continue;
            method = methods[i];
        }
        if (method == null) {
            method = methods[0];
        }
        return method;
    }

    public void chooseHandlerClass(List<Class<? extends RequestHandler<?, ?>>> unamedHandlerClasses, Map<String, Class<? extends RequestHandler<?, ?>>> namedHandlerClasses, BeanContainer container, LambdaConfig config) {
        Class<? extends RequestHandler<?, ?>> handlerClass;
        if (config.handler.isPresent()) {
            handlerClass = namedHandlerClasses.get(config.handler.get());
            if (handlerClass == null) {
                String errorMessage = "Unable to find handler class with name " + config.handler.get() + " make sure there is a handler class in the deployment with the correct @Named annotation";
                throw new RuntimeException(errorMessage);
            }
        } else {
            if (unamedHandlerClasses.size() > 1 || namedHandlerClasses.size() > 1 || unamedHandlerClasses.size() > 0 && namedHandlerClasses.size() > 0) {
                String errorMessage = "Multiple handler classes, either specify the quarkus.lambda.handler property, or make sure there is only a single " + RequestHandler.class.getName() + " implementation in the deployment";
                throw new RuntimeException(errorMessage);
            }
            if (unamedHandlerClasses.isEmpty() && namedHandlerClasses.isEmpty()) {
                String errorMessage = "Unable to find handler class, make sure your deployment includes a " + RequestHandler.class.getName() + " implementation";
                throw new RuntimeException(errorMessage);
            }
            handlerClass = !unamedHandlerClasses.isEmpty() ? unamedHandlerClasses.get(0) : namedHandlerClasses.values().iterator().next();
        }
        this.setHandlerClass(handlerClass, container);
    }

    public void startPollLoop(ShutdownContext context) {
        final AtomicBoolean running = new AtomicBoolean(true);
        final ObjectReader cognitoIdReader = objectMapper.readerFor(CognitoIdentity.class);
        final ObjectReader clientCtxReader = objectMapper.readerFor(ClientContext.class);
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                running.set(false);
            }
        });
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AmazonLambdaRecorder.this.checkQuarkusBootstrapped();
                    URL requestUrl = AmazonLambdaApi.invocationNext();
                    while (running.get()) {
                        HttpURLConnection requestConnection = (HttpURLConnection)requestUrl.openConnection();
                        try {
                            Object response;
                            String requestId = requestConnection.getHeaderField("Lambda-Runtime-Aws-Request-Id");
                            try {
                                String traceId = requestConnection.getHeaderField("Lambda-Runtime-Trace-Id");
                                TraceId.setTraceId(traceId);
                                Object val = objectReader.readValue(requestConnection.getInputStream());
                                RequestHandler handler = (RequestHandler)beanContainer.instance(handlerClass, new Annotation[0]);
                                response = handler.handleRequest(val, (Context)new AmazonLambdaContext(requestConnection, cognitoIdReader, clientCtxReader));
                            }
                            catch (Exception e) {
                                log.error((Object)"Failed to run lambda", (Throwable)e);
                                AmazonLambdaRecorder.this.postResponse(AmazonLambdaApi.invocationError(requestId), new FunctionError(e.getClass().getName(), e.getMessage()), objectMapper);
                                requestConnection.getInputStream().close();
                                continue;
                            }
                            AmazonLambdaRecorder.this.postResponse(AmazonLambdaApi.invocationResponse(requestId), response, objectMapper);
                        }
                        catch (Exception e) {
                            log.error((Object)"Error running lambda", (Throwable)e);
                            Application app = Application.currentApplication();
                            if (app != null) {
                                app.stop();
                            }
                            return;
                        }
                        finally {
                            requestConnection.getInputStream().close();
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        log.error((Object)"Lambda init error", (Throwable)e);
                        AmazonLambdaRecorder.this.postResponse(AmazonLambdaApi.initError(), new FunctionError(e.getClass().getName(), e.getMessage()), objectMapper);
                    }
                    catch (Exception ex) {
                        log.error((Object)"Failed to report init error", (Throwable)ex);
                    }
                    finally {
                        Application app = Application.currentApplication();
                        if (app != null) {
                            app.stop();
                        }
                    }
                }
            }
        }, "Lambda Thread");
        t.start();
    }

    private void checkQuarkusBootstrapped() {
        if (Application.currentApplication() == null) {
            throw new RuntimeException("Quarkus initialization error");
        }
        String[] args = new String[]{};
        Application.currentApplication().start(args);
    }

    private void postResponse(URL url, Object response, ObjectMapper mapper) throws IOException {
        HttpURLConnection responseConnection = (HttpURLConnection)url.openConnection();
        responseConnection.setDoOutput(true);
        responseConnection.setRequestMethod("POST");
        mapper.writeValue(responseConnection.getOutputStream(), response);
        while (responseConnection.getInputStream().read() != -1) {
        }
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

