/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;

public class AutoInjectFieldProcessor {
    private static final Logger LOGGER = Logger.getLogger(AutoInjectFieldProcessor.class);

    @BuildStep
    void autoInjectQualifiers(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<AutoInjectAnnotationBuildItem> autoInjectAnnotations) {
        ArrayList<DotName> qualifiers = new ArrayList<DotName>();
        for (AnnotationInstance qualifier : beanArchiveIndex.getIndex().getAnnotations(DotNames.QUALIFIER)) {
            qualifiers.add(qualifier.target().asClass().name());
        }
        autoInjectAnnotations.produce((BuildItem)new AutoInjectAnnotationBuildItem(qualifiers));
    }

    @BuildStep
    void annotationTransformer(ArcConfig config, List<AutoInjectAnnotationBuildItem> autoInjectAnnotations, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) throws Exception {
        if (!config.autoInjectFields) {
            return;
        }
        final HashSet<DotName> annotations = new HashSet<DotName>();
        for (AutoInjectAnnotationBuildItem autoInjectAnnotation : autoInjectAnnotations) {
            annotations.addAll(autoInjectAnnotation.getAnnotationNames());
        }
        if (annotations.isEmpty()) {
            return;
        }
        LOGGER.debugf("Add missing @Inject to fields annotated with %s", annotations);
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                FieldInfo field = transformationContext.getTarget().asField();
                if (Modifier.isStatic(field.flags()) || field.hasAnnotation(DotNames.INJECT) || field.hasAnnotation(DotNames.PRODUCES)) {
                    return;
                }
                for (DotName annotation : annotations) {
                    if (!field.hasAnnotation(annotation)) continue;
                    ((Transformation)transformationContext.transform().add(DotNames.INJECT, new AnnotationValue[0])).done();
                    return;
                }
            }
        }));
    }
}

