/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ObserverValidationProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)ObserverValidationProcessor.class.getName());

    @BuildStep
    public void validateApplicationObserver(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<BeanDeploymentValidatorBuildItem> validators) {
        final IndexView applicationClassesIndex = applicationArchivesBuildItem.getRootArchive().getIndex();
        validators.produce((BuildItem)new BeanDeploymentValidatorBuildItem(new BeanDeploymentValidator(){

            public void validate(BeanDeploymentValidator.ValidationContext context) {
                Collection allObservers = (Collection)context.get(BuildExtension.Key.OBSERVERS);
                for (ObserverInfo observer : allObservers) {
                    DotName declaringBeanDotName = observer.getDeclaringBean().getBeanClass();
                    AnnotationInstance instance = Annotations.getParameterAnnotation((MethodInfo)observer.getObserverMethod(), (DotName)DotNames.INITIALIZED);
                    if (applicationClassesIndex.getClassByName(declaringBeanDotName) == null || instance == null || !instance.value().asClass().name().equals((Object)BuiltinScope.APPLICATION.getName())) continue;
                    String observerWarning = "The method %s#%s is an observer for @Initialized(ApplicationScoped.class). Observer notification for this event may vary between JVM and native modes! We strongly recommend to observe StartupEvent instead as that one is consistently delivered in both modes once the container is running.";
                    LOGGER.warnf("The method %s#%s is an observer for @Initialized(ApplicationScoped.class). Observer notification for this event may vary between JVM and native modes! We strongly recommend to observe StartupEvent instead as that one is consistently delivered in both modes once the container is running.", (Object)observer.getDeclaringBean().getImplClazz(), (Object)observer.getObserverMethod().name());
                }
            }
        }));
    }
}

