/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.RuntimeValue;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.enterprise.context.NormalScope;
import org.jboss.jandex.DotName;

@Deprecated
public final class RuntimeBeanBuildItem
extends MultiBuildItem {
    final ScopeInfo scope;
    final String type;
    final Supplier<Object> supplier;
    final RuntimeValue<?> runtimeValue;
    final NavigableMap<String, NavigableMap<String, Object>> qualifiers;
    final boolean removable;

    RuntimeBeanBuildItem(ScopeInfo scope, String type, Supplier<Object> supplier, NavigableMap<String, NavigableMap<String, Object>> qualifiers, boolean removable, RuntimeValue<?> runtimeValue) {
        if (supplier != null && runtimeValue != null) {
            throw new IllegalArgumentException("It is not possible to specify both - a supplier and a runtime value");
        }
        this.scope = scope;
        this.type = type;
        this.supplier = supplier;
        this.qualifiers = qualifiers;
        this.removable = removable;
        this.runtimeValue = runtimeValue;
    }

    public String getScope() {
        return this.scope.getDotName().toString();
    }

    public String getType() {
        return this.type;
    }

    public Supplier<Object> getSupplier() {
        return this.supplier;
    }

    public RuntimeValue<?> getRuntimeValue() {
        return this.runtimeValue;
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public NavigableMap<String, NavigableMap<String, Object>> getQualifiers() {
        return this.qualifiers;
    }

    public static Builder builder(Class<?> type) {
        return RuntimeBeanBuildItem.builder(type.getName());
    }

    public static Builder builder(String type) {
        Objects.requireNonNull(type);
        return new Builder(type);
    }

    public static class Builder {
        ScopeInfo scope = BuiltinScope.DEPENDENT.getInfo();
        boolean removable = true;
        final String type;
        Supplier<Object> supplier;
        RuntimeValue<?> value;
        final NavigableMap<String, NavigableMap<String, Object>> qualifiers = new TreeMap<String, NavigableMap<String, Object>>();

        public Builder(String type) {
            this.type = type;
        }

        public Builder setScope(String scope) {
            DotName scopeName = DotName.createSimple((String)scope);
            this.scope = Optional.ofNullable(BuiltinScope.from((DotName)scopeName)).map(BuiltinScope::getInfo).orElse(new ScopeInfo(scopeName, false));
            return this;
        }

        public Builder setScope(Class<? extends Annotation> type) {
            DotName scopeName = DotName.createSimple((String)type.getName());
            this.scope = Optional.ofNullable(BuiltinScope.from((DotName)scopeName)).map(BuiltinScope::getInfo).orElse(new ScopeInfo(scopeName, type.isAnnotationPresent(NormalScope.class), type.isAnnotationPresent(Inherited.class)));
            return this;
        }

        public Builder addQualifier(String type) {
            this.qualifiers.put(type, new TreeMap());
            return this;
        }

        public Builder addQualifier(String type, NavigableMap<String, Object> values) {
            this.qualifiers.put(type, new TreeMap<String, Object>((SortedMap<String, Object>)values));
            return this;
        }

        public Builder addQualifier(Class<? extends Annotation> type) {
            return this.addQualifier(type.getName());
        }

        public Builder addQualifier(Class<? extends Annotation> type, NavigableMap<String, Object> values) {
            return this.addQualifier(type.getName(), values);
        }

        public Builder setRemovable(boolean removable) {
            this.removable = removable;
            return this;
        }

        public Builder setSupplier(Supplier<Object> supplier) {
            this.supplier = Objects.requireNonNull(supplier);
            return this;
        }

        public Builder setRuntimeValue(RuntimeValue<?> runtimeValue) {
            this.value = Objects.requireNonNull(runtimeValue);
            return this;
        }

        public RuntimeBeanBuildItem build() {
            if (this.supplier == null && this.value == null) {
                throw new IllegalStateException("Either a supplier or a runtime value must be set");
            }
            return new RuntimeBeanBuildItem(this.scope, this.type, this.supplier, this.qualifiers, this.removable, this.value);
        }
    }
}

