/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.RuntimeBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanConfiguratorBase;
import io.quarkus.arc.processor.QualifierConfigurator;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.enterprise.inject.CreationException;
import org.jboss.jandex.DotName;

public class SyntheticBeansProcessor {
    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void build(ArcRecorder recorder, List<RuntimeBeanBuildItem> runtimeBeans, List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        HashMap suppliersMap = new HashMap();
        for (RuntimeBeanBuildItem runtimeBeanBuildItem : runtimeBeans) {
            String name = this.createName(runtimeBeanBuildItem.type, runtimeBeanBuildItem.qualifiers.toString());
            if (runtimeBeanBuildItem.runtimeValue != null) {
                suppliersMap.put(name, recorder.createSupplier(runtimeBeanBuildItem.runtimeValue));
            } else {
                suppliersMap.put(name, runtimeBeanBuildItem.supplier);
            }
            DotName beanClass = DotName.createSimple((String)runtimeBeanBuildItem.type);
            BeanConfigurator configurator = beanRegistration.getContext().configure(beanClass);
            configurator.addType(beanClass);
            if (!runtimeBeanBuildItem.qualifiers.isEmpty()) {
                for (Map.Entry entry : runtimeBeanBuildItem.qualifiers.entrySet()) {
                    DotName qualifierName = DotName.createSimple((String)((String)entry.getKey()));
                    QualifierConfigurator qualifier = configurator.addQualifier().annotation(qualifierName);
                    if (!((NavigableMap)entry.getValue()).isEmpty()) {
                        for (Map.Entry valEntry : ((NavigableMap)entry.getValue()).entrySet()) {
                            qualifier.addValue((String)valEntry.getKey(), valEntry.getValue());
                        }
                    }
                    qualifier.done();
                }
            }
            configurator.scope(runtimeBeanBuildItem.scope);
            if (!runtimeBeanBuildItem.removable) {
                configurator.unremovable();
            }
            configurator.creator(this.creator(name));
            configurator.done();
        }
        for (SyntheticBeanBuildItem syntheticBeanBuildItem : syntheticBeans) {
            if (!syntheticBeanBuildItem.isStaticInit()) continue;
            this.initSyntheticBean(recorder, suppliersMap, beanRegistration, syntheticBeanBuildItem);
        }
        recorder.initStaticSupplierBeans(suppliersMap);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void build(ArcRecorder recorder, List<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistration, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> configurators) {
        HashMap suppliersMap = new HashMap();
        for (SyntheticBeanBuildItem bean : syntheticBeans) {
            if (bean.isStaticInit()) continue;
            this.initSyntheticBean(recorder, suppliersMap, beanRegistration, bean);
        }
        recorder.initRuntimeSupplierBeans(suppliersMap);
    }

    private void initSyntheticBean(ArcRecorder recorder, Map<String, Supplier<?>> suppliersMap, BeanRegistrationPhaseBuildItem beanRegistration, SyntheticBeanBuildItem bean) {
        DotName implClazz = bean.configurator().getImplClazz();
        String name = this.createName(implClazz.toString(), bean.configurator().getQualifiers().toString());
        if (bean.configurator().runtimeValue != null) {
            suppliersMap.put(name, recorder.createSupplier(bean.configurator().runtimeValue));
        } else {
            suppliersMap.put(name, bean.configurator().supplier);
        }
        ((BeanConfigurator)((BeanConfigurator)beanRegistration.getContext().configure(implClazz).read((BeanConfiguratorBase)bean.configurator())).creator(this.creator(name))).done();
    }

    private String createName(String beanClass, String qualifiers) {
        return beanClass.replace(".", "_") + "_" + HashUtil.sha1((String)qualifiers);
    }

    private Consumer<MethodCreator> creator(final String name) {
        return new Consumer<MethodCreator>(){

            @Override
            public void accept(MethodCreator m) {
                ResultHandle staticMap = m.readStaticField(FieldDescriptor.of(ArcRecorder.class, (String)"supplierMap", Map.class));
                ResultHandle supplier = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"get", Object.class, (Class[])new Class[]{Object.class}), staticMap, new ResultHandle[]{m.load(name)});
                m.ifNull(supplier).trueBranch().throwException(CreationException.class, "Synthetic bean instance not initialized yet: " + name);
                ResultHandle result = m.invokeInterfaceMethod(MethodDescriptor.ofMethod(Supplier.class, (String)"get", Object.class, (Class[])new Class[0]), supplier, new ResultHandle[0]);
                m.returnValue(result);
            }
        };
    }
}

