/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AdditionalStereotypeBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ContextRegistrarBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.InterceptorResolverBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrarBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.ObserverTransformerBuildItem;
import io.quarkus.arc.deployment.ResourceAnnotationBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AlternativePriorities;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanDefiningAnnotation;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.ContextRegistrar;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.AdditionalBean;
import io.quarkus.arc.runtime.ArcRecorder;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.LaunchModeProducer;
import io.quarkus.arc.runtime.LifecycleEventRunner;
import io.quarkus.bootstrap.BootstrapDebug;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.TestClassPredicateBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ArcProcessor {
    private static final Logger LOGGER = Logger.getLogger(ArcProcessor.class);
    static final DotName ADDITIONAL_BEAN = DotName.createSimple((String)AdditionalBean.class.getName());

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.CDI);
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.CDI);
    }

    @BuildStep
    AdditionalBeanBuildItem quarkusApplication(CombinedIndexBuildItem combinedIndexBuildItem) {
        return AdditionalBeanBuildItem.builder().setUnremovable().setDefaultScope(DotName.createSimple((String)ApplicationScoped.class.getName())).addBeanClasses((String[])combinedIndexBuildItem.getIndex().getAllKnownImplementors(DotName.createSimple((String)QuarkusApplication.class.getName())).stream().map(s -> s.name().toString()).toArray(String[]::new)).build();
    }

    @BuildStep
    public ContextRegistrationPhaseBuildItem initialize(ArcConfig arcConfig, BeanArchiveIndexBuildItem beanArchiveIndex, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<AnnotationsTransformerBuildItem> annotationTransformers, List<InjectionPointTransformerBuildItem> injectionPointTransformers, List<ObserverTransformerBuildItem> observerTransformers, List<InterceptorBindingRegistrarBuildItem> interceptorBindingRegistrarBuildItems, List<AdditionalStereotypeBuildItem> additionalStereotypeBuildItems, List<ApplicationClassPredicateBuildItem> applicationClassPredicates, final List<AdditionalBeanBuildItem> additionalBeans, List<BeanRegistrarBuildItem> beanRegistrars, List<ObserverRegistrarBuildItem> observerRegistrars, List<ContextRegistrarBuildItem> contextRegistrars, List<BeanDeploymentValidatorBuildItem> beanDeploymentValidators, List<ResourceAnnotationBuildItem> resourceAnnotations, List<BeanDefiningAnnotationBuildItem> additionalBeanDefiningAnnotations, List<UnremovableBeanBuildItem> removalExclusions, final Optional<TestClassPredicateBuildItem> testClassPredicate, Capabilities capabilities, final CustomScopeAnnotationsBuildItem scopes, LaunchModeBuildItem launchModeBuildItem) {
        if (!arcConfig.isRemoveUnusedBeansFieldValid()) {
            throw new IllegalArgumentException("Invalid configuration value set for 'quarkus.arc.remove-unused-beans'. Please use one of " + ArcConfig.ALLOWED_REMOVE_UNUSED_BEANS_VALUES);
        }
        final List<String> additionalBeansTypes = beanArchiveIndex.getAdditionalBeans();
        Set<DotName> generatedClassNames = beanArchiveIndex.getGeneratedClassNames();
        IndexView index = beanArchiveIndex.getIndex();
        BeanProcessor.Builder builder = BeanProcessor.builder();
        IndexView applicationClassesIndex = applicationArchivesBuildItem.getRootArchive().getIndex();
        builder.setApplicationClassPredicate((Predicate)new AbstractCompositeApplicationClassesPredicate<DotName>(applicationClassesIndex, generatedClassNames, applicationClassPredicates, testClassPredicate){

            @Override
            protected DotName getDotName(DotName dotName) {
                return dotName;
            }
        });
        builder.addAnnotationTransformer(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return AnnotationTarget.Kind.CLASS == kind;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo beanClass = transformationContext.getTarget().asClass();
                String beanClassName = beanClass.name().toString();
                if (additionalBeansTypes.contains(beanClassName)) {
                    if (scopes.isScopeDeclaredOn(beanClass)) {
                        return;
                    }
                    DotName defaultScope = additionalBeans.stream().filter(ab -> ab.contains(beanClassName)).findFirst().map(AdditionalBeanBuildItem::getDefaultScope).orElse(null);
                    if (defaultScope == null && !beanClass.annotations().containsKey(ADDITIONAL_BEAN)) {
                        ((Transformation)transformationContext.transform().add(ADDITIONAL_BEAN, new AnnotationValue[0])).done();
                    } else {
                        ((Transformation)transformationContext.transform().add(defaultScope, new AnnotationValue[0])).done();
                    }
                }
            }
        });
        builder.setIndex(index);
        List beanDefiningAnnotations = additionalBeanDefiningAnnotations.stream().map(s -> new BeanDefiningAnnotation(s.getName(), s.getDefaultScope())).collect(Collectors.toList());
        beanDefiningAnnotations.add(new BeanDefiningAnnotation(ADDITIONAL_BEAN, null));
        builder.setAdditionalBeanDefiningAnnotations(beanDefiningAnnotations);
        HashMap<DotName, Collection<AnnotationInstance>> additionalStereotypes = new HashMap<DotName, Collection<AnnotationInstance>>();
        for (AdditionalStereotypeBuildItem additionalStereotypeBuildItem : additionalStereotypeBuildItems) {
            additionalStereotypes.putAll(additionalStereotypeBuildItem.getStereotypes());
        }
        builder.setAdditionalStereotypes(additionalStereotypes);
        builder.setSharedAnnotationLiterals(true);
        builder.addResourceAnnotations((Collection)resourceAnnotations.stream().map(ResourceAnnotationBuildItem::getName).collect(Collectors.toList()));
        for (AnnotationsTransformerBuildItem annotationsTransformerBuildItem : annotationTransformers) {
            builder.addAnnotationTransformer(annotationsTransformerBuildItem.getAnnotationsTransformer());
        }
        for (InjectionPointTransformerBuildItem injectionPointTransformerBuildItem : injectionPointTransformers) {
            builder.addInjectionPointTransformer(injectionPointTransformerBuildItem.getInjectionPointsTransformer());
        }
        for (ObserverTransformerBuildItem observerTransformerBuildItem : observerTransformers) {
            builder.addObserverTransformer(observerTransformerBuildItem.getInstance());
        }
        for (InterceptorBindingRegistrarBuildItem interceptorBindingRegistrarBuildItem : interceptorBindingRegistrarBuildItems) {
            builder.addInterceptorbindingRegistrar(interceptorBindingRegistrarBuildItem.getInterceptorBindingRegistrar());
        }
        for (BeanRegistrarBuildItem beanRegistrarBuildItem : beanRegistrars) {
            builder.addBeanRegistrar(beanRegistrarBuildItem.getBeanRegistrar());
        }
        for (ObserverRegistrarBuildItem observerRegistrarBuildItem : observerRegistrars) {
            builder.addObserverRegistrar(observerRegistrarBuildItem.getObserverRegistrar());
        }
        for (ContextRegistrarBuildItem contextRegistrarBuildItem : contextRegistrars) {
            builder.addContextRegistrar(contextRegistrarBuildItem.getContextRegistrar());
        }
        for (BeanDeploymentValidatorBuildItem beanDeploymentValidatorBuildItem : beanDeploymentValidators) {
            builder.addBeanDeploymentValidator(beanDeploymentValidatorBuildItem.getBeanDeploymentValidator());
        }
        builder.setRemoveUnusedBeans(arcConfig.shouldEnableBeanRemoval());
        if (arcConfig.shouldOnlyKeepAppBeans()) {
            builder.addRemovalExclusion((Predicate)new AbstractCompositeApplicationClassesPredicate<BeanInfo>(applicationClassesIndex, generatedClassNames, applicationClassPredicates, testClassPredicate){

                @Override
                protected DotName getDotName(BeanInfo bean) {
                    return bean.getBeanClass();
                }
            });
        }
        builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(LifecycleEventRunner.class.getName()));
        for (AdditionalBeanBuildItem additionalBeanBuildItem : additionalBeans) {
            if (additionalBeanBuildItem.isRemovable()) continue;
            for (String beanClass : additionalBeanBuildItem.getBeanClasses()) {
                builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassNameExclusion(beanClass));
            }
        }
        for (BeanDefiningAnnotationBuildItem beanDefiningAnnotationBuildItem : additionalBeanDefiningAnnotations) {
            if (beanDefiningAnnotationBuildItem.isRemovable()) continue;
            builder.addRemovalExclusion((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(beanDefiningAnnotationBuildItem.getName()));
        }
        for (UnremovableBeanBuildItem unremovableBeanBuildItem : removalExclusions) {
            builder.addRemovalExclusion(unremovableBeanBuildItem.getPredicate());
        }
        if (arcConfig.unremovableTypes.isPresent()) {
            final List<Predicate<ClassInfo>> classPredicates = this.initClassPredicates(arcConfig.unremovableTypes.get());
            builder.addRemovalExclusion((Predicate)new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo beanInfo) {
                    ClassInfo beanClass = beanInfo.getImplClazz();
                    if (beanClass != null) {
                        for (Predicate predicate : classPredicates) {
                            if (!predicate.test(beanClass)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        if (testClassPredicate.isPresent()) {
            builder.addRemovalExclusion((Predicate)new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo bean) {
                    return ((TestClassPredicateBuildItem)testClassPredicate.get()).getPredicate().test(bean.getBeanClass().toString());
                }
            });
        }
        builder.setTransformUnproxyableClasses(arcConfig.transformUnproxyableClasses);
        builder.setJtaCapabilities(capabilities.isPresent(Capability.TRANSACTIONS));
        builder.setGenerateSources(BootstrapDebug.DEBUG_SOURCES_DIR != null);
        builder.setAllowMocking(launchModeBuildItem.getLaunchMode() == LaunchMode.TEST);
        if (arcConfig.selectedAlternatives.isPresent()) {
            final List<Predicate<ClassInfo>> selectedAlternatives = this.initClassPredicates(arcConfig.selectedAlternatives.get());
            builder.setAlternativePriorities(new AlternativePriorities(){

                public Integer compute(AnnotationTarget target, Collection<StereotypeInfo> stereotypes) {
                    ClassInfo clazz;
                    switch (target.kind()) {
                        case CLASS: {
                            clazz = target.asClass();
                            break;
                        }
                        case FIELD: {
                            clazz = target.asField().declaringClass();
                            break;
                        }
                        case METHOD: {
                            clazz = target.asMethod().declaringClass();
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    if (selectedAlternatives.stream().anyMatch(p -> p.test(clazz))) {
                        return Integer.MAX_VALUE;
                    }
                    if (!stereotypes.isEmpty()) {
                        for (StereotypeInfo stereotype : stereotypes) {
                            if (!selectedAlternatives.stream().anyMatch(p -> p.test(stereotype.getTarget()))) continue;
                            return Integer.MAX_VALUE;
                        }
                    }
                    return null;
                }
            });
        }
        if (arcConfig.excludeTypes.isPresent()) {
            for (Predicate predicate : this.initClassPredicates(arcConfig.excludeTypes.get())) {
                builder.addExcludeType(predicate);
            }
        }
        BeanProcessor beanProcessor = builder.build();
        ContextRegistrar.RegistrationContext registrationContext = beanProcessor.registerCustomContexts();
        return new ContextRegistrationPhaseBuildItem(registrationContext, beanProcessor);
    }

    @BuildStep
    public BeanRegistrationPhaseBuildItem registerBeans(ContextRegistrationPhaseBuildItem contextRegistrationPhase, List<ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem> contextConfigurators, BuildProducer<InterceptorResolverBuildItem> interceptorResolver, BuildProducer<TransformedAnnotationsBuildItem> transformedAnnotations) {
        for (ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem contextConfigurator : contextConfigurators) {
            for (ContextConfigurator value : contextConfigurator.getValues()) {
                value.done();
            }
        }
        BeanDeployment beanDeployment = contextRegistrationPhase.getBeanProcessor().getBeanDeployment();
        interceptorResolver.produce((BuildItem)new InterceptorResolverBuildItem(beanDeployment));
        transformedAnnotations.produce((BuildItem)new TransformedAnnotationsBuildItem(beanDeployment));
        return new BeanRegistrationPhaseBuildItem(contextRegistrationPhase.getBeanProcessor().registerBeans(), contextRegistrationPhase.getBeanProcessor());
    }

    @BuildStep
    public ObserverRegistrationPhaseBuildItem registerSyntheticObservers(BeanRegistrationPhaseBuildItem beanRegistrationPhase, List<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurators) {
        for (BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem configurator : beanConfigurators) {
            configurator.getValues().forEach(BeanConfigurator::done);
        }
        return new ObserverRegistrationPhaseBuildItem(beanRegistrationPhase.getBeanProcessor().registerSyntheticObservers(), beanRegistrationPhase.getBeanProcessor());
    }

    @BuildStep
    public ValidationPhaseBuildItem validate(ObserverRegistrationPhaseBuildItem observerRegistrationPhase, List<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerConfigurators, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer) {
        for (ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem configurator : observerConfigurators) {
            configurator.getValues().forEach(ObserverConfigurator::done);
        }
        BytecodeTransformerConsumer bytecodeTransformerConsumer = new BytecodeTransformerConsumer(bytecodeTransformer);
        observerRegistrationPhase.getBeanProcessor().initialize((Consumer)bytecodeTransformerConsumer);
        return new ValidationPhaseBuildItem(observerRegistrationPhase.getBeanProcessor().validate((Consumer)bytecodeTransformerConsumer), observerRegistrationPhase.getBeanProcessor());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public BeanContainerBuildItem generateResources(ArcRecorder recorder, ShutdownContextBuildItem shutdown, ValidationPhaseBuildItem validationPhase, List<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, List<BeanContainerListenerBuildItem> beanContainerListenerBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, final BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, final BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<GeneratedClassBuildItem> generatedClass, LiveReloadBuildItem liveReloadBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResource, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer) throws Exception {
        for (ValidationPhaseBuildItem.ValidationErrorBuildItem validationError : validationErrors) {
            for (Throwable error : validationError.getValues()) {
                validationPhase.getContext().addDeploymentProblem(error);
            }
        }
        BeanProcessor beanProcessor = validationPhase.getBeanProcessor();
        beanProcessor.processValidationErrors(validationPhase.getContext());
        ExistingClasses existingClasses = (ExistingClasses)liveReloadBuildItem.getContextObject(ExistingClasses.class);
        if (existingClasses == null) {
            existingClasses = new ExistingClasses();
            liveReloadBuildItem.setContextObject(ExistingClasses.class, (Object)existingClasses);
        }
        BytecodeTransformerConsumer bytecodeTransformerConsumer = new BytecodeTransformerConsumer(bytecodeTransformer);
        long start = System.currentTimeMillis();
        List resources = beanProcessor.generateResources(new ReflectionRegistration(){

            public void registerMethod(MethodInfo methodInfo) {
                reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(methodInfo));
            }

            public void registerField(FieldInfo fieldInfo) {
                reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem(fieldInfo));
            }
        }, existingClasses.existingClasses, (Consumer)bytecodeTransformerConsumer);
        for (ResourceOutput.Resource resource : resources) {
            switch (resource.getType()) {
                case JAVA_CLASS: {
                    LOGGER.debugf("Add %s class: %s", (Object)(resource.isApplicationClass() ? "APP" : "FWK"), (Object)resource.getFullyQualifiedName());
                    generatedClass.produce((BuildItem)new GeneratedClassBuildItem(resource.isApplicationClass(), resource.getName(), resource.getData(), resource.getSource()));
                    if (resource.isApplicationClass()) break;
                    existingClasses.existingClasses.add(resource.getName());
                    break;
                }
                case SERVICE_PROVIDER: {
                    generatedResource.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/services/" + resource.getName(), resource.getData()));
                    break;
                }
            }
        }
        LOGGER.debugf("Generated %s resources in %s ms", (long)resources.size(), System.currentTimeMillis() - start);
        for (ClassInfo qualifier : beanProcessor.getBeanDeployment().getQualifiers()) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{qualifier.name().toString()}));
        }
        ArcContainer container = recorder.getContainer((ShutdownContext)shutdown);
        BeanContainer beanContainer = recorder.initBeanContainer(container, beanContainerListenerBuildItems.stream().map(BeanContainerListenerBuildItem::getBeanContainerListener).collect(Collectors.toList()), (Collection)beanProcessor.getBeanDeployment().getRemovedBeans().stream().flatMap(b -> b.getTypes().stream()).map(t -> t.name().toString()).collect(Collectors.toSet()));
        return new BeanContainerBuildItem(beanContainer);
    }

    @BuildStep
    List<AdditionalApplicationArchiveMarkerBuildItem> marker() {
        return Arrays.asList(new AdditionalApplicationArchiveMarkerBuildItem("META-INF/beans.xml"), new AdditionalApplicationArchiveMarkerBuildItem("META-INF/services/javax.enterprise.inject.spi.Extension"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupExecutor(ExecutorBuildItem executor, ArcRecorder recorder) {
        recorder.initExecutor(executor.getExecutorProxy());
    }

    @BuildStep
    AdditionalBeanBuildItem launchMode() {
        return new AdditionalBeanBuildItem(LaunchModeProducer.class);
    }

    @BuildStep
    CustomScopeAnnotationsBuildItem exposeCustomScopeNames(List<ContextRegistrarBuildItem> contextBuildItems) {
        HashSet<DotName> names = new HashSet<DotName>();
        for (ContextRegistrarBuildItem item : contextBuildItems) {
            names.addAll(item.getAnnotationNames());
        }
        return new CustomScopeAnnotationsBuildItem(names);
    }

    private List<Predicate<ClassInfo>> initClassPredicates(List<String> types) {
        String packMatch = ".*";
        String packStarts = ".**";
        ArrayList<Predicate<ClassInfo>> predicates = new ArrayList<Predicate<ClassInfo>>();
        for (final String val : types) {
            if (val.endsWith(".*")) {
                final String pack = val.substring(0, val.length() - ".*".length());
                predicates.add(new Predicate<ClassInfo>(){

                    @Override
                    public boolean test(ClassInfo c) {
                        return DotNames.packageName((DotName)c.name()).equals(pack);
                    }
                });
                continue;
            }
            if (val.endsWith(".**")) {
                final String prefix = val.substring(0, val.length() - ".**".length());
                predicates.add(new Predicate<ClassInfo>(){

                    @Override
                    public boolean test(ClassInfo c) {
                        return DotNames.packageName((DotName)c.name()).startsWith(prefix);
                    }
                });
                continue;
            }
            if (val.contains(".")) {
                predicates.add(new Predicate<ClassInfo>(){

                    @Override
                    public boolean test(ClassInfo c) {
                        return c.name().toString().equals(val);
                    }
                });
                continue;
            }
            predicates.add(new Predicate<ClassInfo>(){

                @Override
                public boolean test(ClassInfo c) {
                    return DotNames.simpleName((ClassInfo)c).equals(val);
                }
            });
        }
        return predicates;
    }

    @BuildStep
    BeanDefiningAnnotationBuildItem quarkusMain() {
        return new BeanDefiningAnnotationBuildItem(DotName.createSimple((String)QuarkusMain.class.getName()), DotNames.SINGLETON);
    }

    private static class BytecodeTransformerConsumer
    implements Consumer<BytecodeTransformer> {
        private final BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer;

        public BytecodeTransformerConsumer(BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformer) {
            this.bytecodeTransformer = bytecodeTransformer;
        }

        @Override
        public void accept(BytecodeTransformer t) {
            this.bytecodeTransformer.produce((BuildItem)new BytecodeTransformerBuildItem(t.getClassToTransform(), t.getVisitorFunction()));
        }
    }

    static class ExistingClasses {
        Set<String> existingClasses = new HashSet<String>();

        ExistingClasses() {
        }
    }

    private static abstract class AbstractCompositeApplicationClassesPredicate<T>
    implements Predicate<T> {
        private final IndexView applicationClassesIndex;
        private final Set<DotName> generatedClassNames;
        private final List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems;
        private final Optional<TestClassPredicateBuildItem> testClassPredicate;

        protected abstract DotName getDotName(T var1);

        private AbstractCompositeApplicationClassesPredicate(IndexView applicationClassesIndex, Set<DotName> generatedClassNames, List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems, Optional<TestClassPredicateBuildItem> testClassPredicate) {
            this.applicationClassesIndex = applicationClassesIndex;
            this.generatedClassNames = generatedClassNames;
            this.applicationClassPredicateBuildItems = applicationClassPredicateBuildItems;
            this.testClassPredicate = testClassPredicate;
        }

        @Override
        public boolean test(T t) {
            DotName dotName = this.getDotName(t);
            if (this.applicationClassesIndex.getClassByName(dotName) != null) {
                return true;
            }
            if (this.generatedClassNames.contains(dotName)) {
                return true;
            }
            String className = dotName.toString();
            if (!this.applicationClassPredicateBuildItems.isEmpty()) {
                for (ApplicationClassPredicateBuildItem predicate : this.applicationClassPredicateBuildItems) {
                    if (!predicate.test(className)) continue;
                    return true;
                }
            }
            return this.testClassPredicate.isPresent() && this.testClassPredicate.get().getPredicate().test(className);
        }
    }
}

