/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.configproperties.ClassConfigPropertiesUtil;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesMetadataBuildItem;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.arc.deployment.configproperties.InterfaceConfigPropertiesUtil;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class ConfigPropertiesBuildStep {
    @BuildStep
    void produceConfigPropertiesMetadata(CombinedIndexBuildItem combinedIndex, ArcConfig arcConfig, BuildProducer<ConfigPropertiesMetadataBuildItem> configPropertiesMetadataProducer) {
        ConfigProperties.NamingStrategy namingStrategy;
        ClassInfo classInfo;
        IndexView index = combinedIndex.getIndex();
        HashMap<DotName, ConfigProperties.NamingStrategy> namingStrategies = new HashMap<DotName, ConfigProperties.NamingStrategy>();
        HashMap<DotName, Boolean> failOnMismatchingMembers = new HashMap<DotName, Boolean>();
        for (AnnotationInstance instance : index.getAnnotations(DotNames.CONFIG_PROPERTIES)) {
            classInfo = instance.target().asClass();
            namingStrategy = this.getNamingStrategy(arcConfig, instance.value("namingStrategy"));
            namingStrategies.put(classInfo.name(), namingStrategy);
            boolean failOnMismatchingMember = this.isFailOnMissingMember(instance);
            failOnMismatchingMembers.put(classInfo.name(), failOnMismatchingMember);
            configPropertiesMetadataProducer.produce((BuildItem)new ConfigPropertiesMetadataBuildItem(classInfo, this.getPrefix(instance), namingStrategy, failOnMismatchingMember, false));
        }
        for (AnnotationInstance instance : index.getAnnotations(DotNames.CONFIG_PREFIX)) {
            if (instance.target().kind() == AnnotationTarget.Kind.FIELD) {
                classInfo = index.getClassByName(instance.target().asField().type().name());
            } else {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) break;
                short position = instance.target().asMethodParameter().position();
                classInfo = index.getClassByName(((Type)instance.target().asMethodParameter().method().parameters().get(position)).name());
            }
            namingStrategy = namingStrategies.getOrDefault(classInfo.name(), arcConfig.configPropertiesDefaultNamingStrategy);
            configPropertiesMetadataProducer.produce((BuildItem)new ConfigPropertiesMetadataBuildItem(classInfo, instance.value().asString(), namingStrategy, failOnMismatchingMembers.getOrDefault(classInfo.name(), true), true));
        }
    }

    private boolean isFailOnMissingMember(AnnotationInstance instance) {
        AnnotationValue failOnMissingMemberValue = instance.value("failOnMismatchingMember");
        return failOnMissingMemberValue != null ? failOnMissingMemberValue.asBoolean() : true;
    }

    private ConfigProperties.NamingStrategy getNamingStrategy(ArcConfig arcConfig, AnnotationValue namingStrategyValue) {
        return namingStrategyValue == null ? arcConfig.configPropertiesDefaultNamingStrategy : ConfigProperties.NamingStrategy.valueOf((String)namingStrategyValue.asEnum());
    }

    private String getPrefix(AnnotationInstance annotationInstance) {
        AnnotationValue value = annotationInstance.value("prefix");
        return value == null ? null : value.asString();
    }

    @BuildStep
    void setup(CombinedIndexBuildItem combinedIndex, List<ConfigPropertiesMetadataBuildItem> configPropertiesMetadataList, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigPropertyBuildItem> configProperties) {
        if (configPropertiesMetadataList.isEmpty()) {
            return;
        }
        GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GeneratedClassGizmoAdaptor nonBeansClassOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        ClassCreator producerClassCreator = ClassCreator.builder().classOutput((ClassOutput)beansClassOutput).className("io.quarkus.arc.runtime.config.ConfigPropertiesProducer").build();
        producerClassCreator.addAnnotation(Singleton.class);
        HashSet<DotName> configClassesThatNeedValidation = new HashSet<DotName>(configPropertiesMetadataList.size());
        for (ConfigPropertiesMetadataBuildItem configPropertiesMetadata : configPropertiesMetadataList) {
            ClassInfo classInfo = configPropertiesMetadata.getClassInfo();
            if (Modifier.isInterface(classInfo.flags())) {
                HashMap<DotName, InterfaceConfigPropertiesUtil.GeneratedClass> interfaceToGeneratedClass = new HashMap<DotName, InterfaceConfigPropertiesUtil.GeneratedClass>();
                InterfaceConfigPropertiesUtil.generateImplementationForInterfaceConfigProperties(classInfo, (ClassOutput)nonBeansClassOutput, combinedIndex.getIndex(), configPropertiesMetadata.getPrefix(), configPropertiesMetadata.getNamingStrategy(), defaultConfigValues, configProperties, interfaceToGeneratedClass);
                for (Map.Entry entry : interfaceToGeneratedClass.entrySet()) {
                    InterfaceConfigPropertiesUtil.addProducerMethodForInterfaceConfigProperties((DotName)entry.getKey(), configPropertiesMetadata.getPrefix(), configPropertiesMetadata.isNeedsQualifier(), producerClassCreator, (InterfaceConfigPropertiesUtil.GeneratedClass)entry.getValue());
                }
                continue;
            }
            boolean needsValidation = ClassConfigPropertiesUtil.addProducerMethodForClassConfigProperties(Thread.currentThread().getContextClassLoader(), classInfo, producerClassCreator, configPropertiesMetadata.getPrefix(), configPropertiesMetadata.getNamingStrategy(), configPropertiesMetadata.isFailOnMismatchingMember(), configPropertiesMetadata.isNeedsQualifier(), combinedIndex.getIndex(), reflectiveMethods, configProperties);
            if (!needsValidation) continue;
            configClassesThatNeedValidation.add(classInfo.name());
        }
        producerClassCreator.close();
        if (!configClassesThatNeedValidation.isEmpty()) {
            ClassConfigPropertiesUtil.generateStartupObserverThatInjectsConfigClass(beansClassOutput, configClassesThatNeedValidation);
        }
    }
}

