/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.configproperties;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.config.ConfigProperties;
import io.quarkus.arc.deployment.ConfigPropertyBuildItem;
import io.quarkus.arc.deployment.configproperties.ConfigPropertiesUtil;
import io.quarkus.arc.deployment.configproperties.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.config.Config;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

final class InterfaceConfigPropertiesUtil {
    private InterfaceConfigPropertiesUtil() {
    }

    static void addProducerMethodForInterfaceConfigProperties(DotName interfaceName, String prefix, boolean needsQualifier, ClassCreator classCreator, GeneratedClass generatedClass) {
        String methodName = "produce" + interfaceName.withoutPackagePrefix();
        if (needsQualifier) {
            methodName = methodName + "WithPrefix" + HashUtil.sha1((String)prefix);
        }
        try (MethodCreator method = classCreator.getMethodCreator(methodName, interfaceName.toString(), new String[]{Config.class.getName()});){
            method.addAnnotation(Produces.class);
            if (needsQualifier) {
                method.addAnnotation(AnnotationInstance.create((DotName)DotNames.CONFIG_PREFIX, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)prefix)}));
            } else {
                method.addAnnotation(Default.class);
            }
            if (generatedClass.isUnremovable()) {
                method.addAnnotation(Unremovable.class);
            }
            method.returnValue(method.newInstance(MethodDescriptor.ofConstructor((Object)generatedClass.getName(), (Object[])new Object[]{Config.class}), new ResultHandle[]{method.getMethodParam(0)}));
        }
    }

    static void generateImplementationForInterfaceConfigProperties(ClassInfo originalInterface, ClassOutput classOutput, IndexView index, String prefixStr, ConfigProperties.NamingStrategy namingStrategy, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ConfigPropertyBuildItem> configProperties, Map<DotName, GeneratedClass> interfaceToGeneratedClass) {
        InterfaceConfigPropertiesUtil.generateImplementationForInterfaceConfigPropertiesRec(originalInterface, originalInterface, classOutput, index, prefixStr, namingStrategy, defaultConfigValues, configProperties, interfaceToGeneratedClass);
    }

    private static void generateImplementationForInterfaceConfigPropertiesRec(ClassInfo originalInterface, ClassInfo currentInterface, ClassOutput classOutput, IndexView index, String prefixStr, ConfigProperties.NamingStrategy namingStrategy, BuildProducer<RunTimeConfigurationDefaultBuildItem> defaultConfigValues, BuildProducer<ConfigPropertyBuildItem> configProperties, Map<DotName, GeneratedClass> interfaceToGeneratedClass) {
        HashSet<DotName> allInterfaces = new HashSet<DotName>();
        allInterfaces.add(currentInterface.name());
        InterfaceConfigPropertiesUtil.collectInterfacesRec(currentInterface, index, allInterfaces);
        String generatedClassName = InterfaceConfigPropertiesUtil.createName(currentInterface.name(), prefixStr);
        interfaceToGeneratedClass.put(currentInterface.name(), new GeneratedClass(generatedClassName, !originalInterface.name().equals((Object)currentInterface.name())));
        try (ClassCreator interfaceImplClassCreator = ClassCreator.builder().classOutput(classOutput).interfaces(new String[]{currentInterface.name().toString()}).className(generatedClassName).build();){
            FieldDescriptor configField = ((FieldCreator)interfaceImplClassCreator.getFieldCreator("config", Config.class).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator ctor = interfaceImplClassCreator.getMethodCreator("<init>", Void.TYPE, new Class[]{Config.class});){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ResultHandle self = ctor.getThis();
                ResultHandle config = ctor.getMethodParam(0);
                ctor.writeInstanceField(configField, self, config);
                ctor.returnValue(null);
            }
            for (DotName ifaceDotName : allInterfaces) {
                ClassInfo classInfo = index.getClassByName(ifaceDotName);
                List methods = classInfo.methods();
                for (MethodInfo method : methods) {
                    Type returnType = method.returnType();
                    if (InterfaceConfigPropertiesUtil.isDefault(method.flags())) continue;
                    if (!method.parameters().isEmpty()) {
                        throw new IllegalArgumentException("Method " + method.name() + " of interface " + ifaceDotName + " is not a getter method since it defined parameters");
                    }
                    if (returnType.kind() == Type.Kind.VOID) {
                        throw new IllegalArgumentException("Method " + method.name() + " of interface " + ifaceDotName + " is not a getter method since it returns void");
                    }
                    NameAndDefaultValue nameAndDefaultValue = InterfaceConfigPropertiesUtil.determinePropertyNameAndDefaultValue(method, namingStrategy);
                    String fullConfigName = prefixStr + "." + nameAndDefaultValue.getName();
                    MethodCreator methodCreator = interfaceImplClassCreator.getMethodCreator(method.name(), method.returnType().name().toString(), new String[0]);
                    Throwable throwable = null;
                    try {
                        ClassInfo returnTypeClassInfo;
                        if (returnType.kind() == Type.Kind.CLASS && (returnTypeClassInfo = index.getClassByName(returnType.name())) != null && Modifier.isInterface(returnTypeClassInfo.flags())) {
                            InterfaceConfigPropertiesUtil.generateImplementationForInterfaceConfigPropertiesRec(originalInterface, returnTypeClassInfo, classOutput, index, fullConfigName, namingStrategy, defaultConfigValues, configProperties, interfaceToGeneratedClass);
                            ResultHandle arcContainer = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
                            ResultHandle instanceHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{methodCreator.loadClass(returnTypeClassInfo.name().toString()), methodCreator.newArray(Annotation.class, 0)});
                            methodCreator.returnValue(methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]));
                            continue;
                        }
                        ResultHandle config = methodCreator.readInstanceField(configField, methodCreator.getThis());
                        String defaultValueStr = nameAndDefaultValue.getDefaultValue();
                        if (DotNames.OPTIONAL.equals((Object)returnType.name())) {
                            if (defaultValueStr != null) {
                                throw new IllegalArgumentException("Annotating a method returning Optional with @ConfigProperty and setting defaultValue is not supported. Offending method is " + method.name() + " of interface" + ifaceDotName);
                            }
                            Type genericType = ConfigPropertiesUtil.determineSingleGenericType(returnType, method.declaringClass().name());
                            if (genericType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                                ResultHandle result = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Config.class, (String)"getOptionalValue", Optional.class, (Class[])new Class[]{String.class, Class.class}), config, new ResultHandle[]{methodCreator.load(fullConfigName), methodCreator.loadClass(genericType.name().toString())});
                                methodCreator.returnValue(result);
                                continue;
                            }
                            ConfigPropertiesUtil.ReadOptionalResponse readOptionalResponse = ConfigPropertiesUtil.createReadOptionalValueAndConvertIfNeeded(fullConfigName, genericType, method.declaringClass().name(), (BytecodeCreator)methodCreator, config);
                            readOptionalResponse.getIsPresentFalse().returnValue(readOptionalResponse.getIsPresentFalse().invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"empty", Optional.class, (Class[])new Class[0]), new ResultHandle[0]));
                            readOptionalResponse.getIsPresentTrue().returnValue(readOptionalResponse.getIsPresentTrue().invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"of", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{readOptionalResponse.getValue()}));
                            continue;
                        }
                        if (defaultValueStr != null) {
                            defaultConfigValues.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(fullConfigName, defaultValueStr));
                        }
                        ResultHandle value = ConfigPropertiesUtil.createReadMandatoryValueAndConvertIfNeeded(fullConfigName, returnType, method.declaringClass().name(), (BytecodeCreator)methodCreator, config);
                        methodCreator.returnValue(value);
                        if (defaultValueStr != null && !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValueStr)) continue;
                        configProperties.produce((BuildItem)new ConfigPropertyBuildItem(fullConfigName, returnType));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (methodCreator == null) continue;
                        if (throwable != null) {
                            try {
                                methodCreator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        methodCreator.close();
                    }
                }
            }
        }
    }

    private static void collectInterfacesRec(ClassInfo current, IndexView index, Set<DotName> result) {
        List interfaces = current.interfaceNames();
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName iface : interfaces) {
            ClassInfo classByName = index.getClassByName(iface);
            if (classByName == null) {
                throw new IllegalStateException("Unable to collect interfaces of " + iface + " because it was not indexed. Consider adding it to Jandex index");
            }
            result.add(iface);
            InterfaceConfigPropertiesUtil.collectInterfacesRec(classByName, index, result);
        }
    }

    private static String createName(DotName ifaceName, String prefixStr) {
        return "io.quarkus.arc.runtime.config." + ifaceName.withoutPackagePrefix() + "_" + HashUtil.sha1((String)ifaceName.toString()) + "_" + HashUtil.sha1((String)prefixStr);
    }

    private static boolean isDefault(short flags) {
        return (flags & 0x409) == 1;
    }

    private static NameAndDefaultValue determinePropertyNameAndDefaultValue(MethodInfo method, ConfigProperties.NamingStrategy namingStrategy) {
        AnnotationInstance configPropertyAnnotation = method.annotation(DotNames.CONFIG_PROPERTY);
        if (configPropertyAnnotation != null) {
            AnnotationValue nameValue = configPropertyAnnotation.value("name");
            String name = nameValue == null || nameValue.asString().isEmpty() ? InterfaceConfigPropertiesUtil.getPropertyName(method, namingStrategy) : nameValue.asString();
            AnnotationValue defaultValue = configPropertyAnnotation.value("defaultValue");
            return new NameAndDefaultValue(name, defaultValue != null ? defaultValue.asString() : null);
        }
        return new NameAndDefaultValue(InterfaceConfigPropertiesUtil.getPropertyName(method, namingStrategy));
    }

    private static String getPropertyName(MethodInfo method, ConfigProperties.NamingStrategy namingStrategy) {
        String effectiveName = method.name();
        try {
            effectiveName = JavaBeanUtil.getPropertyNameFromGetter((String)method.name());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return namingStrategy.getName(effectiveName);
    }

    static class GeneratedClass {
        private final String name;
        private final boolean unremovable;

        public GeneratedClass(String name, boolean unremovable) {
            this.name = name;
            this.unremovable = unremovable;
        }

        public String getName() {
            return this.name;
        }

        public boolean isUnremovable() {
            return this.unremovable;
        }
    }

    private static class NameAndDefaultValue {
        private final String name;
        private final String defaultValue;

        NameAndDefaultValue(String name) {
            this(name, null);
        }

        NameAndDefaultValue(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

