/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class WrongAnnotationUsageProcessor {
    @BuildStep
    void detect(ArcConfig config, ApplicationIndexBuildItem applicationIndex, CustomScopeAnnotationsBuildItem scopeAnnotations, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        if (!config.detectWrongAnnotations) {
            return;
        }
        Index index = applicationIndex.getIndex();
        ArrayList<UnsupportedAnnotation> unsupported = new ArrayList<UnsupportedAnnotation>();
        Function<AnnotationInstance, String> singletonFun = new Function<AnnotationInstance, String>(){

            @Override
            public String apply(AnnotationInstance annotationInstance) {
                return String.format("%s declared on %s, use @javax.inject.Singleton instead", annotationInstance.toString(false), WrongAnnotationUsageProcessor.getTargetInfo(annotationInstance));
            }
        };
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"com.google.inject.Singleton"), singletonFun));
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"javax.ejb.Singleton"), singletonFun));
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"groovy.lang.Singleton"), singletonFun));
        unsupported.add(new UnsupportedAnnotation(DotName.createSimple((String)"jakarta.ejb.Singleton"), singletonFun));
        HashMap<AnnotationInstance, String> wrongUsages = new HashMap<AnnotationInstance, String>();
        for (UnsupportedAnnotation unsupportedAnnotation : unsupported) {
            for (AnnotationInstance annotationInstance : index.getAnnotations(unsupportedAnnotation.name)) {
                wrongUsages.put(annotationInstance, unsupportedAnnotation.messageFun.apply(annotationInstance));
            }
        }
        if (!wrongUsages.isEmpty()) {
            for (Map.Entry entry : wrongUsages.entrySet()) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException((String)entry.getValue())));
            }
        }
        for (ClassInfo classInfo : index.getKnownClasses()) {
            Collection<AnnotationInstance> classAnnotations;
            ClassInfo.NestingType nestingType = classInfo.nestingType();
            if (ClassInfo.NestingType.ANONYMOUS != nestingType && ClassInfo.NestingType.LOCAL != nestingType && (ClassInfo.NestingType.INNER != nestingType || Modifier.isStatic(classInfo.flags())) || (classAnnotations = transformedAnnotations.getAnnotations((AnnotationTarget)classInfo)).isEmpty() && classInfo.annotationsMap().isEmpty()) continue;
            if (scopeAnnotations.isScopeIn(classAnnotations)) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s has a scope annotation but it must be ignored per the CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
                continue;
            }
            if (classInfo.annotationsMap().containsKey(DotNames.OBSERVES)) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s declares an observer method but it must be ignored per the CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
                continue;
            }
            if (!classInfo.annotationsMap().containsKey(DotNames.PRODUCES)) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new IllegalStateException(String.format("The %s class %s declares a producer but it must be ignored per the CDI rules", classInfo.nestingType().toString(), classInfo.name().toString()))));
        }
    }

    private static String getTargetInfo(AnnotationInstance annotationInstance) {
        AnnotationTarget target = annotationInstance.target();
        switch (target.kind()) {
            case FIELD: {
                return target.asField().declaringClass().toString() + "." + target.asField().name();
            }
            case METHOD: {
                return target.asMethod().declaringClass().toString() + "." + target.asMethod().name() + "()";
            }
        }
        return target.toString();
    }

    private static class UnsupportedAnnotation {
        final DotName name;
        final Function<AnnotationInstance, String> messageFun;

        UnsupportedAnnotation(DotName name, Function<AnnotationInstance, String> messageFun) {
            this.name = name;
            this.messageFun = messageFun;
        }
    }
}

