/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.devui;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.devconsole.Invocation;
import io.quarkus.arc.runtime.devconsole.InvocationsMonitor;
import io.quarkus.arc.runtime.devmode.EventInfo;
import io.quarkus.arc.runtime.devmode.EventsMonitor;
import io.quarkus.arc.runtime.devmode.InvocationInfo;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class ArcJsonRPCService {
    public Multi<EventInfo> streamEvents() {
        EventsMonitor eventsMonitor = (EventsMonitor)Arc.container().instance(EventsMonitor.class, new Annotation[0]).get();
        if (eventsMonitor != null) {
            return eventsMonitor.streamEvents();
        }
        return Multi.createFrom().empty();
    }

    @NonBlocking
    public List<EventInfo> getLastEvents() {
        EventsMonitor eventsMonitor = (EventsMonitor)Arc.container().instance(EventsMonitor.class, new Annotation[0]).get();
        if (eventsMonitor != null) {
            return eventsMonitor.getLastEvents();
        }
        return List.of();
    }

    @NonBlocking
    public List<EventInfo> clearLastEvents() {
        EventsMonitor eventsMonitor = (EventsMonitor)Arc.container().instance(EventsMonitor.class, new Annotation[0]).get();
        if (eventsMonitor != null) {
            eventsMonitor.clear();
            return eventsMonitor.getLastEvents();
        }
        return List.of();
    }

    @NonBlocking
    public List<InvocationInfo> getLastInvocations() {
        InvocationsMonitor invocationsMonitor = (InvocationsMonitor)Arc.container().instance(InvocationsMonitor.class, new Annotation[0]).get();
        if (invocationsMonitor != null) {
            List<Invocation> lastInvocations = invocationsMonitor.getLastInvocations();
            return this.toInvocationInfos(lastInvocations);
        }
        return List.of();
    }

    @NonBlocking
    public List<InvocationInfo> clearLastInvocations() {
        InvocationsMonitor invocationsMonitor = (InvocationsMonitor)Arc.container().instance(InvocationsMonitor.class, new Annotation[0]).get();
        if (invocationsMonitor != null) {
            invocationsMonitor.clear();
            return this.getLastInvocations();
        }
        return List.of();
    }

    private List<InvocationInfo> toInvocationInfos(List<Invocation> invocations) {
        ArrayList<InvocationInfo> infos = new ArrayList<InvocationInfo>();
        for (Invocation invocation : invocations) {
            infos.add(this.toInvocationInfo(invocation));
        }
        return infos;
    }

    private InvocationInfo toInvocationInfo(Invocation invocation) {
        InvocationInfo info = new InvocationInfo();
        LocalDateTime starttime = LocalDateTime.ofInstant(Instant.ofEpochMilli(invocation.getStart()), ZoneId.systemDefault());
        info.setStartTime(this.timeString(starttime));
        return info;
    }

    private String timeString(LocalDateTime time) {
        String timestamp = time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", " ");
        return timestamp.substring(0, timestamp.lastIndexOf("."));
    }
}

