/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.PathTree;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class DefaultSourceDir
implements SourceDir,
Serializable {
    private static final long serialVersionUID = 6544177650615687691L;
    private final PathTree srcTree;
    private final PathTree outputTree;
    private final Map<Object, Object> data;

    public DefaultSourceDir(Path srcDir, Path destinationDir) {
        this(srcDir, destinationDir, Collections.emptyMap());
    }

    public DefaultSourceDir(Path srcDir, Path destinationDir, Map<Object, Object> data) {
        this(new DirectoryPathTree(srcDir), new DirectoryPathTree(destinationDir), data);
    }

    public DefaultSourceDir(PathTree srcTree, PathTree outputTree, Map<Object, Object> data) {
        this.srcTree = srcTree;
        this.outputTree = outputTree;
        this.data = data;
    }

    @Override
    public Path getDir() {
        return this.srcTree.getRoots().iterator().next();
    }

    @Override
    public PathTree getSourceTree() {
        return this.srcTree;
    }

    @Override
    public Path getOutputDir() {
        return this.outputTree.getRoots().iterator().next();
    }

    @Override
    public PathTree getOutputTree() {
        return this.outputTree;
    }

    @Override
    public <T> T getValue(Object key, Class<T> type) {
        Object o = this.data.get(key);
        return o == null ? null : (T)type.cast(o);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.outputTree, this.srcTree);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSourceDir other = (DefaultSourceDir)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.outputTree, other.outputTree) && Objects.equals(this.srcTree, other.srcTree);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.srcTree.getRoots()).append(" -> ").append(this.outputTree.getRoots());
        if (!this.data.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> i = this.data.entrySet().iterator();
            Map.Entry<Object, Object> e = i.next();
            buf.append(" ").append(e.getKey()).append("=").append(e.getValue());
            while (i.hasNext()) {
                e = i.next();
                buf.append(",").append(e.getKey()).append("=").append(e.getValue());
            }
        }
        return buf.toString();
    }
}

