/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathTreeVisit;
import io.quarkus.paths.PathTreeWithManifest;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;

public class DirectoryPathTree
extends PathTreeWithManifest
implements OpenPathTree,
Serializable {
    private static final boolean USE_WINDOWS_ABSOLUTE_PATH_PATTERN = !FileSystems.getDefault().getSeparator().equals("/");
    private static volatile Pattern windowsAbsolutePathPattern;
    private Path dir;
    private PathFilter pathFilter;

    private static Pattern windowsAbsolutePathPattern() {
        return windowsAbsolutePathPattern == null ? (windowsAbsolutePathPattern = Pattern.compile("[a-zA-Z]:\\\\.*")) : windowsAbsolutePathPattern;
    }

    static boolean isAbsolutePath(String path) {
        return path != null && !path.isEmpty() && (path.charAt(0) == '/' || USE_WINDOWS_ABSOLUTE_PATH_PATTERN && DirectoryPathTree.windowsAbsolutePathPattern().matcher(path).matches() || path.startsWith(FileSystems.getDefault().getSeparator()));
    }

    static void ensureRelativePath(String path) {
        if (DirectoryPathTree.isAbsolutePath(path)) {
            throw new IllegalArgumentException("Expected a path relative to the root of the path tree but got " + path);
        }
    }

    public DirectoryPathTree() {
    }

    public DirectoryPathTree(Path dir) {
        this(dir, null);
    }

    public DirectoryPathTree(Path dir, PathFilter pathFilter) {
        this(dir, pathFilter, false);
    }

    public DirectoryPathTree(Path dir, PathFilter pathFilter, boolean manifestEnabled) {
        super(manifestEnabled);
        this.dir = dir;
        this.pathFilter = pathFilter;
    }

    protected DirectoryPathTree(Path dir, PathFilter pathFilter, PathTreeWithManifest pathTreeWithManifest) {
        super(pathTreeWithManifest);
        this.dir = dir;
        this.pathFilter = pathFilter;
    }

    @Override
    public Collection<Path> getRoots() {
        return Collections.singletonList(this.dir);
    }

    @Override
    public void walk(PathVisitor visitor) {
        PathTreeVisit.walk(this.dir, this.dir, this.pathFilter, this.getMultiReleaseMapping(), visitor);
    }

    private String normalize(String path) {
        DirectoryPathTree.ensureRelativePath(path);
        if (path != null && path.contains("..")) {
            Path absolutePath = this.dir.resolve(path).normalize().toAbsolutePath();
            if (absolutePath.startsWith(this.dir)) {
                return this.dir.relativize(absolutePath).toString();
            }
            return null;
        }
        return path;
    }

    @Override
    protected <T> T apply(String relativePath, Function<PathVisit, T> func, boolean manifestEnabled) {
        if (!PathFilter.isVisible(this.pathFilter, relativePath = this.normalize(relativePath))) {
            return func.apply(null);
        }
        Path path = this.dir.resolve(manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        if (!Files.exists(path, new LinkOption[0])) {
            return func.apply(null);
        }
        return PathTreeVisit.process(this.dir, this.dir, path, this.pathFilter, func);
    }

    @Override
    public void accept(String relativePath, Consumer<PathVisit> consumer) {
        if (!PathFilter.isVisible(this.pathFilter, relativePath = this.normalize(relativePath))) {
            consumer.accept(null);
            return;
        }
        Path path = this.dir.resolve(this.manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        if (!Files.exists(path, new LinkOption[0])) {
            consumer.accept(null);
            return;
        }
        PathTreeVisit.consume(this.dir, this.dir, path, this.pathFilter, consumer);
    }

    @Override
    public boolean contains(String relativePath) {
        if (!PathFilter.isVisible(this.pathFilter, relativePath = this.normalize(relativePath))) {
            return false;
        }
        Path path = this.dir.resolve(this.manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    public Path getPath(String relativePath) {
        if (!PathFilter.isVisible(this.pathFilter, relativePath = this.normalize(relativePath))) {
            return null;
        }
        Path path = this.dir.resolve(this.manifestEnabled ? this.toMultiReleaseRelativePath(relativePath) : relativePath);
        return Files.exists(path, new LinkOption[0]) ? path : null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.dir.toAbsolutePath().toString());
        out.writeObject(this.pathFilter);
        out.writeBoolean(this.manifestEnabled);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.dir = Paths.get(in.readUTF(), new String[0]);
        this.pathFilter = (PathFilter)in.readObject();
        this.manifestEnabled = in.readBoolean();
    }

    @Override
    public OpenPathTree open() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public PathTree getOriginalTree() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.dir, this.pathFilter, this.manifestEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryPathTree other = (DirectoryPathTree)obj;
        return Objects.equals(this.dir, other.dir) && Objects.equals(this.pathFilter, other.pathFilter) && this.manifestEnabled == other.manifestEnabled;
    }
}

