/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.smallrye.common.io.jar.JarEntries;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public class JarClassPathElement
implements ClassPathElement {
    private static final Logger log = Logger.getLogger(JarClassPathElement.class);
    private final File file;
    private final URL jarPath;
    private final Path root;
    private JarFile jarFile;
    private boolean closed;

    public JarClassPathElement(Path root) {
        try {
            this.jarPath = root.toUri().toURL();
            this.root = root;
            this.file = root.toFile();
            this.jarFile = JarFiles.create((File)this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while reading file as JAR: " + root, e);
        }
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public synchronized ClassPathResource getResource(final String name) {
        return this.withJarFile(new Function<JarFile, ClassPathResource>(){

            @Override
            public ClassPathResource apply(JarFile jarFile) {
                final JarEntry res = jarFile.getJarEntry(name);
                if (res != null) {
                    return new ClassPathResource(){

                        @Override
                        public ClassPathElement getContainingElement() {
                            return JarClassPathElement.this;
                        }

                        @Override
                        public String getPath() {
                            return name;
                        }

                        @Override
                        public URL getUrl() {
                            try {
                                String realName = JarEntries.getRealName((JarEntry)res);
                                if (realName.endsWith("/")) {
                                    realName = realName.substring(0, realName.length() - 1);
                                }
                                String urlFile = JarClassPathElement.this.jarPath.getProtocol() + ":" + JarClassPathElement.this.jarPath.getPath() + "!/" + realName;
                                return new URL("jar", null, urlFile);
                            }
                            catch (MalformedURLException e) {
                                throw new UncheckedIOException(e);
                            }
                        }

                        @Override
                        public byte[] getData() {
                            return (byte[])JarClassPathElement.this.withJarFile(new Function<JarFile, byte[]>(){

                                @Override
                                public byte[] apply(JarFile jarFile) {
                                    try {
                                        try {
                                            return JarClassPathElement.readStreamContents(jarFile.getInputStream(res));
                                        }
                                        catch (InterruptedIOException e) {
                                            byte[] bytes = JarClassPathElement.readStreamContents(jarFile.getInputStream(res));
                                            Thread.currentThread().interrupt();
                                            return bytes;
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Unable to read " + name, e);
                                    }
                                }
                            });
                        }

                        @Override
                        public boolean isDirectory() {
                            return res.getName().endsWith("/");
                        }
                    };
                }
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withJarFile(Function<JarFile, T> func) {
        if (!this.closed) return (T)func.apply(this.jarFile);
        try (JarFile jarFile = JarFiles.create((File)this.file);){
            JarFile jarFile2 = func.apply(jarFile);
            return (T)jarFile2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Set<String> getProvidedResources() {
        return this.withJarFile(new Function<JarFile, Set<String>>(){

            @Override
            public Set<String> apply(JarFile jarFile) {
                HashSet<String> paths = new HashSet<String>();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().endsWith("/")) {
                        paths.add(entry.getName().substring(0, entry.getName().length() - 1));
                        continue;
                    }
                    paths.add(entry.getName());
                }
                return paths;
            }
        });
    }

    @Override
    public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
        URL url = null;
        try {
            URI uri = new URI("jar:file", null, this.jarPath.getPath() + "!/", null);
            url = uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.jarPath, e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        ProtectionDomain protectionDomain = new ProtectionDomain(codesource, null, classLoader, null);
        return protectionDomain;
    }

    @Override
    public Manifest getManifest() {
        return this.withJarFile(new Function<JarFile, Manifest>(){

            @Override
            public Manifest apply(JarFile jarFile) {
                try {
                    return jarFile.getManifest();
                }
                catch (IOException e) {
                    log.warnf("Failed to parse manifest for %s", (Object)JarClassPathElement.this.jarPath);
                    return null;
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.jarFile.close();
    }

    /*
     * Loose catch block
     */
    public static byte[] readStreamContents(InputStream inputStream) throws IOException {
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int r;
                byte[] buf = new byte[10000];
                while ((r = inputStream.read(buf)) > 0) {
                    out.write(buf, 0, r);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public String toString() {
        return this.file.getName() + ": " + this.jarPath;
    }
}

