/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.utils;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.QuarkusGradleModelFactory;
import io.quarkus.bootstrap.resolver.model.QuarkusModel;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class BuildToolHelper {
    private BuildToolHelper() {
    }

    public static boolean isMavenProject(Path project) {
        for (Path currentPath = project; currentPath != null; currentPath = currentPath.getParent()) {
            if (Files.exists(currentPath.resolve(BuildTool.MAVEN.getBuildFile()), new LinkOption[0])) {
                return true;
            }
            if (!Files.exists(currentPath.resolve(BuildTool.GRADLE.getBuildFile()), new LinkOption[0])) continue;
            return false;
        }
        return false;
    }

    public static Path getBuildFile(Path project, BuildTool tool) {
        for (Path currentPath = project; currentPath != null; currentPath = currentPath.getParent()) {
            if (!Files.exists(currentPath.resolve(tool.getBuildFile()), new LinkOption[0])) continue;
            return currentPath;
        }
        return null;
    }

    public static QuarkusModel enableGradleAppModel(Path projectRoot, String mode, String ... tasks) throws IOException, AppModelResolverException {
        if (BuildToolHelper.isMavenProject(projectRoot)) {
            return null;
        }
        QuarkusModel model = QuarkusGradleModelFactory.create((File)BuildToolHelper.getBuildFile(projectRoot, BuildTool.GRADLE).toFile(), (String)mode, (String[])tasks);
        QuarkusModelHelper.exportModel((QuarkusModel)model);
        return model;
    }

    public static QuarkusModel enableGradleAppModelForDevMode(Path projectRoot) throws IOException, AppModelResolverException {
        if (BuildToolHelper.isMavenProject(projectRoot)) {
            return null;
        }
        QuarkusModel model = QuarkusGradleModelFactory.createForTasks((File)BuildToolHelper.getBuildFile(projectRoot, BuildTool.GRADLE).toFile(), (String[])QuarkusModelHelper.DEVMODE_REQUIRED_TASKS);
        QuarkusModelHelper.exportModel((QuarkusModel)model);
        return model;
    }

    public static enum BuildTool {
        MAVEN("pom.xml"),
        GRADLE("build.gradle");

        private final String buildFile;

        private BuildTool(String buildFile) {
            this.buildFile = buildFile;
        }

        public String getBuildFile() {
            return this.buildFile;
        }
    }
}

