/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.JarResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class SerializedApplication {
    private static final int MAGIC = -265202638;
    private static final int VERSION = 1;
    private final RunnerClassLoader runnerClassLoader;
    private final String mainClass;

    public SerializedApplication(RunnerClassLoader runnerClassLoader, String mainClass) {
        this.runnerClassLoader = runnerClassLoader;
        this.mainClass = mainClass;
    }

    public RunnerClassLoader getRunnerClassLoader() {
        return this.runnerClassLoader;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public static void write(OutputStream outputStream, String mainClass, Path applicationRoot, List<Path> classPath, List<Path> parentFirst) throws IOException {
        try (DataOutputStream data = new DataOutputStream(outputStream);){
            data.writeInt(-265202638);
            data.writeInt(1);
            data.writeUTF(mainClass);
            data.writeInt(classPath.size());
            for (Path jar : classPath) {
                String relativePath = applicationRoot.relativize(jar).toString().replace("\\", "/");
                data.writeUTF(relativePath);
                SerializedApplication.writeJar(data, jar);
            }
            HashSet<String> parentFirstPackages = new HashSet<String>();
            for (Path jar : parentFirst) {
                SerializedApplication.collectPackages(jar, parentFirstPackages);
            }
            data.writeInt(parentFirstPackages.size());
            for (String p : parentFirstPackages) {
                data.writeUTF(p.replace("/", ".").replace("\\", "."));
            }
            data.flush();
        }
    }

    public static SerializedApplication read(InputStream inputStream, Path appRoot) throws IOException {
        try (DataInputStream in = new DataInputStream(inputStream);){
            if (in.readInt() != -265202638) {
                throw new RuntimeException("Wrong magic number");
            }
            if (in.readInt() != 1) {
                throw new RuntimeException("Wrong class path version");
            }
            String mainClass = in.readUTF();
            HashMap<String, ClassLoadingResource[]> resourceDirectoryMap = new HashMap<String, ClassLoadingResource[]>();
            HashSet<String> parentFirstPackages = new HashSet<String>();
            int numPaths = in.readInt();
            for (int pathCount = 0; pathCount < numPaths; ++pathCount) {
                String path = in.readUTF();
                boolean hasManifest = in.readBoolean();
                ManifestInfo info = null;
                if (hasManifest) {
                    info = new ManifestInfo(SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in), SerializedApplication.readNullableString(in));
                }
                JarResource resource = new JarResource(info, appRoot.resolve(path));
                int numDirs = in.readInt();
                for (int i = 0; i < numDirs; ++i) {
                    String dir = in.readUTF();
                    ClassLoadingResource[] existing = (ClassLoadingResource[])resourceDirectoryMap.get(dir);
                    if (existing == null) {
                        resourceDirectoryMap.put(dir, new ClassLoadingResource[]{resource});
                        continue;
                    }
                    ClassLoadingResource[] newResources = new ClassLoadingResource[existing.length + 1];
                    System.arraycopy(existing, 0, newResources, 0, existing.length);
                    newResources[existing.length] = resource;
                    resourceDirectoryMap.put(dir, newResources);
                }
            }
            int packages = in.readInt();
            for (int i = 0; i < packages; ++i) {
                parentFirstPackages.add(in.readUTF());
            }
            SerializedApplication serializedApplication = new SerializedApplication(new RunnerClassLoader(ClassLoader.getSystemClassLoader(), resourceDirectoryMap, parentFirstPackages), mainClass);
            return serializedApplication;
        }
    }

    private static String readNullableString(DataInputStream in) throws IOException {
        if (in.readBoolean()) {
            return in.readUTF();
        }
        return null;
    }

    private static void writeJar(DataOutputStream out, Path jar) throws IOException {
        try (JarFile zip = new JarFile(jar.toFile());){
            Manifest manifest = zip.getManifest();
            if (manifest == null) {
                out.writeBoolean(false);
            } else {
                Attributes ma = manifest.getMainAttributes();
                if (ma == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.SPECIFICATION_TITLE));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.SPECIFICATION_VERSION));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.SPECIFICATION_VENDOR));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                    SerializedApplication.writeNullableString(out, ma.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
                }
            }
            HashSet<String> dirs = new HashSet<String>();
            Enumeration<JarEntry> entries = zip.entries();
            boolean hasDefaultPackge = false;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().contains("/")) {
                    hasDefaultPackge = true;
                    continue;
                }
                if (entry.isDirectory()) continue;
                int index = entry.getName().lastIndexOf(47);
                dirs.add(entry.getName().substring(0, index));
            }
            if (hasDefaultPackge) {
                dirs.add("");
            }
            out.writeInt(dirs.size());
            for (String i : dirs) {
                out.writeUTF(i);
            }
        }
    }

    private static void collectPackages(final Path jar, final Set<String> dirs) throws IOException {
        if (Files.isDirectory(jar, new LinkOption[0])) {
            Files.walkFileTree(jar, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    dirs.add(jar.relativize(dir).toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            try (JarFile zip = new JarFile(jar.toFile());){
                Enumeration<JarEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    int index;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || (index = entry.getName().lastIndexOf(47)) <= 0) continue;
                    dirs.add(entry.getName().substring(0, index));
                }
            }
        }
    }

    private static void writeNullableString(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(string);
        }
    }
}

