/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStepBuilder;
import io.quarkus.builder.ConsumeFlag;
import io.quarkus.builder.ConsumeFlags;
import io.quarkus.builder.ProduceFlag;
import io.quarkus.builder.ProduceFlags;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Overridable;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.annotations.Weak;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.BuildTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.BuildTimeRunTimeFixedConfigurationBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.MainBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationBuildItem;
import io.quarkus.deployment.builditem.StaticBytecodeRecorderBuildItem;
import io.quarkus.deployment.builditem.UnmatchedConfigBuildItem;
import io.quarkus.deployment.configuration.ConfigDefinition;
import io.quarkus.deployment.configuration.DefaultValuesConfigurationSource;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.annotations.Template;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSource;
import io.quarkus.runtime.configuration.ConverterSupport;
import io.quarkus.runtime.configuration.DeploymentProfileConfigSource;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;
import org.wildfly.common.function.Functions;

public final class ExtensionLoader {
    private static final Logger cfgLog = Logger.getLogger((String)"io.quarkus.configuration");
    public static final String BUILD_TIME_CONFIG = "io.quarkus.runtime.generated.BuildTimeConfig";
    public static final String BUILD_TIME_CONFIG_ROOT = "io.quarkus.runtime.generated.BuildTimeConfigRoot";
    public static final String RUN_TIME_CONFIG = "io.quarkus.runtime.generated.RunTimeConfig";
    public static final String RUN_TIME_CONFIG_ROOT = "io.quarkus.runtime.generated.RunTimeConfigRoot";
    private static final FieldDescriptor RUN_TIME_CONFIG_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.RunTimeConfig", (String)"runConfig", (String)"io.quarkus.runtime.generated.RunTimeConfigRoot");
    private static final FieldDescriptor BUILD_TIME_CONFIG_FIELD = FieldDescriptor.of((String)"io.quarkus.runtime.generated.BuildTimeConfig", (String)"buildConfig", (String)"io.quarkus.runtime.generated.BuildTimeConfigRoot");
    private static final String CONFIG_ROOTS_LIST = "META-INF/quarkus-config-roots.list";

    private ExtensionLoader() {
    }

    private static boolean isRecorder(AnnotatedElement element) {
        return element.isAnnotationPresent(Recorder.class) || element.isAnnotationPresent(Template.class);
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        return ExtensionLoader.loadStepsFrom(classLoader, new Properties());
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(ClassLoader classLoader, LaunchMode launchMode, Consumer<ConfigBuilder> configCustomizer) throws IOException, ClassNotFoundException {
        return ExtensionLoader.loadStepsFrom(classLoader, new Properties(), launchMode, configCustomizer);
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(ClassLoader classLoader, Properties buildSystemProps) throws IOException, ClassNotFoundException {
        return ExtensionLoader.loadStepsFrom(classLoader, buildSystemProps, LaunchMode.NORMAL, null);
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(ClassLoader classLoader, Properties buildSystemProps, LaunchMode launchMode, Consumer<ConfigBuilder> configCustomizer) throws IOException, ClassNotFoundException {
        ConfigDefinition buildTimeConfig = new ConfigDefinition(FieldDescriptor.of((String)"Bogus", (String)"No field", (String)"Nothing"));
        ConfigDefinition buildTimeRunTimeConfig = new ConfigDefinition(BUILD_TIME_CONFIG_FIELD);
        ConfigDefinition runTimeConfig = new ConfigDefinition(RUN_TIME_CONFIG_FIELD, true);
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, CONFIG_ROOTS_LIST)) {
            ConfigRoot annotation = clazz.getAnnotation(ConfigRoot.class);
            if (annotation == null) {
                cfgLog.warnf("Ignoring configuration root %s because it has no annotation", clazz);
                continue;
            }
            ConfigPhase phase = annotation.phase();
            if (phase == ConfigPhase.RUN_TIME) {
                runTimeConfig.registerConfigRoot(clazz);
                continue;
            }
            if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                buildTimeRunTimeConfig.registerConfigRoot(clazz);
                continue;
            }
            if (phase == ConfigPhase.BUILD_TIME) {
                buildTimeConfig.registerConfigRoot(clazz);
                continue;
            }
            cfgLog.warnf("Unrecognized configuration phase \"%s\" on %s", (Object)phase, clazz);
        }
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        ExpandingConfigSource.Cache cache = new ExpandingConfigSource.Cache();
        builder.withWrapper(ExpandingConfigSource.wrapper((ExpandingConfigSource.Cache)cache));
        builder.withWrapper(DeploymentProfileConfigSource.wrapper());
        builder.addDefaultSources();
        ApplicationPropertiesConfigSource.InJar inJar = new ApplicationPropertiesConfigSource.InJar();
        DefaultValuesConfigurationSource defaultSource = new DefaultValuesConfigurationSource(buildTimeConfig.getLeafPatterns());
        PropertiesConfigSource pcs = new PropertiesConfigSource(buildSystemProps, "Build system");
        builder.withSources(new ConfigSource[]{inJar, defaultSource, pcs});
        ConverterSupport.populateConverters((ConfigBuilder)builder);
        if (configCustomizer != null) {
            configCustomizer.accept((ConfigBuilder)builder);
        }
        SmallRyeConfig src = (SmallRyeConfig)builder.addDefaultSources().addDiscoveredSources().addDiscoveredConverters().build();
        SmallRyeConfigProviderResolver.instance().registerConfig((Config)src, classLoader);
        HashSet<String> unmatched = new HashSet<String>();
        ConfigDefinition.loadConfiguration(cache, src, unmatched, buildTimeConfig, buildTimeRunTimeConfig, runTimeConfig);
        unmatched.removeIf(s -> !inJar.getPropertyNames().contains(s) && !s.startsWith("quarkus."));
        Consumer<BuildChainBuilder> result = Functions.discardingConsumer();
        result = result.andThen(bcb -> bcb.addBuildStep(bc -> {
            bc.produce((BuildItem)new BuildTimeConfigurationBuildItem(buildTimeConfig));
            bc.produce((BuildItem)new BuildTimeRunTimeFixedConfigurationBuildItem(buildTimeRunTimeConfig));
            bc.produce((BuildItem)new RunTimeConfigurationBuildItem(runTimeConfig));
            bc.produce((BuildItem)new UnmatchedConfigBuildItem(Collections.unmodifiableSet(unmatched)));
        }).produces(BuildTimeConfigurationBuildItem.class).produces(BuildTimeRunTimeFixedConfigurationBuildItem.class).produces(RunTimeConfigurationBuildItem.class).produces(UnmatchedConfigBuildItem.class).build());
        for (Class<?> clazz : ServiceUtil.classesNamedIn(classLoader, "META-INF/quarkus-build-steps.list")) {
            try {
                result = result.andThen(ExtensionLoader.loadStepsFrom(clazz, buildTimeConfig, buildTimeRunTimeConfig, launchMode));
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to load steps from " + clazz, e);
            }
        }
        return result;
    }

    public static Consumer<BuildChainBuilder> loadStepsFrom(final Class<?> clazz, ConfigDefinition buildTimeConfig, ConfigDefinition buildTimeRunTimeConfig, LaunchMode launchMode) {
        Method[] methods;
        Field[] fields;
        List ctorParamFns;
        Parameter[] ctorParameters;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Consumer<BuildChainBuilder> chainConfig = Functions.discardingConsumer();
        Consumer<BuildStepBuilder> stepConfig = Functions.discardingConsumer();
        BiConsumer<BuildContext, Object> stepInstanceSetup = Functions.discardingBiConsumer();
        HashMap<Class<? extends BooleanSupplier>, BooleanSupplier> condCache = new HashMap<Class<? extends BooleanSupplier>, BooleanSupplier>();
        if (constructors.length != 1) {
            throw ExtensionLoader.reportError(clazz, "Build step classes must have exactly one constructor");
        }
        EnumSet<ConfigPhase> consumingConfigPhases = EnumSet.noneOf(ConfigPhase.class);
        Constructor<?> constructor = constructors[0];
        if (!Modifier.isPublic(constructor.getModifiers())) {
            constructor.setAccessible(true);
        }
        if ((ctorParameters = constructor.getParameters()).length == 0) {
            ctorParamFns = Collections.emptyList();
        } else {
            ctorParamFns = new ArrayList(ctorParameters.length);
            for (Parameter parameter : ctorParameters) {
                Class<SimpleBuildItem> buildItemClass;
                Type parameterType = parameter.getParameterizedType();
                Class<?> parameterClass = parameter.getType();
                boolean weak = parameter.isAnnotationPresent(Weak.class);
                boolean overridable = parameter.isAnnotationPresent(Overridable.class);
                if (ReflectUtil.rawTypeExtends(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOf(parameterType).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> bc.consume(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isListOf(parameterType, MultiBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(MultiBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> bc.consumeMulti(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isConsumerOf(parameterType, BuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                    stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                    ctorParamFns.add(bc -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                    continue;
                }
                if (ReflectUtil.isBuildProducerOf(parameterType, BuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                    stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                    ctorParamFns.add(bc -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                    continue;
                }
                if (ReflectUtil.isOptionalOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                    ctorParamFns.add(bc -> Optional.ofNullable(bc.consume(buildItemClass)));
                    continue;
                }
                if (ReflectUtil.isSupplierOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                    ctorParamFns.add(bc -> () -> bc.consume(buildItemClass));
                    continue;
                }
                if (ReflectUtil.isSupplierOfOptionalOf(parameterType, SimpleBuildItem.class)) {
                    buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(parameterType, 0), 0).asSubclass(SimpleBuildItem.class);
                    stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                    ctorParamFns.add(bc -> () -> Optional.ofNullable(bc.consume(buildItemClass)));
                    continue;
                }
                if (ReflectUtil.rawTypeOf(parameterType) == Executor.class) {
                    ctorParamFns.add(BuildContext::getExecutor);
                    continue;
                }
                if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                    ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                    ConfigPhase phase = annotation.phase();
                    consumingConfigPhases.add(phase);
                    if (phase == ConfigPhase.BUILD_TIME) {
                        ctorParamFns.add(bc -> ((BuildTimeConfigurationBuildItem)bc.consume(BuildTimeConfigurationBuildItem.class)).getConfigDefinition().getRealizedInstance(parameterClass));
                        continue;
                    }
                    if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                        ctorParamFns.add(bc -> ((BuildTimeRunTimeFixedConfigurationBuildItem)bc.consume(BuildTimeRunTimeFixedConfigurationBuildItem.class)).getConfigDefinition().getRealizedInstance(parameterClass));
                        continue;
                    }
                    if (phase == ConfigPhase.RUN_TIME) {
                        ctorParamFns.add(bc -> ((RunTimeConfigurationBuildItem)bc.consume(RunTimeConfigurationBuildItem.class)).getConfigDefinition().getRealizedInstance(parameterClass));
                        continue;
                    }
                    throw ExtensionLoader.reportError(parameterClass, "Unknown value for ConfigPhase");
                }
                if (ExtensionLoader.isRecorder(parameterClass)) {
                    throw ExtensionLoader.reportError(parameter, "Bytecode recorders disallowed on constructor parameters");
                }
                throw ExtensionLoader.reportError(parameter, "Unsupported constructor parameter type " + parameterType);
            }
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<SimpleBuildItem> buildItemClass;
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                field.setAccessible(true);
            }
            Type fieldType = field.getGenericType();
            Class<?> fieldClass = field.getType();
            boolean weak = field.isAnnotationPresent(Weak.class);
            boolean overridable = field.isAnnotationPresent(Overridable.class);
            if (ReflectUtil.rawTypeExtends(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOf(fieldType).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.consume(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isListOf(fieldType, MultiBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(MultiBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.consumeMulti(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isConsumerOf(fieldType, BuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(BuildItem.class);
                stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, arg_0 -> ((BuildContext)bc).produce(arg_0)));
                continue;
            }
            if (ReflectUtil.isBuildProducerOf(fieldType, BuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(BuildItem.class);
                stepConfig = overridable ? (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? stepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : stepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, arg_0 -> ((BuildContext)bc).produce(arg_0)));
                continue;
            }
            if (ReflectUtil.isOptionalOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, Optional.ofNullable(bc.consume(buildItemClass))));
                continue;
            }
            if (ReflectUtil.isSupplierOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(fieldType, 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, () -> bc.consume(buildItemClass)));
                continue;
            }
            if (ReflectUtil.isSupplierOfOptionalOf(fieldType, SimpleBuildItem.class)) {
                buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(fieldType, 0), 0).asSubclass(SimpleBuildItem.class);
                stepConfig = stepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, () -> Optional.ofNullable(bc.consume(buildItemClass))));
                continue;
            }
            if (fieldClass == Executor.class) {
                stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> ReflectUtil.setFieldVal(field, o, bc.getExecutor()));
                continue;
            }
            if (fieldClass.isAnnotationPresent(ConfigRoot.class)) {
                ConfigRoot annotation = fieldClass.getAnnotation(ConfigRoot.class);
                ConfigPhase phase = annotation.phase();
                consumingConfigPhases.add(phase);
                if (phase == ConfigPhase.BUILD_TIME) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        BuildTimeConfigurationBuildItem configurationBuildItem = (BuildTimeConfigurationBuildItem)bc.consume(BuildTimeConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getConfigDefinition().getRealizedInstance(fieldClass));
                    });
                    continue;
                }
                if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        BuildTimeRunTimeFixedConfigurationBuildItem configurationBuildItem = (BuildTimeRunTimeFixedConfigurationBuildItem)bc.consume(BuildTimeRunTimeFixedConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getConfigDefinition().getRealizedInstance(fieldClass));
                    });
                    continue;
                }
                if (phase == ConfigPhase.RUN_TIME) {
                    stepInstanceSetup = stepInstanceSetup.andThen((bc, o) -> {
                        RunTimeConfigurationBuildItem configurationBuildItem = (RunTimeConfigurationBuildItem)bc.consume(RunTimeConfigurationBuildItem.class);
                        ReflectUtil.setFieldVal(field, o, configurationBuildItem.getConfigDefinition().getRealizedInstance(fieldClass));
                    });
                    continue;
                }
                throw ExtensionLoader.reportError(fieldClass, "Unknown value for ConfigPhase");
            }
            if (ExtensionLoader.isRecorder(fieldClass)) {
                throw ExtensionLoader.reportError(field, "Bytecode recorders disallowed on fields");
            }
            throw ExtensionLoader.reportError(field, "Unsupported field type " + fieldType);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Produce[] produces;
            Consume[] consumes;
            BiConsumer<BuildContext, Object> resultConsumer;
            List methodParamFns;
            boolean isRecorder;
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || !method.isAnnotationPresent(BuildStep.class)) continue;
            if (!Modifier.isPublic(mods) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                method.setAccessible(true);
            }
            BuildStep buildStep = method.getAnnotation(BuildStep.class);
            String[] archiveMarkers = buildStep.applicationArchiveMarkers();
            String[] capabilities = buildStep.providesCapabilities();
            Class<? extends BooleanSupplier>[] onlyIf = buildStep.onlyIf();
            Class<? extends BooleanSupplier>[] onlyIfNot = buildStep.onlyIfNot();
            Parameter[] methodParameters = method.getParameters();
            Record recordAnnotation = method.getAnnotation(Record.class);
            boolean bl = isRecorder = recordAnnotation != null;
            if (isRecorder) {
                boolean recorderFound = false;
                for (Class<?> p : method.getParameterTypes()) {
                    if (!p.isAnnotationPresent(Recorder.class) && !p.isAnnotationPresent(Template.class)) continue;
                    recorderFound = true;
                    break;
                }
                if (!recorderFound) {
                    throw new RuntimeException(method + " is marked @Record but does not inject an @Recorder object");
                }
            }
            Consumer<BuildStepBuilder> methodStepConfig = Functions.discardingConsumer();
            BooleanSupplier addStep = () -> true;
            for (boolean bl2 : new boolean[]{false, true}) {
                Class<? extends BooleanSupplier>[] testClasses;
                for (Class<? extends BooleanSupplier> testClass : testClasses = bl2 ? onlyIfNot : onlyIf) {
                    BooleanSupplier bs = (BooleanSupplier)condCache.get(testClass);
                    if (bs == null) {
                        Consumer<BooleanSupplier> setup = o -> {};
                        Constructor<?>[] ctors = testClass.getDeclaredConstructors();
                        if (ctors.length != 1) {
                            throw ExtensionLoader.reportError(testClass, "Conditional class must declare exactly one constructor");
                        }
                        Constructor<?> ctor = ctors[0];
                        ctor.setAccessible(true);
                        ArrayList<Supplier<Object>> paramSuppList = new ArrayList<Supplier<Object>>();
                        for (Parameter parameter : ctor.getParameters()) {
                            Class<?> parameterClass = parameter.getType();
                            if (parameterClass == LaunchMode.class) {
                                paramSuppList.add(() -> launchMode);
                                continue;
                            }
                            if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                                ConfigDefinition confDef;
                                ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                                ConfigPhase phase = annotation.phase();
                                if (phase == ConfigPhase.BUILD_TIME) {
                                    confDef = buildTimeConfig;
                                } else if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                                    confDef = buildTimeRunTimeConfig;
                                } else {
                                    throw ExtensionLoader.reportError(parameter, "Unsupported conditional class configuration build phase " + phase);
                                }
                                paramSuppList.add(() -> confDef.getRealizedInstance(parameterClass));
                                continue;
                            }
                            throw ExtensionLoader.reportError(parameter, "Unsupported conditional class constructor parameter type " + parameterClass);
                        }
                        for (AnnotatedElement annotatedElement : testClass.getDeclaredFields()) {
                            Class<?> fieldClass;
                            int fieldMods = ((Field)annotatedElement).getModifiers();
                            if (Modifier.isStatic(fieldMods) || Modifier.isFinal(fieldMods)) continue;
                            if (!Modifier.isPublic(fieldMods) || !Modifier.isPublic(((Field)annotatedElement).getDeclaringClass().getModifiers())) {
                                ((Field)annotatedElement).setAccessible(true);
                            }
                            if ((fieldClass = ((Field)annotatedElement).getType()) == LaunchMode.class) {
                                setup = setup.andThen(arg_0 -> ExtensionLoader.lambda$loadStepsFrom$58((Field)annotatedElement, launchMode, arg_0));
                                continue;
                            }
                            if (fieldClass.isAnnotationPresent(ConfigRoot.class)) {
                                ConfigDefinition confDef;
                                ConfigRoot annotation = fieldClass.getAnnotation(ConfigRoot.class);
                                ConfigPhase phase = annotation.phase();
                                if (phase == ConfigPhase.BUILD_TIME) {
                                    confDef = buildTimeConfig;
                                } else if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                                    confDef = buildTimeRunTimeConfig;
                                } else {
                                    throw ExtensionLoader.reportError(annotatedElement, "Unsupported conditional class configuration build phase " + phase);
                                }
                                setup = setup.andThen(arg_0 -> ExtensionLoader.lambda$loadStepsFrom$59((Field)annotatedElement, confDef, fieldClass, arg_0));
                                continue;
                            }
                            throw ExtensionLoader.reportError(annotatedElement, "Unsupported conditional class field type " + fieldClass);
                        }
                        Object[] args = new Object[paramSuppList.size()];
                        int idx = 0;
                        for (Supplier supplier : paramSuppList) {
                            args[idx++] = supplier.get();
                        }
                        try {
                            bs = (BooleanSupplier)ctor.newInstance(args);
                        }
                        catch (InstantiationException e) {
                            throw ReflectUtil.toError(e);
                        }
                        catch (IllegalAccessException e) {
                            throw ReflectUtil.toError(e);
                        }
                        catch (InvocationTargetException e) {
                            try {
                                throw e.getCause();
                            }
                            catch (Error | RuntimeException throwable) {
                                throw throwable;
                            }
                            catch (Throwable throwable) {
                                throw new IllegalStateException(throwable);
                            }
                        }
                        setup.accept(bs);
                        condCache.put(testClass, bs);
                    }
                    addStep = bl2 ? ExtensionLoader.and(addStep, ExtensionLoader.not(bs)) : ExtensionLoader.and(addStep, bs);
                }
            }
            BooleanSupplier finalAddStep = addStep;
            if (archiveMarkers.length > 0) {
                chainConfig = chainConfig.andThen(bcb -> bcb.addBuildStep(bc -> {
                    for (String marker : archiveMarkers) {
                        bc.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(marker));
                    }
                }).produces(AdditionalApplicationArchiveMarkerBuildItem.class).buildIf(finalAddStep));
            }
            if (capabilities.length > 0) {
                chainConfig = chainConfig.andThen(bcb -> bcb.addBuildStep(bc -> {
                    for (String capability : capabilities) {
                        bc.produce((BuildItem)new CapabilityBuildItem(capability));
                    }
                }).produces(CapabilityBuildItem.class).buildIf(finalAddStep));
            }
            if (isRecorder) {
                assert (recordAnnotation != null);
                ExecutionTime executionTime = recordAnnotation.value();
                boolean optional = recordAnnotation.optional();
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.produces(executionTime == ExecutionTime.STATIC_INIT ? StaticBytecodeRecorderBuildItem.class : MainBytecodeRecorderBuildItem.class, optional ? ProduceFlags.of((ProduceFlag)ProduceFlag.WEAK) : ProduceFlags.NONE));
            }
            Object methodConsumingConfigPhases = consumingConfigPhases.clone();
            if (methodParameters.length == 0) {
                methodParamFns = Collections.emptyList();
            } else {
                methodParamFns = new ArrayList(methodParameters.length);
                for (Parameter parameter : methodParameters) {
                    Class<SimpleBuildItem> buildItemClass;
                    boolean weak = parameter.isAnnotationPresent(Weak.class);
                    boolean overridable = parameter.isAnnotationPresent(Overridable.class);
                    Type parameterType = parameter.getParameterizedType();
                    Class<?> parameterClass = parameter.getType();
                    if (ReflectUtil.rawTypeExtends(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = parameterClass.asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> bc.consume(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isListOf(parameterType, MultiBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(MultiBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> bc.consumeMulti(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isConsumerOf(parameterType, BuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                        methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                        methodParamFns.add((bc, bri) -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                        continue;
                    }
                    if (ReflectUtil.isBuildProducerOf(parameterType, BuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(BuildItem.class);
                        methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(buildItemClass)));
                        methodParamFns.add((bc, bri) -> arg_0 -> ((BuildContext)bc).produce(arg_0));
                        continue;
                    }
                    if (ReflectUtil.isOptionalOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                        methodParamFns.add((bc, bri) -> Optional.ofNullable(bc.consume(buildItemClass)));
                        continue;
                    }
                    if (ReflectUtil.isSupplierOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(parameterType, 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass));
                        methodParamFns.add((bc, bri) -> () -> bc.consume(buildItemClass));
                        continue;
                    }
                    if (ReflectUtil.isSupplierOfOptionalOf(parameterType, SimpleBuildItem.class)) {
                        buildItemClass = ReflectUtil.rawTypeOfParameter(ReflectUtil.rawTypeOfParameter(parameterType, 0), 0).asSubclass(SimpleBuildItem.class);
                        methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(buildItemClass, ConsumeFlags.of((ConsumeFlag)ConsumeFlag.OPTIONAL)));
                        methodParamFns.add((bc, bri) -> () -> Optional.ofNullable(bc.consume(buildItemClass)));
                        continue;
                    }
                    if (ReflectUtil.rawTypeOf(parameterType) == Executor.class) {
                        methodParamFns.add((bc, bri) -> bc.getExecutor());
                        continue;
                    }
                    if (parameterClass.isAnnotationPresent(ConfigRoot.class)) {
                        ConfigRoot annotation = parameterClass.getAnnotation(ConfigRoot.class);
                        ConfigPhase phase = annotation.phase();
                        ((AbstractCollection)methodConsumingConfigPhases).add(phase);
                        if (phase == ConfigPhase.BUILD_TIME) {
                            methodParamFns.add((bc, bri) -> {
                                BuildTimeConfigurationBuildItem configurationBuildItem = (BuildTimeConfigurationBuildItem)bc.consume(BuildTimeConfigurationBuildItem.class);
                                return configurationBuildItem.getConfigDefinition().getRealizedInstance(parameterClass);
                            });
                            continue;
                        }
                        if (phase == ConfigPhase.BUILD_AND_RUN_TIME_FIXED) {
                            methodParamFns.add((bc, bri) -> {
                                BuildTimeRunTimeFixedConfigurationBuildItem configurationBuildItem = (BuildTimeRunTimeFixedConfigurationBuildItem)bc.consume(BuildTimeRunTimeFixedConfigurationBuildItem.class);
                                return configurationBuildItem.getConfigDefinition().getRealizedInstance(parameterClass);
                            });
                            continue;
                        }
                        if (phase == ConfigPhase.RUN_TIME) {
                            methodParamFns.add((bc, bri) -> {
                                RunTimeConfigurationBuildItem configurationBuildItem = (RunTimeConfigurationBuildItem)bc.consume(RunTimeConfigurationBuildItem.class);
                                return configurationBuildItem.getConfigDefinition().getRealizedInstance(parameterClass);
                            });
                            continue;
                        }
                        throw ExtensionLoader.reportError(parameterClass, "Unknown value for ConfigPhase");
                    }
                    if (ExtensionLoader.isRecorder(parameter.getType())) {
                        if (!isRecorder) {
                            throw ExtensionLoader.reportError(parameter, "Cannot pass recorders to method which is not annotated with " + Record.class);
                        }
                        methodParamFns.add((bc, bri) -> {
                            assert (bri != null);
                            return bri.getRecordingProxy(parameterClass);
                        });
                        continue;
                    }
                    if (parameter.getType() == RecorderContext.class || parameter.getType() == BytecodeRecorderImpl.class) {
                        if (!isRecorder) {
                            throw ExtensionLoader.reportError(parameter, "Cannot pass recorder context to method which is not annotated with " + Record.class);
                        }
                        methodParamFns.add((bc, bri) -> bri);
                        continue;
                    }
                    throw ExtensionLoader.reportError(parameter, "Unsupported method parameter " + parameterType);
                }
            }
            Type type = method.getGenericReturnType();
            boolean weak = method.isAnnotationPresent(Weak.class);
            boolean overridable = method.isAnnotationPresent(Overridable.class);
            if (ReflectUtil.rawTypeIs(type, Void.TYPE)) {
                resultConsumer = Functions.discardingBiConsumer();
            } else if (ReflectUtil.rawTypeExtends(type, BuildItem.class)) {
                Class<BuildItem> type2 = method.getReturnType().asSubclass(BuildItem.class);
                methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type2, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type2, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type2, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type2)));
                resultConsumer = (bc, o) -> {
                    if (o != null) {
                        bc.produce((BuildItem)o);
                    }
                };
            } else if (ReflectUtil.isOptionalOf(type, BuildItem.class)) {
                Class<BuildItem> type3 = ReflectUtil.rawTypeOfParameter(type, 0).asSubclass(BuildItem.class);
                methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type3, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type3, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type3, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type3)));
                resultConsumer = (bc, o) -> ((Optional)o).ifPresent(arg_0 -> ((BuildContext)bc).produce(arg_0));
            } else if (ReflectUtil.isListOf(type, MultiBuildItem.class)) {
                Class<MultiBuildItem> type4 = ReflectUtil.rawTypeOfParameter(type, 0).asSubclass(MultiBuildItem.class);
                methodStepConfig = overridable ? (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type4, ProduceFlag.OVERRIDABLE, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type4, ProduceFlag.OVERRIDABLE))) : (weak ? methodStepConfig.andThen(bsb -> bsb.produces(type4, ProduceFlag.WEAK)) : methodStepConfig.andThen(bsb -> bsb.produces(type4)));
                resultConsumer = (bc, o) -> {
                    if (o != null) {
                        bc.produce((List)o);
                    }
                };
            } else {
                throw ExtensionLoader.reportError(method, "Unsupported method return type " + type);
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.RUN_TIME)) {
                if (isRecorder && recordAnnotation.value() == ExecutionTime.STATIC_INIT) {
                    throw ExtensionLoader.reportError(method, "Bytecode recorder is static but an injected config object is declared as run time");
                }
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(RunTimeConfigurationBuildItem.class));
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BUILD_AND_RUN_TIME_FIXED)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(BuildTimeRunTimeFixedConfigurationBuildItem.class));
            }
            if (((AbstractCollection)methodConsumingConfigPhases).contains(ConfigPhase.BUILD_TIME)) {
                methodStepConfig = methodStepConfig.andThen(bsb -> bsb.consumes(BuildTimeConfigurationBuildItem.class));
            }
            if ((consumes = (Consume[])method.getAnnotationsByType(Consume.class)).length > 0) {
                stepConfig = stepConfig.andThen(bsb -> {
                    for (Consume consume : consumes) {
                        bsb.afterProduce(consume.value());
                    }
                });
            }
            if ((produces = (Produce[])method.getAnnotationsByType(Produce.class)).length > 0) {
                stepConfig = stepConfig.andThen(bsb -> {
                    for (Produce produce : produces) {
                        bsb.beforeConsume(produce.value());
                    }
                });
            }
            Consumer<BuildStepBuilder> finalStepConfig = stepConfig.andThen(methodStepConfig).andThen(buildStepBuilder -> buildStepBuilder.buildIf(finalAddStep));
            BiConsumer<BuildContext, Object> finalStepInstanceSetup = stepInstanceSetup;
            String name = clazz.getName() + "#" + method.getName();
            chainConfig = chainConfig.andThen(bcb -> finalStepConfig.accept(bcb.addBuildStep(new io.quarkus.builder.BuildStep(){

                public void execute(BuildContext bc) {
                    Object result;
                    Object instance;
                    Object[] ctorArgs = new Object[ctorParamFns.size()];
                    for (int i = 0; i < ctorArgs.length; ++i) {
                        ctorArgs[i] = ((Function)ctorParamFns.get(i)).apply(bc);
                    }
                    try {
                        instance = constructor.newInstance(ctorArgs);
                    }
                    catch (InstantiationException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (InvocationTargetException e) {
                        try {
                            throw e.getCause();
                        }
                        catch (Error | RuntimeException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException(t);
                        }
                    }
                    finalStepInstanceSetup.accept(bc, instance);
                    Object[] methodArgs = new Object[methodParamFns.size()];
                    BytecodeRecorderImpl bri = isRecorder ? new BytecodeRecorderImpl(recordAnnotation.value() == ExecutionTime.STATIC_INIT, clazz.getSimpleName(), method.getName()) : null;
                    for (int i = 0; i < methodArgs.length; ++i) {
                        methodArgs[i] = ((BiFunction)methodParamFns.get(i)).apply(bc, bri);
                    }
                    try {
                        result = method.invoke(instance, methodArgs);
                    }
                    catch (IllegalAccessException e) {
                        throw ReflectUtil.toError(e);
                    }
                    catch (InvocationTargetException e) {
                        try {
                            throw e.getCause();
                        }
                        catch (Error | RuntimeException e2) {
                            throw e2;
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException(t);
                        }
                    }
                    resultConsumer.accept(bc, result);
                    if (isRecorder) {
                        if (recordAnnotation.value() == ExecutionTime.STATIC_INIT) {
                            bc.produce((BuildItem)new StaticBytecodeRecorderBuildItem(bri));
                        } else {
                            bc.produce((BuildItem)new MainBytecodeRecorderBuildItem(bri));
                        }
                    }
                }

                public String toString() {
                    return name;
                }
            })));
        }
        return chainConfig;
    }

    private static BooleanSupplier and(BooleanSupplier a, BooleanSupplier b) {
        return () -> a.getAsBoolean() && b.getAsBoolean();
    }

    private static BooleanSupplier not(BooleanSupplier x) {
        return () -> !x.getAsBoolean();
    }

    private static IllegalArgumentException reportError(AnnotatedElement e, String msg) {
        if (e instanceof Member) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Member)((Object)e)).getDeclaringClass());
        }
        if (e instanceof Parameter) {
            return new IllegalArgumentException(msg + " at " + e + " of " + ((Parameter)e).getDeclaringExecutable() + " of " + ((Parameter)e).getDeclaringExecutable().getDeclaringClass());
        }
        return new IllegalArgumentException(msg + " at " + e);
    }

    private static /* synthetic */ void lambda$loadStepsFrom$59(Field field, ConfigDefinition confDef, Class fieldClass, BooleanSupplier o) {
        ReflectUtil.setFieldVal(field, o, confDef.getRealizedInstance(fieldClass));
    }

    private static /* synthetic */ void lambda$loadStepsFrom$58(Field field, LaunchMode launchMode, BooleanSupplier o) {
        ReflectUtil.setFieldVal(field, o, launchMode);
    }
}

