/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.GroupConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.steps.ConfigurationSetup;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Field;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.Assert;

public class LongConfigType
extends LeafConfigType {
    private static final MethodDescriptor LONG_VALUE_METHOD = MethodDescriptor.ofMethod(Long.class, (String)"longValue", Long.TYPE, (Class[])new Class[0]);
    final String defaultValue;
    private final Class<? extends Converter<Long>> converterClass;

    public LongConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, String defaultValue, String javadocKey, String configKey, Class<? extends Converter<Long>> converterClass) {
        super(containingName, container, consumeSegment, javadocKey, configKey);
        Assert.checkNotEmptyParam((String)"defaultValue", (String)defaultValue);
        this.defaultValue = defaultValue;
        this.converterClass = converterClass;
    }

    @Override
    public void acceptConfigurationValue(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            name.previous();
        }
        container.acceptConfigurationValueIntoLeaf(this, name, cache, config);
    }

    @Override
    public void generateAcceptConfigurationValue(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        GroupConfigType container = this.getContainer(GroupConfigType.class);
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        container.generateAcceptConfigurationValueIntoLeaf(body, this, name, cache, config);
    }

    @Override
    public void acceptConfigurationValueIntoGroup(Object enclosing, Field field, NameIterator name, SmallRyeConfig config) {
        try {
            Long value = (Long)ConfigUtils.getValue((SmallRyeConfig)config, (String)name.toString(), Long.class, this.converterClass);
            field.setLong(enclosing, value != null ? value : 0L);
        }
        catch (IllegalAccessException e) {
            throw LongConfigType.toError(e);
        }
    }

    @Override
    public void generateAcceptConfigurationValueIntoGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle name, ResultHandle config) {
        AssignableResultHandle result = body.createVariable(Long.TYPE);
        ResultHandle longValue = body.checkCast(body.invokeStaticMethod(CU_GET_VALUE, new ResultHandle[]{config, body.invokeVirtualMethod(OBJ_TO_STRING_METHOD, name, new ResultHandle[0]), body.loadClass(Long.class), this.loadConverterClass(body)}), Long.class);
        BranchResult ifNull = body.ifNull(longValue);
        BytecodeCreator isNull = ifNull.trueBranch();
        isNull.assign(result, isNull.load(0L));
        BytecodeCreator isNotNull = ifNull.falseBranch();
        isNotNull.assign(result, isNotNull.invokeVirtualMethod(LONG_VALUE_METHOD, longValue, new ResultHandle[0]));
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, result});
    }

    @Override
    public String getDefaultValueString() {
        return this.defaultValue;
    }

    @Override
    public Class<?> getItemClass() {
        return Long.TYPE;
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            Long value = (Long)ConfigUtils.convert((SmallRyeConfig)config, (String)ExpandingConfigSource.expandValue((String)this.defaultValue, (ExpandingConfigSource.Cache)cache), Long.class, this.converterClass);
            field.setLong(enclosing, value != null ? value : 0L);
        }
        catch (IllegalAccessException e) {
            throw LongConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, body.invokeVirtualMethod(LONG_VALUE_METHOD, this.getConvertedDefault(body, cache, config), new ResultHandle[0])});
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        return body.invokeVirtualMethod(LONG_VALUE_METHOD, this.getConvertedDefault(body, cache, smallRyeConfig), new ResultHandle[0]);
    }

    private ResultHandle getConvertedDefault(BytecodeCreator body, ResultHandle cache, ResultHandle config) {
        return body.invokeStaticMethod(CU_CONVERT, new ResultHandle[]{config, cache == null ? body.load(this.defaultValue) : body.invokeStaticMethod(ConfigurationSetup.ECS_EXPAND_VALUE, new ResultHandle[]{body.load(this.defaultValue), cache}), body.loadClass(Long.class), this.loadConverterClass(body)});
    }

    public Class<? extends Converter<Long>> getConverterClass() {
        return this.converterClass;
    }
}

