/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.PackageTypeBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageTypeVerificationBuildStep {
    @BuildStep
    List<PackageTypeBuildItem> builtins() {
        return Arrays.asList(new PackageTypeBuildItem("native"), new PackageTypeBuildItem("thin-jar"), new PackageTypeBuildItem("uber-jar"));
    }

    @BuildStep
    void verify(List<PackageTypeBuildItem> items, PackageConfig config) {
        Set registered = items.stream().map(PackageTypeBuildItem::getType).collect(Collectors.toSet());
        for (String i : config.types) {
            if (registered.contains(i)) continue;
            throw new IllegalStateException("Unknown packaging type " + i + " known types are " + registered);
        }
    }
}

