/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.proxy;

import io.quarkus.deployment.proxy.InjectIntoClassloaderClassOutput;
import io.quarkus.deployment.proxy.ProxyConfiguration;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProxyFactory<T> {
    private final String proxyName;
    private final ClassLoader classLoader;
    private final String superClassName;
    private final List<Method> methods;
    private final ClassCreator.Builder classBuilder;
    private boolean classDefined = false;
    private final Object lock = new Object();

    public ProxyFactory(ProxyConfiguration<T> configuration) {
        Objects.requireNonNull(configuration.getAnchorClass(), "anchorClass must be set");
        Objects.requireNonNull(configuration.getProxyNameSuffix(), "proxyNameSuffix must be set");
        this.proxyName = configuration.getProxyName();
        Class superClass = configuration.getSuperClass() != null ? configuration.getSuperClass() : Object.class;
        this.superClassName = superClass.getName();
        if (!this.hasNoArgsConstructor(superClass)) {
            throw new IllegalArgumentException("A proxy cannot be created for class " + this.superClassName + " because it does contain a no-arg constructor");
        }
        if (Modifier.isFinal(superClass.getModifiers())) {
            throw new IllegalArgumentException("A proxy cannot be created for class " + this.superClassName + " because it is a final class");
        }
        if (!Modifier.isPublic(superClass.getModifiers())) {
            throw new IllegalArgumentException("A proxy cannot be created for class " + this.superClassName + " because the it is not public");
        }
        Objects.requireNonNull(configuration.getClassLoader(), "classLoader must be set");
        this.classLoader = configuration.getClassLoader();
        this.methods = new ArrayList<Method>(superClass.getMethods().length);
        this.addMethodsOfClass(superClass);
        for (Class<?> additionalInterface : configuration.getAdditionalInterfaces()) {
            this.addMethodsOfClass(additionalInterface);
        }
        this.classBuilder = ClassCreator.builder().classOutput((ClassOutput)new InjectIntoClassloaderClassOutput(configuration.getClassLoader())).className(this.proxyName).superClass(this.superClassName);
        if (!configuration.getAdditionalInterfaces().isEmpty()) {
            this.classBuilder.interfaces(configuration.getAdditionalInterfaces().toArray(new Class[0]));
        }
    }

    private boolean hasNoArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    private void addMethodsOfClass(Class<?> clazz) {
        for (Method methodInfo : clazz.getMethods()) {
            if (Modifier.isStatic(methodInfo.getModifiers()) || Modifier.isFinal(methodInfo.getModifiers()) || methodInfo.getName().equals("<init>")) continue;
            this.methods.add(methodInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends T> defineClass() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.classDefined) {
                this.doDefineClass();
                this.classDefined = true;
            }
        }
        return this.loadClass();
    }

    private void doDefineClass() {
        try (ClassCreator cc = this.classBuilder.build();){
            FieldDescriptor invocationHandlerField = ((FieldCreator)cc.getFieldCreator("invocationHandler", InvocationHandler.class).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator ctor = cc.getMethodCreator(MethodDescriptor.ofConstructor((String)this.proxyName, (String[])new String[0]));){
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)this.superClassName, (String[])new String[0]), ctor.getThis(), new ResultHandle[0]);
                ctor.writeInstanceField(invocationHandlerField, ctor.getThis(), ctor.loadNull());
                ctor.returnValue(null);
            }
            ctor = cc.getMethodCreator(MethodDescriptor.ofConstructor((String)this.proxyName, (String[])new String[]{InvocationHandler.class.getName()}));
            var5_7 = null;
            try {
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)this.superClassName, (String[])new String[0]), ctor.getThis(), new ResultHandle[0]);
                ctor.writeInstanceField(invocationHandlerField, ctor.getThis(), ctor.getMethodParam(0));
                ctor.returnValue(null);
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (ctor != null) {
                    if (var5_7 != null) {
                        try {
                            ctor.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        ctor.close();
                    }
                }
            }
            for (Method methodInfo : this.methods) {
                MethodCreator mc = (MethodCreator)cc.getMethodCreator(this.toMethodDescriptor(methodInfo)).setModifiers(1);
                Throwable throwable = null;
                try {
                    ResultHandle getDeclaredMethodParamsArray = mc.newArray(Class.class, mc.load(methodInfo.getParameterCount()));
                    for (int i = 0; i < methodInfo.getParameterCount(); ++i) {
                        ResultHandle paramClass = mc.loadClass(methodInfo.getParameters()[i].getType());
                        mc.writeArrayValue(getDeclaredMethodParamsArray, i, paramClass);
                    }
                    ResultHandle method = mc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), mc.loadClass(methodInfo.getDeclaringClass()), new ResultHandle[]{mc.load(methodInfo.getName()), getDeclaredMethodParamsArray});
                    ResultHandle invokeParamsArray = mc.newArray(Object.class, mc.load(methodInfo.getParameterCount()));
                    for (int i = 0; i < methodInfo.getParameterCount(); ++i) {
                        mc.writeArrayValue(invokeParamsArray, i, mc.getMethodParam(i));
                    }
                    ResultHandle result = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(InvocationHandler.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Method.class, Object[].class}), mc.readInstanceField(invocationHandlerField, mc.getThis()), new ResultHandle[]{mc.getThis(), method, invokeParamsArray});
                    if (Void.TYPE.equals(methodInfo.getReturnType())) {
                        mc.returnValue(null);
                        continue;
                    }
                    mc.returnValue(result);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (mc == null) continue;
                    if (throwable != null) {
                        try {
                            mc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    mc.close();
                }
            }
        }
    }

    private MethodDescriptor toMethodDescriptor(Method methodInfo) {
        ArrayList<String> parameterTypesStr = new ArrayList<String>();
        for (Parameter parameter : methodInfo.getParameters()) {
            parameterTypesStr.add(parameter.getType().getName());
        }
        return MethodDescriptor.ofMethod((Object)this.proxyName, (String)methodInfo.getName(), methodInfo.getReturnType(), (Object[])parameterTypesStr.toArray(new Object[0]));
    }

    public T newInstance(InvocationHandler handler) throws IllegalAccessException, InstantiationException {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.defineClass().getConstructor(InvocationHandler.class).newInstance(handler);
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private Class<? extends T> loadClass() {
        try {
            return this.classLoader.loadClass(this.proxyName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

