/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class DeploymentClassLoaderBuildStep {
    @BuildStep
    DeploymentClassLoaderBuildItem classloader(ApplicationArchivesBuildItem archivesBuildItem) {
        return new DeploymentClassLoaderBuildItem(new DeploymentClassLoader(archivesBuildItem, Thread.currentThread().getContextClassLoader()));
    }

    static class DeploymentClassLoader
    extends ClassLoader {
        private final ApplicationArchivesBuildItem archivesBuildItem;

        DeploymentClassLoader(ApplicationArchivesBuildItem archivesBuildItem, ClassLoader parent) {
            super(parent);
            this.archivesBuildItem = archivesBuildItem;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            ApplicationArchive applicationArchive = this.archivesBuildItem.containingArchive(name);
            if (applicationArchive == null) return super.loadClass(name, resolve);
            try (InputStream res = Files.newInputStream(applicationArchive.getChildPath(name.replace(".", "/") + ".class"), new OpenOption[0]);){
                byte[] data = FileUtil.readFileContents(res);
                Class<?> clazz = this.defineClass(name, data, 0, data.length);
                return clazz;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return super.loadClass(name, resolve);
        }
    }
}

