/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class ClassScanResult {
    final Set<Path> changedClasses = new HashSet<Path>();
    final Set<Path> deletedClasses = new HashSet<Path>();
    final Set<Path> addedClasses = new HashSet<Path>();
    final Set<String> changedClassNames = new HashSet<String>();
    final Set<String> deletedClassNames = new HashSet<String>();
    final Set<String> addedClassNames = new HashSet<String>();

    public boolean isChanged() {
        return !this.changedClasses.isEmpty() || !this.deletedClasses.isEmpty() || !this.addedClasses.isEmpty();
    }

    public void addDeletedClass(Path moduleClassesPath, Path classFilePath) {
        this.deletedClasses.add(classFilePath);
        this.deletedClassNames.add(this.toName(moduleClassesPath, classFilePath));
    }

    public void addChangedClass(Path moduleClassesPath, Path classFilePath) {
        this.changedClasses.add(classFilePath);
        this.changedClassNames.add(this.toName(moduleClassesPath, classFilePath));
    }

    public void addAddedClass(Path moduleClassesPath, Path classFilePath) {
        this.addedClasses.add(classFilePath);
        this.addedClassNames.add(this.toName(moduleClassesPath, classFilePath));
    }

    private String toName(Path moduleClassesPath, Path classFilePath) {
        String cf = moduleClassesPath.relativize(classFilePath).toString().replace(moduleClassesPath.getFileSystem().getSeparator(), ".");
        return cf.substring(0, cf.length() - ".class".length());
    }
}

