/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.EnableAllSecurityServicesBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.JavaLibraryPathAdditionalPathBuildItem;
import io.quarkus.deployment.builditem.JniBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllCharsetsBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllTimeZonesBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.SslTrustStoreSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.runtime.ssl.SslContextConfigurationRecorder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;

class NativeImageConfigBuildStep {
    private static final Logger log = Logger.getLogger(NativeImageConfigBuildStep.class);
    private static final String LIB_SUN_EC = "libsunec.so";

    NativeImageConfigBuildStep() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SslContextConfigurationRecorder sslContextConfigurationRecorder, List<NativeImageConfigBuildItem> nativeImageConfigBuildItems, SslNativeConfigBuildItem sslNativeConfig, List<JniBuildItem> jniBuildItems, List<NativeImageEnableAllCharsetsBuildItem> nativeImageEnableAllCharsetsBuildItems, List<NativeImageEnableAllTimeZonesBuildItem> nativeImageEnableAllTimeZonesBuildItems, List<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, List<EnableAllSecurityServicesBuildItem> enableAllSecurityServicesBuildItems, BuildProducer<NativeImageProxyDefinitionBuildItem> proxy, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInit, BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReinit, BuildProducer<NativeImageSystemPropertyBuildItem> nativeImage, BuildProducer<SystemPropertyBuildItem> systemProperty, BuildProducer<JavaLibraryPathAdditionalPathBuildItem> javaLibraryPathAdditionalPath, BuildProducer<SslTrustStoreSystemPropertyBuildItem> sslTrustStoreSystemProperty) {
        for (NativeImageConfigBuildItem nativeImageConfigBuildItem : nativeImageConfigBuildItems) {
            for (String string : nativeImageConfigBuildItem.getRuntimeInitializedClasses()) {
                runtimeInit.produce(new RuntimeInitializedClassBuildItem(string));
            }
            for (String string : nativeImageConfigBuildItem.getRuntimeReinitializedClasses()) {
                runtimeReinit.produce(new RuntimeReinitializedClassBuildItem(string));
            }
            for (Map.Entry entry : nativeImageConfigBuildItem.getNativeImageSystemProperties().entrySet()) {
                nativeImage.produce(new NativeImageSystemPropertyBuildItem((String)entry.getKey(), (String)entry.getValue()));
            }
            for (String string : nativeImageConfigBuildItem.getResourceBundles()) {
                resourceBundle.produce(new NativeImageResourceBundleBuildItem(string));
            }
            for (List list : nativeImageConfigBuildItem.getProxyDefinitions()) {
                proxy.produce(new NativeImageProxyDefinitionBuildItem(list));
            }
        }
        Boolean sslNativeEnabled = this.isSslNativeEnabled(sslNativeConfig, extensionSslNativeSupport);
        sslContextConfigurationRecorder.setSslNativeEnabled(!sslNativeConfig.isExplicitlyDisabled());
        if (sslNativeEnabled.booleanValue()) {
            String graalVmHome = System.getenv("GRAALVM_HOME");
            if (graalVmHome != null) {
                Path graalVmLibDirectory = Paths.get(graalVmHome, "jre", "lib");
                Path path = graalVmLibDirectory.resolve("amd64");
                Path linuxPath = path.resolve(LIB_SUN_EC);
                javaLibraryPathAdditionalPath.produce(new JavaLibraryPathAdditionalPathBuildItem("."));
                if (Files.exists(linuxPath, new LinkOption[0])) {
                    javaLibraryPathAdditionalPath.produce(new JavaLibraryPathAdditionalPathBuildItem(path.toString()));
                } else {
                    javaLibraryPathAdditionalPath.produce(new JavaLibraryPathAdditionalPathBuildItem(graalVmLibDirectory.toString()));
                }
                sslTrustStoreSystemProperty.produce(new SslTrustStoreSystemPropertyBuildItem(graalVmLibDirectory.resolve(Paths.get("security", "cacerts")).toString()));
            } else if (ImageInfo.inImageBuildtimeCode()) {
                log.warn((Object)"SSL is enabled but the GRAALVM_HOME environment variable is not set. The java.library.path property has not been set and will need to be set manually.");
            }
        }
        nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.ssl.native", sslNativeEnabled.toString()));
        boolean requireJni = false;
        if (!enableAllSecurityServicesBuildItems.isEmpty()) {
            requireJni = true;
            nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.native.enable-all-security-services", "true"));
        }
        if (!jniBuildItems.isEmpty() || requireJni) {
            for (JniBuildItem jniBuildItem : jniBuildItems) {
                if (jniBuildItem.getLibraryPaths() == null || jniBuildItem.getLibraryPaths().isEmpty()) continue;
                for (String path : jniBuildItem.getLibraryPaths()) {
                    javaLibraryPathAdditionalPath.produce(new JavaLibraryPathAdditionalPathBuildItem(path));
                }
            }
            nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.jni.enable", "true"));
        }
        if (!nativeImageEnableAllCharsetsBuildItems.isEmpty()) {
            nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.native.enable-all-charsets", "true"));
        }
        if (!nativeImageEnableAllTimeZonesBuildItems.isEmpty()) {
            nativeImage.produce(new NativeImageSystemPropertyBuildItem("quarkus.native.enable-all-timezones", "true"));
        }
    }

    private Boolean isSslNativeEnabled(SslNativeConfigBuildItem sslNativeConfig, List<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        if (sslNativeConfig.isEnabled()) {
            return Boolean.TRUE;
        }
        if (!sslNativeConfig.isExplicitlyDisabled() && !extensionSslNativeSupport.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("Native SSL support enabled due to extensions [%s] requiring it", (Object)extensionSslNativeSupport.stream().map(s -> s.getExtension()).collect(Collectors.joining(", ")));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

