/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.changeagent.ClassChangeAgent;
import io.quarkus.deployment.dev.AlwaysFalsePredicate;
import io.quarkus.deployment.dev.ClassComparisonUtil;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.deployment.dev.IsolatedRemoteDevModeMain;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.filewatch.FileChangeCallback;
import io.quarkus.deployment.dev.filewatch.FileChangeEvent;
import io.quarkus.deployment.dev.filewatch.WatchServiceFileSystemWatcher;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestRunner;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.dev.testing.TestScanningLock;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.instrument.ClassDefinition;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext,
Closeable {
    public static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("linux");
    private static final Logger log = Logger.getLogger(RuntimeUpdatesProcessor.class);
    private static final String CLASS_EXTENSION = ".class";
    public static volatile RuntimeUpdatesProcessor INSTANCE;
    private final Path applicationRoot;
    private final DevModeContext context;
    private final QuarkusCompiler compiler;
    private final DevModeType devModeType;
    volatile Throwable compileProblem;
    private volatile Predicate<ClassInfo> disableInstrumentationForClassPredicate = new AlwaysFalsePredicate<ClassInfo>();
    private volatile Predicate<Index> disableInstrumentationForIndexPredicate = new AlwaysFalsePredicate<Index>();
    private static volatile boolean instrumentationLogPrinted;
    private final TimestampSet main = new TimestampSet();
    private final TimestampSet test = new TimestampSet();
    final Map<Path, Long> sourceFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Set<String>>> noRestartChangesConsumers = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    private final List<HotReplacementSetup> hotReplacementSetup = new ArrayList<HotReplacementSetup>();
    private final BiConsumer<Set<String>, ClassScanResult> restartCallback;
    private final BiConsumer<DevModeContext.ModuleInfo, String> copyResourceNotification;
    private final BiFunction<String, byte[], byte[]> classTransformers;
    private final ReentrantLock scanLock = new ReentrantLock();
    private static volatile IndexView lastStartIndex;
    private final Map<DevModeContext.CompilationUnit, Set<Path>> correspondingResources = new ConcurrentHashMap<DevModeContext.CompilationUnit, Set<Path>>();
    private final TestSupport testSupport;
    private volatile boolean firstTestScanComplete;
    private volatile Boolean instrumentationEnabled;
    private volatile boolean liveReloadEnabled = true;
    private WatchServiceFileSystemWatcher testClassChangeWatcher;
    private Timer testClassChangeTimer;

    public RuntimeUpdatesProcessor(Path applicationRoot, DevModeContext context, QuarkusCompiler compiler, DevModeType devModeType, BiConsumer<Set<String>, ClassScanResult> restartCallback, BiConsumer<DevModeContext.ModuleInfo, String> copyResourceNotification, BiFunction<String, byte[], byte[]> classTransformers, TestSupport testSupport) {
        this.applicationRoot = applicationRoot;
        this.context = context;
        this.compiler = compiler;
        this.devModeType = devModeType;
        this.restartCallback = restartCallback;
        this.copyResourceNotification = copyResourceNotification;
        this.classTransformers = classTransformers;
        this.testSupport = testSupport;
        if (testSupport != null) {
            testSupport.addListener(new TestListener(){

                @Override
                public void testsEnabled() {
                    if (!RuntimeUpdatesProcessor.this.firstTestScanComplete) {
                        RuntimeUpdatesProcessor.this.checkForChangedTestClasses(true);
                        RuntimeUpdatesProcessor.this.firstTestScanComplete = true;
                    }
                    RuntimeUpdatesProcessor.this.startTestScanningTimer();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void testsDisabled() {
                    RuntimeUpdatesProcessor runtimeUpdatesProcessor = RuntimeUpdatesProcessor.this;
                    synchronized (runtimeUpdatesProcessor) {
                        if (RuntimeUpdatesProcessor.this.testClassChangeWatcher != null) {
                            try {
                                RuntimeUpdatesProcessor.this.testClassChangeWatcher.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            RuntimeUpdatesProcessor.this.testClassChangeWatcher = null;
                        }
                        if (RuntimeUpdatesProcessor.this.testClassChangeTimer != null) {
                            RuntimeUpdatesProcessor.this.testClassChangeTimer.cancel();
                            RuntimeUpdatesProcessor.this.testClassChangeTimer = null;
                        }
                    }
                }
            });
        }
    }

    public TestSupport getTestSupport() {
        return this.testSupport;
    }

    public Path getClassesDir() {
        Iterator<DevModeContext.ModuleInfo> iterator = this.context.getAllModules().iterator();
        if (iterator.hasNext()) {
            DevModeContext.ModuleInfo i = iterator.next();
            return Paths.get(i.getMain().getClassesPath(), new String[0]);
        }
        return null;
    }

    public List<Path> getSourcesDir() {
        return this.context.getAllModules().stream().flatMap(m -> m.getMain().getSourcePaths().toList().stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTestScanningTimer() {
        RuntimeUpdatesProcessor runtimeUpdatesProcessor = this;
        synchronized (runtimeUpdatesProcessor) {
            if (this.testClassChangeWatcher == null && this.testClassChangeTimer == null) {
                if (IS_LINUX) {
                    this.testClassChangeWatcher = new WatchServiceFileSystemWatcher("Quarkus Test Watcher", true);
                    FileChangeCallback callback = new FileChangeCallback(){

                        @Override
                        public void handleChanges(Collection<FileChangeEvent> changes) {
                            try {
                                if (RuntimeUpdatesProcessor.this.context.isTest()) {
                                    Thread.sleep(500L);
                                }
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            RuntimeUpdatesProcessor.this.periodicTestCompile();
                        }
                    };
                    for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                        for (Path path : module.getMain().getSourcePaths()) {
                            this.testClassChangeWatcher.watchPath(path.toFile(), callback);
                        }
                        for (Path path : module.getMain().getResourcePaths()) {
                            this.testClassChangeWatcher.watchPath(path.toFile(), callback);
                        }
                    }
                    for (Path path : this.context.getApplicationRoot().getTest().get().getSourcePaths()) {
                        this.testClassChangeWatcher.watchPath(path.toFile(), callback);
                    }
                    for (Path path : this.context.getApplicationRoot().getTest().get().getResourcePaths()) {
                        this.testClassChangeWatcher.watchPath(path.toFile(), callback);
                    }
                    this.periodicTestCompile();
                } else {
                    this.testClassChangeTimer = new Timer("Test Compile Timer", true);
                    this.testClassChangeTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            RuntimeUpdatesProcessor.this.periodicTestCompile();
                        }
                    }, 1L, 1000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicTestCompile() {
        this.scanLock.lock();
        TestScanningLock.lockForTests();
        try {
            ClassScanResult changedTestClassResult = this.compileTestClasses();
            ClassScanResult changedApp = this.checkForChangedClasses(this.compiler, DevModeContext.ModuleInfo::getMain, false, this.test);
            HashSet<String> filesChanges = new HashSet<String>(this.checkForFileChange(s -> s.getTest().get(), this.test));
            filesChanges.addAll(this.checkForFileChange(DevModeContext.ModuleInfo::getMain, this.test));
            boolean configFileRestartNeeded = filesChanges.stream().map(this.test.watchedFilePaths::get).anyMatch(Boolean.TRUE::equals);
            ClassScanResult merged = ClassScanResult.merge(changedTestClassResult, changedApp);
            if (configFileRestartNeeded) {
                if (this.compileProblem != null) {
                    this.testSupport.getTestRunner().testCompileFailed(this.compileProblem);
                } else {
                    this.testSupport.getTestRunner().runTests(null);
                }
            } else if (merged.isChanged()) {
                if (this.compileProblem != null) {
                    this.testSupport.getTestRunner().testCompileFailed(this.compileProblem);
                } else {
                    this.testSupport.getTestRunner().runTests(merged);
                }
            }
        }
        finally {
            TestScanningLock.unlockForTests();
            this.scanLock.unlock();
        }
    }

    private ClassScanResult compileTestClasses() {
        QuarkusCompiler testCompiler = this.testSupport.getCompiler();
        TestRunner testRunner = this.testSupport.getTestRunner();
        ClassScanResult changedTestClassResult = new ClassScanResult();
        try {
            changedTestClassResult = this.checkForChangedClasses(testCompiler, m -> m.getTest().orElse(DevModeContext.EMPTY_COMPILATION_UNIT), false, this.test);
            if (this.compileProblem != null) {
                testRunner.testCompileFailed(this.compileProblem);
                this.compileProblem = null;
            } else if (changedTestClassResult.isChanged()) {
                testRunner.testCompileSucceeded();
            }
        }
        catch (Throwable e) {
            testRunner.testCompileFailed(e);
        }
        return changedTestClassResult;
    }

    public List<Path> getResourcesDir() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo i : this.context.getAllModules()) {
            if (!i.getMain().getResourcePaths().isEmpty()) {
                for (Path path : i.getMain().getResourcePaths()) {
                    ret.add(path);
                }
                continue;
            }
            if (i.getMain().getResourcesOutputPath() == null) continue;
            ret.add(Paths.get(i.getMain().getResourcesOutputPath(), new String[0]));
        }
        Collections.reverse(ret);
        return ret;
    }

    public Throwable getDeploymentProblem() {
        return this.compileProblem != null ? this.compileProblem : IsolatedDevModeMain.deploymentProblem;
    }

    public void setRemoteProblem(Throwable throwable) {
        this.compileProblem = throwable;
    }

    public void updateFile(String file, byte[] data) {
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        try {
            Path resolve = this.applicationRoot.resolve(file);
            if (!Files.exists(resolve.getParent(), new LinkOption[0])) {
                Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
            }
            Files.write(resolve, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isTest() {
        return this.context.isTest();
    }

    public DevModeType getDevModeType() {
        return this.devModeType;
    }

    public boolean doScan(boolean userInitiated) throws IOException {
        return this.doScan(userInitiated, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doScan(boolean userInitiated, boolean force) throws IOException {
        if (!this.liveReloadEnabled && !force) {
            return false;
        }
        this.scanLock.lock();
        try {
            boolean restartNeeded;
            if (this.testSupport != null) {
                this.testSupport.pause();
            }
            long startNanoseconds = System.nanoTime();
            for (Runnable step : this.preScanSteps) {
                try {
                    step.run();
                }
                catch (Throwable t) {
                    log.error((Object)"Pre Scan step failed", t);
                }
            }
            ClassScanResult changedClassResults = this.checkForChangedClasses(this.compiler, DevModeContext.ModuleInfo::getMain, false, this.main);
            Set<String> filesChanged = this.checkForFileChange(DevModeContext.ModuleInfo::getMain, this.main);
            boolean configFileRestartNeeded = filesChanged.stream().map(this.main.watchedFilePaths::get).anyMatch(Boolean.TRUE::equals);
            boolean instrumentationChange = false;
            ArrayList<Path> changedFilesForRestart = new ArrayList<Path>();
            if (configFileRestartNeeded) {
                changedFilesForRestart.addAll(filesChanged.stream().filter(fn -> Boolean.TRUE.equals(this.main.watchedFilePaths.get(fn))).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
            }
            changedFilesForRestart.addAll(changedClassResults.getChangedClasses());
            changedFilesForRestart.addAll(changedClassResults.getAddedClasses());
            changedFilesForRestart.addAll(changedClassResults.getDeletedClasses());
            if (ClassChangeAgent.getInstrumentation() != null && lastStartIndex != null && !configFileRestartNeeded && this.devModeType != DevModeType.REMOTE_LOCAL_SIDE && changedClassResults.deletedClasses.isEmpty() && changedClassResults.addedClasses.isEmpty() && !changedClassResults.changedClasses.isEmpty()) {
                try {
                    boolean ok;
                    Indexer indexer = new Indexer();
                    ClassDefinition[] defs = new ClassDefinition[changedClassResults.changedClasses.size()];
                    int index = 0;
                    for (Path i : changedClassResults.changedClasses) {
                        byte[] bytes = Files.readAllBytes(i);
                        String name = indexer.index((InputStream)new ByteArrayInputStream(bytes)).name().toString();
                        defs[index++] = new ClassDefinition(Thread.currentThread().getContextClassLoader().loadClass(name), this.classTransformers.apply(name, bytes));
                    }
                    Index current = indexer.complete();
                    boolean bl = ok = this.instrumentationEnabled() && !this.disableInstrumentationForIndexPredicate.test(current);
                    if (ok) {
                        for (ClassInfo clazz : current.getKnownClasses()) {
                            ClassInfo old;
                            if (ClassComparisonUtil.isSameStructure(clazz, old = lastStartIndex.getClassByName(clazz.name())) && !this.disableInstrumentationForClassPredicate.test(clazz)) continue;
                            ok = false;
                            break;
                        }
                    }
                    if (ok) {
                        log.info((Object)"Application restart not required, replacing classes via instrumentation");
                        ClassChangeAgent.getInstrumentation().redefineClasses(defs);
                        instrumentationChange = true;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Failed to replace classes via instrumentation", (Throwable)e);
                    instrumentationChange = false;
                }
            }
            boolean bl = restartNeeded = !instrumentationChange && (changedClassResults.isChanged() || IsolatedDevModeMain.deploymentProblem != null && userInitiated || configFileRestartNeeded);
            if (restartNeeded) {
                String changeString = changedFilesForRestart.stream().map(Path::getFileName).map(Object::toString).collect(Collectors.joining(", ")) + ".";
                log.infof("Restarting quarkus due to changes in " + changeString, new Object[0]);
                this.restartCallback.accept(filesChanged, changedClassResults);
                long timeNanoSeconds = System.nanoTime() - startNanoseconds;
                log.infof("Live reload total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)timeNanoSeconds));
                if (TimeUnit.SECONDS.convert(timeNanoSeconds, TimeUnit.NANOSECONDS) >= 4L && !this.instrumentationEnabled() && !instrumentationLogPrinted) {
                    instrumentationLogPrinted = true;
                    log.info((Object)"Live reload took more than 4 seconds, you may want to enable instrumentation based reload (quarkus.live-reload.instrumentation=true). This allows small changes to take effect without restarting Quarkus.");
                }
                boolean bl2 = true;
                return bl2;
            }
            if (!filesChanged.isEmpty()) {
                for (Consumer<Set<String>> consumer : this.noRestartChangesConsumers) {
                    try {
                        consumer.accept(filesChanged);
                    }
                    catch (Throwable t) {
                        log.error((Object)"Changed files consumer failed", t);
                    }
                }
                log.infof("Files changed but restart not needed - notified extensions in: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            } else if (instrumentationChange) {
                log.infof("Live reload performed via instrumentation, no restart needed, total time: %ss ", (Object)Timing.convertToBigDecimalSeconds((long)(System.nanoTime() - startNanoseconds)));
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.scanLock.unlock();
            if (this.testSupport != null) {
                this.testSupport.resume();
            }
        }
    }

    public boolean instrumentationEnabled() {
        if (this.instrumentationEnabled != null) {
            return this.instrumentationEnabled;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            boolean bl = ConfigProvider.getConfig().getOptionalValue("quarkus.live-reload.instrumentation", Boolean.TYPE).orElse(true);
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    public void consumeNoRestartChanges(Consumer<Set<String>> consumer) {
        this.noRestartChangesConsumers.add(consumer);
    }

    public Set<String> syncState(Map<String, String> fileHashes) {
        if (this.getDevModeType() != DevModeType.REMOTE_SERVER_SIDE) {
            throw new RuntimeException("Can only sync state on the server side of remote dev mode");
        }
        HashSet<String> ret = new HashSet<String>();
        try {
            HashMap<String, String> ourHashes = new HashMap<String, String>(IsolatedRemoteDevModeMain.createHashes(this.applicationRoot));
            for (Map.Entry<String, String> entry : fileHashes.entrySet()) {
                String ours = (String)ourHashes.remove(entry.getKey());
                if (Objects.equals(ours, entry.getValue())) continue;
                ret.add(entry.getKey());
            }
            for (Map.Entry<String, String> entry : ourHashes.entrySet()) {
                String file = entry.getKey();
                if (file.endsWith("META-INF/MANIFEST.MF") || file.contains("META-INF/maven") || !file.contains("/")) continue;
                log.info((Object)("Deleting removed file " + file));
                Files.deleteIfExists(this.applicationRoot.resolve(file));
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    ClassScanResult checkForChangedClasses(boolean firstScan) {
        ClassScanResult classScanResult = this.checkForChangedClasses(this.compiler, DevModeContext.ModuleInfo::getMain, firstScan, this.main);
        if (firstScan) {
            this.test.merge(this.main);
        }
        return classScanResult;
    }

    ClassScanResult checkForChangedTestClasses(boolean firstScan) {
        if (!this.testSupport.isStarted()) {
            return new ClassScanResult();
        }
        ClassScanResult ret = this.checkForChangedClasses(this.testSupport.getCompiler(), s -> s.getTest().orElse(DevModeContext.EMPTY_COMPILATION_UNIT), firstScan, this.test);
        if (firstScan) {
            this.startTestScanningTimer();
        }
        return ret;
    }

    ClassScanResult checkForChangedClasses(QuarkusCompiler compiler, Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, boolean firstScan, TimestampSet timestampSet) {
        ClassScanResult classScanResult = new ClassScanResult();
        boolean ignoreFirstScanChanges = firstScan;
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            ArrayList<Path> moduleChangedSourceFilePaths = new ArrayList<Path>();
            for (Path sourcePath : cuf.apply(module).getSourcePaths()) {
                boolean timestampsChanged;
                Object i22;
                Set changedSourceFiles;
                Path start = sourcePath;
                if (!Files.exists(start, new LinkOption[0])) continue;
                try (Stream<Path> sourcesStream = Files.walk(start, new FileVisitOption[0]);){
                    changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent() && this.sourceFileWasRecentModified((Path)p, ignoreFirstScanChanges, firstScan)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (changedSourceFiles.isEmpty()) continue;
                classScanResult.compilationHappened = true;
                for (Object i22 : changedSourceFiles) {
                    if (((File)i22).length() != 0L) continue;
                    try {
                        Thread.sleep(200L);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                HashMap<File, Long> compileTimestamps = new HashMap<File, Long>();
                i22 = changedSourceFiles.iterator();
                while (i22.hasNext()) {
                    File i3 = (File)i22.next();
                    compileTimestamps.put(i3, i3.lastModified());
                }
                do {
                    try {
                        Set changedPaths = changedSourceFiles.stream().map(File::toPath).collect(Collectors.toSet());
                        moduleChangedSourceFilePaths.addAll(changedPaths);
                        compiler.compile(sourcePath.toString(), changedSourceFiles.stream().collect(Collectors.groupingBy(this::getFileExtension, Collectors.toSet())));
                        this.compileProblem = null;
                    }
                    catch (Exception e) {
                        this.compileProblem = e;
                        return new ClassScanResult();
                    }
                    timestampsChanged = false;
                    for (Map.Entry entry : compileTimestamps.entrySet()) {
                        if (((File)entry.getKey()).lastModified() == ((Long)entry.getValue()).longValue()) continue;
                        timestampsChanged = true;
                        entry.setValue(((File)entry.getKey()).lastModified());
                    }
                } while (timestampsChanged);
                for (Map.Entry entry : compileTimestamps.entrySet()) {
                    this.sourceFileTimestamps.put(((File)entry.getKey()).toPath(), (Long)entry.getValue());
                }
            }
            this.checkForClassFilesChangesInModule(module, moduleChangedSourceFilePaths, ignoreFirstScanChanges, classScanResult, cuf, timestampSet);
        }
        return classScanResult;
    }

    public Throwable getCompileProblem() {
        return this.compileProblem;
    }

    private void checkForClassFilesChangesInModule(DevModeContext.ModuleInfo module, List<Path> moduleChangedSourceFiles, boolean isInitialRun, ClassScanResult classScanResult, Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, TimestampSet timestampSet) {
        if (cuf.apply(module).getClassesPath() == null) {
            return;
        }
        try {
            for (String folder : cuf.apply(module).getClassesPath().split(File.pathSeparator)) {
                Path moduleClassesPath = Paths.get(folder, new String[0]);
                if (!Files.exists(moduleClassesPath, new LinkOption[0])) continue;
                try (Stream<Path> classesStream = Files.walk(moduleClassesPath, new FileVisitOption[0]);){
                    Set classFilePaths = ((Stream)classesStream.parallel()).filter(path -> path.toString().endsWith(CLASS_EXTENSION)).collect(Collectors.toSet());
                    for (Path classFilePath : classFilePaths) {
                        Path sourceFilePath = this.retrieveSourceFilePathForClassFile(classFilePath, moduleChangedSourceFiles, module, cuf, timestampSet);
                        if (sourceFilePath != null) {
                            if (!sourceFilePath.toFile().exists()) {
                                this.cleanUpClassFile(classFilePath, timestampSet);
                                this.sourceFileTimestamps.remove(sourceFilePath);
                                classScanResult.addDeletedClass(moduleClassesPath, classFilePath);
                                continue;
                            }
                            timestampSet.classFilePathToSourceFilePath.put(classFilePath, sourceFilePath);
                            if (this.classFileWasAdded(classFilePath, isInitialRun, timestampSet)) {
                                classScanResult.addAddedClass(moduleClassesPath, classFilePath);
                                continue;
                            }
                            if (this.classFileWasRecentModified(classFilePath, isInitialRun, timestampSet)) {
                                classScanResult.addChangedClass(moduleClassesPath, classFilePath);
                                continue;
                            }
                            if (!moduleChangedSourceFiles.contains(sourceFilePath)) continue;
                            this.cleanUpClassFile(classFilePath, timestampSet);
                            classScanResult.addDeletedClass(moduleClassesPath, classFilePath);
                            continue;
                        }
                        if (this.classFileWasAdded(classFilePath, isInitialRun, timestampSet)) {
                            classScanResult.addAddedClass(moduleClassesPath, classFilePath);
                            continue;
                        }
                        if (!this.classFileWasRecentModified(classFilePath, isInitialRun, timestampSet)) continue;
                        classScanResult.addChangedClass(moduleClassesPath, classFilePath);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path retrieveSourceFilePathForClassFile(Path classFilePath, List<Path> moduleChangedSourceFiles, DevModeContext.ModuleInfo module, Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, TimestampSet timestampSet) {
        Path sourceFilePath = timestampSet.classFilePathToSourceFilePath.get(classFilePath);
        if (sourceFilePath == null || moduleChangedSourceFiles.contains(sourceFilePath)) {
            sourceFilePath = this.compiler.findSourcePath(classFilePath, cuf.apply(module).getSourcePaths(), cuf.apply(module).getClassesPath());
        }
        return sourceFilePath;
    }

    private void cleanUpClassFile(Path classFilePath, TimestampSet timestampSet) throws IOException {
        Files.deleteIfExists(classFilePath);
        timestampSet.classFileChangeTimeStamps.remove(classFilePath);
        timestampSet.classFilePathToSourceFilePath.remove(classFilePath);
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    Set<String> checkForFileChange() {
        return this.checkForFileChange(DevModeContext.ModuleInfo::getMain, this.main);
    }

    Set<String> checkForFileChange(Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, TimestampSet timestampSet) {
        HashSet<String> ret = new HashSet<String>();
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            Set moduleResources = this.correspondingResources.computeIfAbsent(cuf.apply(module), m -> Collections.newSetFromMap(new ConcurrentHashMap()));
            boolean doCopy = true;
            PathsCollection rootPaths = cuf.apply(module).getResourcePaths();
            String outputPath = cuf.apply(module).getResourcesOutputPath();
            if (rootPaths.isEmpty()) {
                String rootPath = cuf.apply(module).getClassesPath();
                if (rootPath != null) {
                    rootPaths = PathsCollection.of((Path[])new Path[]{Paths.get(rootPath, new String[0])});
                }
                outputPath = rootPath;
                doCopy = false;
            }
            if (rootPaths.isEmpty() || outputPath == null) continue;
            List roots = rootPaths.toList().stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Files::isReadable).collect(Collectors.toList());
            if (doCopy) {
                HashSet seen = new HashSet(moduleResources);
                try {
                    for (Path root : roots) {
                        Path outputDir = Paths.get(outputPath, new String[0]);
                        Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);
                        try {
                            walk.forEach(path -> {
                                block9: {
                                    try {
                                        Path relative = root.relativize((Path)path);
                                        Path target = outputDir.resolve(relative);
                                        seen.remove(target);
                                        if (timestampSet.watchedFileTimestamps.containsKey(path)) break block9;
                                        moduleResources.add(target);
                                        if (Files.exists(target, new LinkOption[0]) && Files.getLastModifiedTime(target, new LinkOption[0]).toMillis() >= Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()) break block9;
                                        if (Files.isDirectory(path, new LinkOption[0])) {
                                            Files.createDirectories(target, new FileAttribute[0]);
                                            break block9;
                                        }
                                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                        ret.add(relative.toString());
                                        byte[] data = Files.readAllBytes(path);
                                        try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                            out.write(data);
                                        }
                                        if (this.copyResourceNotification != null) {
                                            this.copyResourceNotification.accept(module, relative.toString());
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error((Object)"Failed to copy resources", (Throwable)e);
                                    }
                                }
                            });
                        }
                        finally {
                            if (walk == null) continue;
                            walk.close();
                        }
                    }
                    for (Path i : seen) {
                        moduleResources.remove(i);
                        if (Files.isDirectory(i, new LinkOption[0])) continue;
                        Files.delete(i);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Failed to copy resources", (Throwable)e);
                }
            }
            for (Path root : roots) {
                Path outputDir = Paths.get(outputPath, new String[0]);
                for (String path2 : timestampSet.watchedFilePaths.keySet()) {
                    Path file = root.resolve(path2);
                    if (file.toFile().exists()) {
                        try {
                            long value = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                            Long existing = timestampSet.watchedFileTimestamps.get(file);
                            if (existing == null || value <= existing) continue;
                            ret.add(path2);
                            if (Files.size(file) == 0L) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            value = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                            log.infof("File change detected: %s", (Object)file);
                            if (doCopy && !Files.isDirectory(file, new LinkOption[0])) {
                                Path target = outputDir.resolve(path2);
                                byte[] data = Files.readAllBytes(file);
                                try (FileOutputStream out = new FileOutputStream(target.toFile());){
                                    out.write(data);
                                }
                            }
                            timestampSet.watchedFileTimestamps.put(file, value);
                            continue;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    timestampSet.watchedFileTimestamps.put(file, 0L);
                    Path target = outputDir.resolve(path2);
                    try {
                        FileUtil.deleteDirectory(target);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }
        return ret;
    }

    private boolean sourceFileWasRecentModified(Path sourcePath, boolean ignoreFirstScanChanges, boolean firstScan) {
        return this.checkIfFileModified(sourcePath, this.sourceFileTimestamps, ignoreFirstScanChanges, firstScan);
    }

    private boolean classFileWasRecentModified(Path classFilePath, boolean ignoreFirstScanChanges, TimestampSet timestampSet) {
        return this.checkIfFileModified(classFilePath, timestampSet.classFileChangeTimeStamps, ignoreFirstScanChanges, true);
    }

    private boolean classFileWasAdded(Path classFilePath, boolean ignoreFirstScanChanges, TimestampSet timestampSet) {
        Long lastRecordedChange = timestampSet.classFileChangeTimeStamps.get(classFilePath);
        if (lastRecordedChange == null) {
            try {
                timestampSet.classFileChangeTimeStamps.put(classFilePath, Files.getLastModifiedTime(classFilePath, new LinkOption[0]).toMillis());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return lastRecordedChange == null && !ignoreFirstScanChanges;
    }

    private boolean checkIfFileModified(Path path, Map<Path, Long> pathModificationTimes, boolean ignoreFirstScanChanges, boolean updateTimestamp) {
        try {
            long lastModificationTime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            Long lastRecordedChange = pathModificationTimes.get(path);
            if (lastRecordedChange == null) {
                if (updateTimestamp) {
                    pathModificationTimes.put(path, lastModificationTime);
                }
                return !ignoreFirstScanChanges;
            }
            if (lastRecordedChange != lastModificationTime) {
                if (updateTimestamp) {
                    pathModificationTimes.put(path, lastModificationTime);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public RuntimeUpdatesProcessor setDisableInstrumentationForClassPredicate(Predicate<ClassInfo> disableInstrumentationForClassPredicate) {
        this.disableInstrumentationForClassPredicate = disableInstrumentationForClassPredicate;
        return this;
    }

    public RuntimeUpdatesProcessor setDisableInstrumentationForIndexPredicate(Predicate<Index> disableInstrumentationForIndexPredicate) {
        this.disableInstrumentationForIndexPredicate = disableInstrumentationForIndexPredicate;
        return this;
    }

    public RuntimeUpdatesProcessor setWatchedFilePaths(Map<String, Boolean> watchedFilePaths, boolean isTest) {
        if (isTest) {
            this.setWatchedFilePathsInternal(watchedFilePaths, this.test, s -> Arrays.asList(s.getTest().get(), s.getMain()));
        } else {
            this.main.watchedFileTimestamps.clear();
            this.setWatchedFilePathsInternal(watchedFilePaths, this.main, s -> Collections.singletonList(s.getMain()));
        }
        return this;
    }

    private RuntimeUpdatesProcessor setWatchedFilePathsInternal(Map<String, Boolean> watchedFilePaths, TimestampSet timestamps, Function<DevModeContext.ModuleInfo, List<DevModeContext.CompilationUnit>> cuf) {
        timestamps.watchedFilePaths = watchedFilePaths;
        HashMap<String, Boolean> extraWatchedFilePaths = new HashMap<String, Boolean>();
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            List<DevModeContext.CompilationUnit> compilationUnits = cuf.apply(module);
            for (DevModeContext.CompilationUnit unit : compilationUnits) {
                PathsCollection rootPaths = unit.getResourcePaths();
                if (rootPaths.isEmpty()) {
                    String rootPath = unit.getClassesPath();
                    if (rootPath == null) continue;
                    rootPaths = PathsCollection.of((Path[])new Path[]{Paths.get(rootPath, new String[0])});
                }
                for (Path root : rootPaths) {
                    for (String path : watchedFilePaths.keySet()) {
                        Path config = root.resolve(path);
                        if (config.toFile().exists()) {
                            try {
                                FileTime lastModifiedTime = Files.getLastModifiedTime(config, new LinkOption[0]);
                                timestamps.watchedFileTimestamps.put(config, lastModifiedTime.toMillis());
                                continue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                        timestamps.watchedFileTimestamps.put(config, 0L);
                        Map<Path, Long> extraWatchedFileTimestamps = this.expandGlobPattern(root, config);
                        timestamps.watchedFileTimestamps.putAll(extraWatchedFileTimestamps);
                        for (Path extraPath : extraWatchedFileTimestamps.keySet()) {
                            extraWatchedFilePaths.put(root.relativize(extraPath).toString(), timestamps.watchedFilePaths.get(path));
                        }
                        timestamps.watchedFileTimestamps.putAll(extraWatchedFileTimestamps);
                    }
                }
            }
        }
        timestamps.watchedFilePaths.putAll(extraWatchedFilePaths);
        return this;
    }

    public void addHotReplacementSetup(HotReplacementSetup service) {
        this.hotReplacementSetup.add(service);
    }

    public void startupFailed() {
        for (HotReplacementSetup i : this.hotReplacementSetup) {
            i.handleFailedInitialStart();
        }
        lastStartIndex = null;
    }

    public static void setLastStartIndex(IndexView lastStartIndex) {
        RuntimeUpdatesProcessor.lastStartIndex = lastStartIndex;
    }

    @Override
    public void close() throws IOException {
        this.compiler.close();
        if (this.testClassChangeWatcher != null) {
            this.testClassChangeWatcher.close();
        }
        if (this.testClassChangeTimer != null) {
            this.testClassChangeTimer.cancel();
        }
    }

    private Map<Path, Long> expandGlobPattern(Path root, Path configFile) {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + configFile.toString());
        final HashMap<Path, Long> files = new HashMap<Path, Long>();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (pathMatcher.matches(file)) {
                        files.put(file, attrs.lastModifiedTime().toMillis());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return files;
    }

    public boolean toggleInstrumentation() {
        this.instrumentationEnabled = !this.instrumentationEnabled();
        if (this.instrumentationEnabled.booleanValue()) {
            log.info((Object)"Instrumentation based restart enabled");
        } else {
            log.info((Object)"Instrumentation based restart disabled");
        }
        return this.instrumentationEnabled;
    }

    public boolean toggleLiveReloadEnabled() {
        boolean bl = this.liveReloadEnabled = !this.liveReloadEnabled;
        if (this.liveReloadEnabled) {
            log.info((Object)"Live reload enabled");
        } else {
            log.info((Object)"Live reload disabled");
        }
        return this.liveReloadEnabled;
    }

    public boolean isLiveReloadEnabled() {
        return this.liveReloadEnabled;
    }

    static {
        instrumentationLogPrinted = false;
    }

    static class TimestampSet {
        final Map<Path, Long> watchedFileTimestamps = new ConcurrentHashMap<Path, Long>();
        final Map<Path, Long> classFileChangeTimeStamps = new ConcurrentHashMap<Path, Long>();
        final Map<Path, Path> classFilePathToSourceFilePath = new ConcurrentHashMap<Path, Path>();
        private volatile Map<String, Boolean> watchedFilePaths = Collections.emptyMap();

        TimestampSet() {
        }

        public void merge(TimestampSet other) {
            this.watchedFileTimestamps.putAll(other.watchedFileTimestamps);
            this.classFileChangeTimeStamps.putAll(other.classFileChangeTimeStamps);
            this.classFilePathToSourceFilePath.putAll(other.classFilePathToSourceFilePath);
            HashMap<String, Boolean> newVal = new HashMap<String, Boolean>(this.watchedFilePaths);
            newVal.putAll(other.watchedFilePaths);
            this.watchedFilePaths = newVal;
        }
    }
}

