/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.JunitTestRunner;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestClassUsages;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.dev.testing.TestType;
import io.quarkus.dev.testing.TestWatchedFiles;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class TestRunner {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    private static final AtomicLong COUNTER = new AtomicLong();
    private final TestSupport testSupport;
    private final DevModeContext devModeContext;
    private final CuratedApplication testApplication;
    private boolean testsRunning = false;
    private boolean testsQueued = false;
    private ClassScanResult queuedChanges = null;
    private boolean queuedFailureRun;
    private Throwable compileProblem;
    private final TestClassUsages testClassUsages = new TestClassUsages();
    private boolean paused;
    private volatile boolean disabled = true;
    private volatile boolean firstRun = true;
    private JunitTestRunner runner;
    String appPropertiesIncludeTags;
    String appPropertiesExcludeTags;
    String appPropertiesIncludePattern;
    String appPropertiesExcludePattern;
    String appPropertiesTestType;

    public TestRunner(TestSupport testSupport, DevModeContext devModeContext, CuratedApplication testApplication) {
        this.testSupport = testSupport;
        this.devModeContext = devModeContext;
        this.testApplication = testApplication;
    }

    public void runTests() {
        this.runTests(null);
    }

    public synchronized long getRunningTestRunId() {
        if (this.testsRunning) {
            return COUNTER.get();
        }
        return -1L;
    }

    public void runFailedTests() {
        this.runTests(null, true);
    }

    public void runTests(ClassScanResult classScanResult) {
        this.runTests(classScanResult, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(final ClassScanResult classScanResult, final boolean reRunFailures) {
        if (this.compileProblem != null) {
            return;
        }
        if (this.disabled) {
            return;
        }
        if (reRunFailures && this.testSupport.testRunResults == null) {
            return;
        }
        if (reRunFailures && this.testSupport.testRunResults.getCurrentFailing().isEmpty()) {
            log.error((Object)"Not re-running failed tests, as all tests passed");
            return;
        }
        TestRunner testRunner = this;
        synchronized (testRunner) {
            if (this.testsRunning) {
                if (reRunFailures) {
                    log.error((Object)"Not re-running failed tests, as tests are already in progress.");
                    return;
                }
                if (this.testsQueued) {
                    if (this.queuedChanges != null) {
                        this.queuedChanges = ClassScanResult.merge(this.queuedChanges, classScanResult);
                    }
                } else {
                    this.testsQueued = true;
                    this.queuedChanges = classScanResult;
                }
                return;
            }
            this.testsRunning = true;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader((ClassLoader)TestRunner.this.testApplication.getAugmentClassLoader());
                try {
                    try {
                        TestRunner.this.runInternal(classScanResult, reRunFailures);
                    }
                    finally {
                        TestRunner.this.waitTillResumed();
                        boolean run = false;
                        ClassScanResult current = null;
                        TestRunner testRunner = TestRunner.this;
                        synchronized (testRunner) {
                            if (!TestRunner.this.disabled) {
                                if (TestRunner.this.testsQueued) {
                                    TestRunner.this.testsQueued = false;
                                    run = true;
                                }
                                current = TestRunner.this.queuedChanges;
                                TestRunner.this.queuedChanges = null;
                            }
                            TestRunner.this.testsRunning = false;
                        }
                        if (run) {
                            TestRunner.this.runTests(current);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Internal error running tests", t);
                }
            }
        }, "Test runner thread");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void pause() {
        this.paused = true;
        if (this.runner != null) {
            this.runner.pause();
        }
    }

    public synchronized void resume() {
        this.paused = false;
        this.notifyAll();
        if (this.runner != null) {
            this.runner.resume();
        }
    }

    public synchronized void disable() {
        this.disabled = true;
        this.notifyAll();
        if (this.runner != null) {
            this.runner.abort();
        }
    }

    public synchronized void enable() {
        if (!this.disabled) {
            return;
        }
        this.disabled = false;
        if (this.firstRun) {
            this.runTests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal(ClassScanResult classScanResult, boolean reRunFailures) {
        long runId = COUNTER.incrementAndGet();
        TestRunner testRunner = this;
        synchronized (testRunner) {
            if (this.runner != null) {
                throw new IllegalStateException("Tests already in progress");
            }
            if (this.disabled) {
                return;
            }
            this.handleApplicationPropertiesChange();
            JunitTestRunner.Builder builder = new JunitTestRunner.Builder().setClassScanResult(classScanResult).setDevModeContext(this.devModeContext).setRunId(runId).setTestState(this.testSupport.testState).setTestClassUsages(this.testClassUsages).setTestApplication(this.testApplication).setDisplayInConsole(this.testSupport.displayTestOutput).setIncludeTags(this.testSupport.includeTags).setExcludeTags(this.testSupport.excludeTags).setInclude(this.testSupport.include).setExclude(this.testSupport.exclude).setTestType(this.testSupport.testType).setFailingTestsOnly(classScanResult != null && this.testSupport.brokenOnlyMode);
            if (reRunFailures) {
                final HashSet<UniqueId> ids = new HashSet<UniqueId>();
                for (Map.Entry<String, TestClassResult> e : this.testSupport.testRunResults.getCurrentFailing().entrySet()) {
                    for (TestResult test : e.getValue().getFailing()) {
                        ids.add(test.uniqueId);
                    }
                }
                builder.addAdditionalFilter(new PostDiscoveryFilter(){

                    public FilterResult apply(TestDescriptor testDescriptor) {
                        return FilterResult.includedIf((boolean)ids.contains(testDescriptor.getUniqueId()));
                    }
                });
            }
            for (TestListener i : this.testSupport.testListeners) {
                i.testRunStarted(builder::addListener);
            }
            builder.addListener(new TestRunListener(){

                @Override
                public void runComplete(TestRunResults results) {
                    TestRunner.this.testSupport.testRunResults = results;
                }

                @Override
                public void noTests(TestRunResults results) {
                    TestRunner.this.testSupport.testRunResults = results;
                }
            });
            this.runner = builder.build();
            if (this.paused) {
                this.runner.pause();
            }
        }
        this.runner.runTests();
        testRunner = this;
        synchronized (testRunner) {
            this.runner = null;
        }
        Map watched = TestWatchedFiles.retrieveWatchedFilePaths();
        if (watched != null) {
            RuntimeUpdatesProcessor.INSTANCE.setWatchedFilePaths(watched, true);
        }
        if (this.disabled) {
            return;
        }
        if (this.firstRun) {
            this.firstRun = false;
        }
    }

    private void handleApplicationPropertiesChange() {
        for (Path rootPath : this.testApplication.getQuarkusBootstrap().getApplicationRoot()) {
            Path appProps = rootPath.resolve("application.properties");
            if (!Files.exists(appProps, new LinkOption[0])) continue;
            Properties p = new Properties();
            try (InputStream in = Files.newInputStream(appProps, new OpenOption[0]);){
                p.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String includeTags = p.getProperty("quarkus.test.include-tags");
            String excludeTags = p.getProperty("quarkus.test.exclude-tags");
            String includePattern = p.getProperty("quarkus.test.include-pattern");
            String excludePattern = p.getProperty("quarkus.test.exclude-pattern");
            String testType = p.getProperty("quarkus.test.type");
            if (!this.firstRun) {
                if (!Objects.equals(includeTags, this.appPropertiesIncludeTags)) {
                    this.testSupport.includeTags = includeTags == null ? Collections.emptyList() : Arrays.stream(includeTags.split(",")).map(String::trim).collect(Collectors.toList());
                }
                if (!Objects.equals(excludeTags, this.appPropertiesExcludeTags)) {
                    this.testSupport.excludeTags = excludeTags == null ? Collections.emptyList() : Arrays.stream(excludeTags.split(",")).map(String::trim).collect(Collectors.toList());
                }
                if (!Objects.equals(includePattern, this.appPropertiesIncludePattern)) {
                    this.testSupport.include = includePattern == null ? null : Pattern.compile(includePattern);
                }
                if (!Objects.equals(excludePattern, this.appPropertiesExcludePattern)) {
                    this.testSupport.exclude = excludePattern == null ? null : Pattern.compile(excludePattern);
                }
                if (!Objects.equals(testType, this.appPropertiesTestType)) {
                    this.testSupport.testType = testType == null ? TestType.ALL : (TestType)new HyphenateEnumConverter(TestType.class).convert(testType);
                }
            }
            this.appPropertiesIncludeTags = includeTags;
            this.appPropertiesExcludeTags = excludeTags;
            this.appPropertiesIncludePattern = includePattern;
            this.appPropertiesExcludePattern = excludePattern;
            this.appPropertiesTestType = testType;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillResumed() {
        TestRunner testRunner = this;
        synchronized (testRunner) {
            while (this.paused && !this.disabled) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompileFailed(Throwable e) {
        TestRunner testRunner = this;
        synchronized (testRunner) {
            this.compileProblem = e;
        }
        for (TestListener i : this.testSupport.testListeners) {
            i.testCompileFailed(e.getMessage());
        }
    }

    public synchronized void testCompileSucceeded() {
        this.compileProblem = null;
        for (TestListener i : this.testSupport.testListeners) {
            i.testCompileSucceeded();
        }
    }

    public boolean isRunning() {
        return this.testsRunning;
    }
}

