/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CodeGenWatcher;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeListener;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.steps.ClassTransformingBuildStep;
import io.quarkus.dev.appstate.ApplicationStartException;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.DeploymentFailedStartHandler;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.logging.Logger;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class IsolatedDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger(IsolatedDevModeMain.class);
    public static final String APP_ROOT = "app-root";
    private volatile DevModeContext context;
    private final List<HotReplacementSetup> hotReplacementSetups = new ArrayList<HotReplacementSetup>();
    private volatile RunningQuarkusApplication runner;
    final AtomicReference<Throwable> deploymentProblem = new AtomicReference();
    private volatile CuratedApplication curatedApplication;
    private volatile AugmentAction augmentAction;
    private volatile boolean restarting;
    private volatile boolean firstStartCompleted;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private Thread shutdownThread;
    private CodeGenWatcher codeGenWatcher;
    private volatile ConsoleStateManager.ConsoleContext consoleContext;
    private final List<DevModeListener> listeners = new ArrayList<DevModeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void firstStart() {
        block11: {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    this.curatedApplication.getOrCreateBaseRuntimeClassLoader().loadClass(ApplicationLifecycleManager.class.getName()).getMethod("setDefaultExitCodeHandler", Consumer.class).invoke(null, this.getExitCodeHandler());
                    StartupAction start = this.augmentAction.createInitialRuntimeApplication();
                    this.runner = start.runMainClass(this.context.getArgs());
                    RuntimeUpdatesProcessor.INSTANCE.setConfiguredInstrumentationEnabled(this.runner.getConfigValue("quarkus.live-reload.instrumentation", Boolean.class).orElse(false)).setLiveReloadEnabled(this.runner.getConfigValue("quarkus.live-reload.enabled", Boolean.class).orElse(false));
                    this.firstStartCompleted = true;
                    this.notifyListenersAfterStart();
                }
                catch (Throwable t) {
                    Throwable rootCause = t;
                    while (rootCause.getCause() != null) {
                        rootCause = rootCause.getCause();
                    }
                    if (rootCause instanceof BindException) break block11;
                    this.deploymentProblem.set(t);
                    if (!this.context.isAbortOnFailedStart()) {
                        log.info((Object)"Attempting to start live reload endpoint to recover from previous Quarkus startup failure");
                        ApplicationStateNotification.notifyStartupFailed((Throwable)t);
                        if (RuntimeUpdatesProcessor.INSTANCE == null) break block11;
                        Thread.currentThread().setContextClassLoader((ClassLoader)this.curatedApplication.getOrCreateBaseRuntimeClassLoader());
                        try {
                            if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(LoggingSetupRecorder.class.getName());
                                cl.getMethod("handleFailedStart", new Class[0]).invoke(null, new Object[0]);
                            }
                            RuntimeUpdatesProcessor.INSTANCE.startupFailed();
                            if (!(t instanceof ApplicationStartException)) {
                                log.error((Object)"Failed to start quarkus", t);
                            }
                            break block11;
                        }
                        catch (Exception e) {
                            this.close();
                            log.error((Object)"Failed to start quarkus", t);
                            log.error((Object)"Failed to recover after failed start", (Throwable)e);
                            System.exit(1);
                        }
                        break block11;
                    }
                    log.error((Object)"Failed to start quarkus", t);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private Consumer<Integer> getExitCodeHandler() {
        if (this.context.isTest() || this.context.isAbortOnFailedStart()) {
            return TestExitCodeHandler.INSTANCE;
        }
        return new Consumer<Integer>(){

            @Override
            public void accept(Integer integer) {
                if (IsolatedDevModeMain.this.restarting || ApplicationLifecycleManager.isVmShuttingDown()) {
                    return;
                }
                if (IsolatedDevModeMain.this.consoleContext == null) {
                    IsolatedDevModeMain.this.consoleContext = ConsoleStateManager.INSTANCE.createContext("Completed Application");
                }
                InitialConfigurator.DELAYED_HANDLER.addHandler((Handler)new ConsoleHandler(ConsoleHandler.Target.SYSTEM_OUT, (Formatter)new ColorPatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c{3.}] (%t) %s%e%n")));
                IsolatedDevModeMain.this.consoleContext.reset(new ConsoleCommand(' ', "Restarts the application", "to restart", 0, null, () -> {
                    IsolatedDevModeMain.this.consoleContext.reset(new ConsoleCommand[0]);
                    RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
                }));
            }
        };
    }

    public void restartCallback(Set<String> changedResources, ClassScanResult result) {
        this.restartApp(changedResources, new ClassChangeInformation(result.changedClassNames, result.deletedClassNames, result.addedClassNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restartApp(Set<String> changedResources, ClassChangeInformation classChangeInformation) {
        this.restarting = true;
        if (this.consoleContext != null) {
            this.consoleContext.reset(new ConsoleCommand[0]);
        }
        this.stop();
        Timing.restart((ClassLoader)this.curatedApplication.getOrCreateAugmentClassLoader());
        this.deploymentProblem.set(null);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            try {
                StartupAction start = this.augmentAction.reloadExistingApplication(this.firstStartCompleted, changedResources, classChangeInformation);
                this.runner = start.runMainClass(this.context.getArgs());
                if (!this.firstStartCompleted) {
                    this.notifyListenersAfterStart();
                    this.firstStartCompleted = true;
                }
            }
            catch (Throwable t) {
                this.deploymentProblem.set(t);
                Throwable rootCause = t;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (!(rootCause instanceof BindException)) {
                    log.error((Object)"Failed to start quarkus", t);
                    Thread.currentThread().setContextClassLoader((ClassLoader)this.curatedApplication.getOrCreateAugmentClassLoader());
                    LoggingSetupRecorder.handleFailedStart();
                }
            }
        }
        finally {
            this.restarting = false;
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void notifyListenersAfterStart() {
        for (DevModeListener listener : ServiceLoader.load(DevModeListener.class)) {
            this.listeners.add(listener);
        }
        this.listeners.sort(Comparator.comparingInt(DevModeListener::order));
        for (DevModeListener listener : this.listeners) {
            try {
                listener.afterFirstStart(this.runner);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to invoke 'afterFirstStart' of " + listener.getClass()), (Throwable)e);
            }
        }
    }

    private RuntimeUpdatesProcessor setupRuntimeCompilation(DevModeContext context, Path appRoot, DevModeType devModeType) throws Exception {
        if (!context.getAllModules().isEmpty()) {
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            for (CompilationProvider provider : serviceLoader) {
                compilationProviders.add(provider);
                context.getAllModules().forEach(moduleInfo -> moduleInfo.addSourcePaths(provider.handledSourcePaths()));
            }
            QuarkusCompiler compiler = new QuarkusCompiler(this.curatedApplication, compilationProviders, context);
            TestSupport testSupport = null;
            if (devModeType == DevModeType.LOCAL) {
                testSupport = new TestSupport(this.curatedApplication, compilationProviders, context, devModeType);
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(appRoot, context, compiler, devModeType, this::restartCallback, null, new BiFunction<String, byte[], byte[]>(){

                @Override
                public byte[] apply(String s, byte[] bytes) {
                    return ClassTransformingBuildStep.transform(s, bytes);
                }
            }, testSupport, this.deploymentProblem);
            for (HotReplacementSetup hotReplacementSetup : ServiceLoader.load(HotReplacementSetup.class, (ClassLoader)this.curatedApplication.getOrCreateBaseRuntimeClassLoader())) {
                this.hotReplacementSetups.add(hotReplacementSetup);
                hotReplacementSetup.setupHotDeployment((HotReplacementContext)processor);
                processor.addHotReplacementSetup(hotReplacementSetup);
            }
            for (final DeploymentFailedStartHandler deploymentFailedStartHandler : ServiceLoader.load(DeploymentFailedStartHandler.class, (ClassLoader)this.curatedApplication.getOrCreateAugmentClassLoader())) {
                processor.addDeploymentFailedStartHandler(new Runnable(){

                    @Override
                    public void run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)IsolatedDevModeMain.this.curatedApplication.getOrCreateAugmentClassLoader());
                            deploymentFailedStartHandler.handleFailedInitialStart();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                    }
                });
            }
            DevConsoleManager.setQuarkusBootstrap((Object)this.curatedApplication.getQuarkusBootstrap());
            DevConsoleManager.setHotReplacementContext((HotReplacementContext)processor);
            return processor;
        }
        return null;
    }

    public void stop() {
        if (this.runner != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.runner.getClassLoader());
            try {
                try {
                    this.runner.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    QuarkusConfigFactory.setConfig(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        this.restarting = true;
        if (this.codeGenWatcher != null) {
            this.codeGenWatcher.shutdown();
            this.codeGenWatcher = null;
        }
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            try {
                this.listeners.get(i).beforeShutdown();
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Unable to invoke 'beforeShutdown' of " + this.listeners.get(i).getClass()), (Throwable)e);
            }
        }
        this.listeners.clear();
        try {
            this.stop();
            if (RuntimeUpdatesProcessor.INSTANCE != null) return;
            throw new IllegalStateException("Hot deployment of the application is not supported when updating the Quarkus version. The application needs to be stopped and dev mode started up again");
        }
        finally {
            try {
                if (RuntimeUpdatesProcessor.INSTANCE != null) {
                    try {
                        RuntimeUpdatesProcessor.INSTANCE.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close compiler", (Throwable)e);
                    }
                    finally {
                        RuntimeUpdatesProcessor.INSTANCE = null;
                    }
                }
                for (HotReplacementSetup i : this.hotReplacementSetups) {
                    i.close();
                }
                this.hotReplacementSetups.clear();
            }
            finally {
                try {
                    DevConsoleManager.close();
                    this.curatedApplication.close();
                    this.curatedApplication = null;
                    this.augmentAction = null;
                    this.deploymentProblem.set(null);
                }
                finally {
                    if (this.shutdownThread != null) {
                        try {
                            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                        }
                        catch (IllegalStateException illegalStateException) {}
                        this.shutdownThread = null;
                    }
                    this.shutdownLatch.countDown();
                }
            }
        }
    }

    @Override
    public void accept(CuratedApplication o, Map<String, Object> params) {
        System.setProperty("java.nio.channels.DefaultThreadPool.threadFactory", "io.quarkus.dev.io.NioThreadPoolThreadFactory");
        Timing.staticInitStarted((ClassLoader)o.getOrCreateBaseRuntimeClassLoader(), (boolean)false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IsolatedDevModeMain.this.shutdownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "Quarkus Devmode keep alive thread").start();
        try {
            this.curatedApplication = o;
            Object potentialContext = params.get(DevModeContext.class.getName());
            if (potentialContext instanceof DevModeContext) {
                this.context = (DevModeContext)potentialContext;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream oo = new ObjectOutputStream(out);
                oo.writeObject(potentialContext);
                this.context = (DevModeContext)new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())).readObject();
            }
            this.augmentAction = new AugmentActionImpl(this.curatedApplication, List.of(new AddApplicationClassPredicateBuildStep()), List.of());
            this.codeGenWatcher = new CodeGenWatcher(this.curatedApplication, this.context);
            RuntimeUpdatesProcessor.INSTANCE = this.setupRuntimeCompilation(this.context, (Path)params.get(APP_ROOT), (DevModeType)params.get(DevModeType.class.getName()));
            if (RuntimeUpdatesProcessor.INSTANCE != null) {
                RuntimeUpdatesProcessor.INSTANCE.checkForFileChange();
                RuntimeUpdatesProcessor.INSTANCE.checkForChangedClasses(true);
            }
            this.firstStart();
            if ((this.deploymentProblem.get() != null || RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() != null) && this.context.isAbortOnFailedStart()) {
                Throwable throwable = this.deploymentProblem.get() == null ? RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() : this.deploymentProblem.get();
                throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
            }
            this.shutdownThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IsolatedDevModeMain.this.shutdownLatch.countDown();
                    Class<DevModeMain> clazz = DevModeMain.class;
                    synchronized (DevModeMain.class) {
                        if (IsolatedDevModeMain.this.runner != null) {
                            try {
                                IsolatedDevModeMain.this.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, "Quarkus Shutdown Thread");
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        catch (Exception e) {
            RuntimeException toThrow = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            try {
                this.close();
            }
            catch (IllegalStateException x) {
                toThrow.addSuppressed(x);
            }
            throw toThrow;
        }
    }

    private static class TestExitCodeHandler
    implements Consumer<Integer> {
        private static final TestExitCodeHandler INSTANCE = new TestExitCodeHandler();

        private TestExitCodeHandler() {
        }

        @Override
        public void accept(Integer exitCode) {
        }
    }

    private static class AddApplicationClassPredicateBuildStep
    implements Consumer<BuildChainBuilder> {
        private AddApplicationClassPredicateBuildStep() {
        }

        @Override
        public void accept(BuildChainBuilder buildChainBuilder) {
            buildChainBuilder.addBuildStep(new BuildStep(){

                public void execute(BuildContext context) {
                    context.produce((BuildItem)new ApplicationClassPredicateBuildItem(new Predicate<String>(){

                        @Override
                        public boolean test(String s) {
                            String resourceName;
                            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                            List res = cl.getElementsWithResource(resourceName = ClassLoaderHelper.fromClassNameToResourceName((String)s), true);
                            return !res.isEmpty();
                        }
                    }));
                }
            }).produces(ApplicationClassPredicateBuildItem.class).build();
        }
    }
}

