/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.runtime.Timing;
import io.quarkus.runtime.shutdown.ShutdownRecorder;
import java.io.Closeable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.common.lock.Locks;

public abstract class Application
implements Closeable {
    public static final String APP_CLASS_NAME = "io.quarkus.runner.ApplicationImpl";
    private static final int ST_INITIAL = 0;
    private static final int ST_STARTING = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_STOPPING = 3;
    private static final int ST_STOPPED = 4;
    private final Lock stateLock = Locks.reentrantLock();
    private final Condition stateCond = this.stateLock.newCondition();
    private int state = 0;
    private static volatile Application currentApplication;

    protected Application() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(String[] args) {
        currentApplication = this;
        Lock stateLock = this.stateLock;
        stateLock.lock();
        try {
            block21: while (true) {
                switch (this.state) {
                    case 0: {
                        break block21;
                    }
                    case 1: {
                        try {
                            this.stateCond.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Application.interruptedOnAwaitStart();
                        }
                    }
                    continue block21;
                    case 2: {
                        return;
                    }
                    default: {
                        throw new IllegalStateException("The application is stopping");
                    }
                }
                break;
            }
            this.state = 1;
        }
        finally {
            stateLock.unlock();
        }
        try {
            this.doStart(args);
        }
        catch (Throwable t) {
            stateLock.lock();
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            try {
                cpr.releaseConfig(cpr.getConfig());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                this.state = 4;
                this.stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
            ApplicationStateNotification.notifyStartupFailed((Throwable)t);
            throw t;
        }
        stateLock.lock();
        try {
            this.state = 2;
            this.stateCond.signalAll();
            ApplicationStateNotification.notifyStartupComplete();
        }
        finally {
            stateLock.unlock();
        }
    }

    protected abstract void doStart(String[] var1);

    @Override
    public final void close() {
        try {
            this.stop();
        }
        finally {
            try {
                ConfigProviderResolver.instance().releaseConfig(ConfigProviderResolver.instance().getConfig(Thread.currentThread().getContextClassLoader()));
            }
            catch (Throwable throwable) {}
        }
    }

    public final void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable afterStopTask) {
        Lock stateLock = this.stateLock;
        stateLock.lock();
        try {
            block27: while (true) {
                switch (this.state) {
                    case 0: {
                        throw new IllegalStateException("The application has not been started");
                    }
                    case 1: {
                        try {
                            this.stateCond.await();
                            continue block27;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Application.interruptedOnAwaitStart();
                        }
                    }
                    case 2: {
                        break block27;
                    }
                    case 3: {
                        try {
                            this.stateCond.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw Application.interruptedOnAwaitStop();
                        }
                    }
                    continue block27;
                    case 4: {
                        return;
                    }
                    default: {
                        throw Assert.impossibleSwitchCase((int)this.state);
                    }
                }
                break;
            }
            this.state = 3;
        }
        finally {
            stateLock.unlock();
        }
        Timing.staticInitStopped();
        try {
            ShutdownRecorder.runShutdown();
            this.doStop();
        }
        finally {
            currentApplication = null;
            if (afterStopTask != null) {
                try {
                    afterStopTask.run();
                }
                catch (Throwable t) {
                    Logger.getLogger(Application.class).error((Object)"Failed to run stop task", t);
                }
            }
            stateLock.lock();
            try {
                this.state = 4;
                Timing.printStopTime(this.getName());
                this.stateCond.signalAll();
                ApplicationStateNotification.notifyApplicationStopped();
            }
            finally {
                stateLock.unlock();
            }
        }
    }

    public static Application currentApplication() {
        return currentApplication;
    }

    protected abstract void doStop();

    public abstract String getName();

    private static IllegalStateException interruptedOnAwaitStart() {
        return new IllegalStateException("Interrupted while waiting for another thread to start the application");
    }

    private static IllegalStateException interruptedOnAwaitStop() {
        return new IllegalStateException("Interrupted while waiting for another thread to stop the application");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void awaitShutdown() {
        Lock stateLock = this.stateLock;
        stateLock.lock();
        block9: while (true) {
            switch (this.state) {
                default: {
                    try {
                        this.stateCond.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Application.interruptedOnAwaitStop();
                    }
                }
                continue block9;
                case 4: {
                    return;
                }
                finally {
                    stateLock.unlock();
                }
            }
            break;
        }
    }

    public boolean isStarted() {
        return this.state == 2;
    }
}

