/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSource;
import io.quarkus.runtime.configuration.DeploymentProfileConfigSource;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.QuarkusPropertiesConfigSourceProvider;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

public final class ConfigUtils {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime) {
        return ConfigUtils.configBuilder(runTime, true);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered) {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        ApplicationPropertiesConfigSource.InFileSystem inFileSystem = new ApplicationPropertiesConfigSource.InFileSystem();
        ApplicationPropertiesConfigSource.InJar inJar = new ApplicationPropertiesConfigSource.InJar();
        ApplicationPropertiesConfigSource.MpConfigInJar mpConfig = new ApplicationPropertiesConfigSource.MpConfigInJar();
        builder.withSources(new ConfigSource[]{inFileSystem, inJar, mpConfig, new DotEnvConfigSource()});
        ExpandingConfigSource.Cache cache = new ExpandingConfigSource.Cache();
        builder.withWrapper(ExpandingConfigSource.wrapper(cache));
        builder.withWrapper(DeploymentProfileConfigSource.wrapper());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (runTime) {
            builder.addDefaultSources();
        } else {
            ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
            sources.addAll((Collection<ConfigSource>)new QuarkusPropertiesConfigSourceProvider("META-INF/microprofile-config.properties", true, classLoader).getConfigSources(classLoader));
            sources.addAll((Collection<ConfigSource>)new QuarkusPropertiesConfigSourceProvider("WEB-INF/classes/META-INF/microprofile-config.properties", true, classLoader).getConfigSources(classLoader));
            sources.add(new EnvConfigSource());
            sources.add(new SysPropConfigSource());
            builder.withSources(sources);
        }
        if (addDiscovered) {
            builder.addDiscoveredSources();
            builder.addDiscoveredConverters();
        }
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(new ConfigSource[]{source});
        }
    }

    public static void addSourceProviders(SmallRyeConfigBuilder builder, Collection<ConfigSourceProvider> providers) {
        for (ConfigSourceProvider provider : providers) {
            ConfigUtils.addSourceProvider(builder, provider);
        }
    }

    static final class SysPropConfigSource
    implements ConfigSource {
        SysPropConfigSource() {
        }

        public Map<String, String> getProperties() {
            TreeMap<String, String> output = new TreeMap<String, String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("quarkus.")) continue;
                output.put(key, entry.getValue().toString());
            }
            return output;
        }

        public String getValue(String propertyName) {
            return System.getProperty(propertyName);
        }

        public String getName() {
            return "System properties";
        }

        public int getOrdinal() {
            return 400;
        }
    }

    static class DotEnvConfigSource
    extends EnvConfigSource {
        private static final long serialVersionUID = -6718168105190376482L;
        private final Map<String, String> values;

        DotEnvConfigSource() {
            this(Paths.get(System.getProperty("user.dir", "."), ".env"));
        }

        DotEnvConfigSource(Path path) {
            HashMap<String, String> values = new HashMap<String, String>();
            try (InputStream is2 = Files.newInputStream(path, new OpenOption[0]);
                 InputStreamReader isr = new InputStreamReader(is2, StandardCharsets.UTF_8);){
                Properties properties = new Properties();
                properties.load(isr);
                for (String name : properties.stringPropertyNames()) {
                    values.put(name, properties.getProperty(name));
                }
            }
            catch (FileNotFoundException | NoSuchFileException is2) {
            }
            catch (IOException e) {
                log.debug((Object)"Failed to load `.env` file", (Throwable)e);
            }
            this.values = values;
        }

        @Override
        public int getOrdinal() {
            return 295;
        }

        @Override
        String getRawValue(String name) {
            return this.values.get(name);
        }

        @Override
        public String getName() {
            return ".env";
        }
    }

    static class EnvConfigSource
    implements ConfigSource,
    Serializable {
        private static final long serialVersionUID = 8786096039970882529L;
        static final Pattern REP_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

        EnvConfigSource() {
        }

        public int getOrdinal() {
            return 300;
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public String getValue(String propertyName) {
            return this.getRawValue(REP_PATTERN.matcher(propertyName.toUpperCase(Locale.ROOT)).replaceAll("_"));
        }

        String getRawValue(String name) {
            return System.getenv(name);
        }

        public String getName() {
            return "System environment";
        }
    }
}

