/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.dev.console.CurrentAppExceptionHighlighter;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.testing.ExceptionReporting;
import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.QuarkusConfigBuilderCustomizer;
import io.quarkus.runtime.console.ConsoleRuntimeConfig;
import io.quarkus.runtime.logging.DiscoveredLogComponents;
import io.quarkus.runtime.logging.InheritableLevel;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogFilterFactory;
import io.quarkus.runtime.logging.LogRuntimeConfig;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextInitializer;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.filters.AllFilter;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.formatters.TextBannerFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SocketHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.wildfly.common.net.HostName;
import org.wildfly.common.os.Process;

@Recorder
public class LoggingSetupRecorder {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(LoggingSetupRecorder.class);
    final RuntimeValue<ConsoleRuntimeConfig> consoleRuntimeConfig;

    public LoggingSetupRecorder(RuntimeValue<ConsoleRuntimeConfig> consoleRuntimeConfig) {
        this.consoleRuntimeConfig = consoleRuntimeConfig;
    }

    public static void handleFailedStart() {
        LoggingSetupRecorder.handleFailedStart(new RuntimeValue<Optional<Supplier<String>>>(Optional.empty()));
    }

    public static void handleFailedStart(RuntimeValue<Optional<Supplier<String>>> banner) {
        final SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        SmallRyeConfig loggingConfig = new SmallRyeConfigBuilder().withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new QuarkusConfigBuilderCustomizer()}).withMapping(LogBuildTimeConfig.class).withMapping(LogRuntimeConfig.class).withMapping(ConsoleRuntimeConfig.class).withSources(new ConfigSource[]{new ConfigSource(){

            public Set<String> getPropertyNames() {
                HashSet<String> properties = new HashSet<String>();
                config.getPropertyNames().forEach(properties::add);
                return properties;
            }

            public String getValue(String propertyName) {
                return config.getRawValue(propertyName);
            }

            public String getName() {
                return "Logging Config";
            }
        }}).build();
        LogRuntimeConfig logRuntimeConfig = (LogRuntimeConfig)loggingConfig.getConfigMapping(LogRuntimeConfig.class);
        LogBuildTimeConfig logBuildTimeConfig = (LogBuildTimeConfig)loggingConfig.getConfigMapping(LogBuildTimeConfig.class);
        ConsoleRuntimeConfig consoleRuntimeConfig = (ConsoleRuntimeConfig)loggingConfig.getConfigMapping(ConsoleRuntimeConfig.class);
        new LoggingSetupRecorder(new RuntimeValue<ConsoleRuntimeConfig>(consoleRuntimeConfig)).initializeLogging(logRuntimeConfig, logBuildTimeConfig, DiscoveredLogComponents.ofEmpty(), Collections.emptyMap(), false, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), banner, LaunchMode.DEVELOPMENT, false);
    }

    public ShutdownListener initializeLogging(LogRuntimeConfig config, LogBuildTimeConfig buildConfig, DiscoveredLogComponents discoveredLogComponents, Map<String, InheritableLevel> categoryDefaultMinLevels, boolean enableWebStream, RuntimeValue<Optional<Handler>> streamingDevUiConsoleHandler, List<RuntimeValue<Optional<Handler>>> additionalHandlers, List<RuntimeValue<Map<String, Handler>>> additionalNamedHandlers, List<RuntimeValue<Optional<Formatter>>> possibleConsoleFormatters, List<RuntimeValue<Optional<Formatter>>> possibleFileFormatters, List<RuntimeValue<Optional<Formatter>>> possibleSyslogFormatters, List<RuntimeValue<Optional<Formatter>>> possibleSocketFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier, LaunchMode launchMode, boolean includeFilters) {
        Map<String, Handler> namedHandlers;
        Handler socketHandler;
        Handler syslogHandler;
        List<LogCleanupFilterElement> filterElements;
        ShutdownNotifier shutdownNotifier = new ShutdownNotifier();
        Map<String, LogRuntimeConfig.CategoryConfig> categories = config.categories();
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        if (config.level().intValue() < buildConfig.minLevel().intValue()) {
            log.warnf("Root log level %s set below minimum logging level %s, promoting it to %s. Set the build time configuration property 'quarkus.log.min-level' to '%s' to avoid this warning", new Object[]{config.level(), buildConfig.minLevel(), buildConfig.minLevel(), config.level()});
            rootLogger.setLevel(buildConfig.minLevel());
        } else {
            rootLogger.setLevel(config.level());
        }
        Object errorManager = new OnlyOnceErrorManager();
        Map<String, LogRuntimeConfig.CleanupFilterConfig> filters = config.filters();
        if (filters.isEmpty()) {
            filterElements = Collections.emptyList();
        } else {
            filterElements = new ArrayList(filters.size());
            filters.forEach(new BiConsumer<String, LogRuntimeConfig.CleanupFilterConfig>(){

                @Override
                public void accept(String loggerName, LogRuntimeConfig.CleanupFilterConfig config) {
                    filterElements.add(new LogCleanupFilterElement(loggerName, config.targetLevel(), config.ifStartsWith()));
                }
            });
        }
        LogCleanupFilter cleanupFiler = new LogCleanupFilter(filterElements, shutdownNotifier);
        for (Handler handler : LogManager.getLogManager().getLogger("").getHandlers()) {
            handler.setFilter(cleanupFiler);
        }
        Map<String, Filter> namedFilters = LoggingSetupRecorder.createNamedFilters(discoveredLogComponents);
        ArrayList<Handler> handlers = new ArrayList<Handler>(3 + additionalHandlers.size() + (config.handlers().isPresent() ? config.handlers().get().size() : 0));
        if (config.console().enable()) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console(), this.consoleRuntimeConfig.getValue(), (ErrorManager)errorManager, cleanupFiler, namedFilters, possibleConsoleFormatters, possibleBannerSupplier, launchMode, includeFilters);
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        if (launchMode.isDevOrTest()) {
            handlers.add((Handler)new ExtHandler(){

                protected void doPublish(ExtLogRecord record) {
                    if (record.getThrown() != null) {
                        ExceptionReporting.notifyException((Throwable)record.getThrown());
                    }
                }

                public void flush() {
                }

                public void close() throws SecurityException {
                }
            });
        }
        if (config.file().enable()) {
            handlers.add(LoggingSetupRecorder.configureFileHandler(config.file(), (ErrorManager)errorManager, cleanupFiler, namedFilters, possibleFileFormatters, includeFilters));
        }
        if (config.syslog().enable() && (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(config.syslog(), (ErrorManager)errorManager, cleanupFiler, namedFilters, possibleSyslogFormatters, includeFilters)) != null) {
            handlers.add(syslogHandler);
        }
        if (config.socket().enable() && (socketHandler = LoggingSetupRecorder.configureSocketHandler(config.socket(), (ErrorManager)errorManager, cleanupFiler, namedFilters, possibleSocketFormatters, includeFilters)) != null) {
            handlers.add(socketHandler);
        }
        if ((launchMode.isDevOrTest() || enableWebStream) && streamingDevUiConsoleHandler != null && streamingDevUiConsoleHandler.getValue().isPresent()) {
            Handler handler = streamingDevUiConsoleHandler.getValue().get();
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements, shutdownNotifier));
            if (possibleBannerSupplier != null && possibleBannerSupplier.getValue().isPresent()) {
                Supplier<String> bannerSupplier = possibleBannerSupplier.getValue().get();
                String header = "\n" + bannerSupplier.get();
                handler.publish(new LogRecord(Level.INFO, header));
            }
            handlers.add(handler);
        }
        Map<String, Handler> map = namedHandlers = this.shouldCreateNamedHandlers(config, additionalNamedHandlers) ? LoggingSetupRecorder.createNamedHandlers(config, this.consoleRuntimeConfig.getValue(), additionalNamedHandlers, possibleConsoleFormatters, possibleFileFormatters, possibleSyslogFormatters, possibleSocketFormatters, (ErrorManager)errorManager, cleanupFiler, namedFilters, launchMode, shutdownNotifier, includeFilters) : Collections.emptyMap();
        if (!categories.isEmpty()) {
            Map<String, Handler> additionalNamedHandlersMap;
            if (additionalNamedHandlers.isEmpty()) {
                additionalNamedHandlersMap = Collections.emptyMap();
            } else {
                additionalNamedHandlersMap = new HashMap();
                for (RuntimeValue<Map<String, Handler>> runtimeValue : additionalNamedHandlers) {
                    runtimeValue.getValue().forEach(new AdditionalNamedHandlersConsumer(additionalNamedHandlersMap, (ErrorManager)errorManager, filterElements, shutdownNotifier));
                }
            }
            namedHandlers.putAll(additionalNamedHandlersMap);
            LoggingSetupRecorder.setUpCategoryLoggers(buildConfig, categoryDefaultMinLevels, categories, logContext, (ErrorManager)errorManager, namedHandlers, true);
        }
        for (RuntimeValue<Optional<Handler>> additionalHandler : additionalHandlers) {
            Optional<Handler> optional = additionalHandler.getValue();
            if (!optional.isPresent()) continue;
            Handler handler = optional.get();
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setFilter(cleanupFiler);
            handlers.add(handler);
        }
        LoggingSetupRecorder.addNamedHandlersToRootHandlers(config.handlers(), namedHandlers, handlers, (ErrorManager)errorManager);
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(LogContextInitializer.NO_HANDLERS));
        return shutdownNotifier;
    }

    private static Map<String, Filter> createNamedFilters(DiscoveredLogComponents discoveredLogComponents) {
        if (discoveredLogComponents.getNameToFilterClass().isEmpty()) {
            return Collections.emptyMap();
        }
        final HashMap<String, Filter> nameToFilter = new HashMap<String, Filter>();
        final LogFilterFactory logFilterFactory = LogFilterFactory.load();
        discoveredLogComponents.getNameToFilterClass().forEach(new BiConsumer<String, String>(){

            @Override
            public void accept(String name, String className) {
                try {
                    nameToFilter.put(name, logFilterFactory.create(className));
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create instance of Logging Filter '" + className + "'", e);
                }
            }
        });
        return nameToFilter;
    }

    public static void initializeBuildTimeLogging(LogRuntimeConfig config, LogBuildTimeConfig buildConfig, ConsoleRuntimeConfig consoleConfig, Map<String, InheritableLevel> categoryDefaultMinLevels, List<LogCleanupFilterElement> additionalLogCleanupFilters, LaunchMode launchMode) {
        ShutdownNotifier dummy = new ShutdownNotifier();
        Map<String, LogRuntimeConfig.CategoryConfig> categories = config.categories();
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        rootLogger.setLevel(config.level());
        Object errorManager = new OnlyOnceErrorManager();
        Map<String, LogRuntimeConfig.CleanupFilterConfig> filters = config.filters();
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size() + additionalLogCleanupFilters.size());
        for (Map.Entry<String, LogRuntimeConfig.CleanupFilterConfig> entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement(entry.getKey(), entry.getValue().targetLevel(), entry.getValue().ifStartsWith()));
        }
        for (LogCleanupFilterElement logCleanupFilter : additionalLogCleanupFilters) {
            filterElements.add(new LogCleanupFilterElement(logCleanupFilter.getLoggerName(), logCleanupFilter.getTargetLevel(), logCleanupFilter.getMessageStarts()));
        }
        LogCleanupFilter logCleanupFilter = new LogCleanupFilter(filterElements, dummy);
        ArrayList<Handler> handlers = new ArrayList<Handler>(3);
        if (config.console().enable()) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console(), consoleConfig, (ErrorManager)errorManager, logCleanupFilter, Collections.emptyMap(), Collections.emptyList(), new RuntimeValue<Optional<Supplier<String>>>(Optional.empty()), launchMode, false);
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        Map<String, Handler> namedHandlers = LoggingSetupRecorder.createNamedHandlers(config, consoleConfig, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (ErrorManager)errorManager, logCleanupFilter, Collections.emptyMap(), launchMode, dummy, false);
        LoggingSetupRecorder.setUpCategoryLoggers(buildConfig, categoryDefaultMinLevels, categories, logContext, (ErrorManager)errorManager, namedHandlers, false);
        LoggingSetupRecorder.addNamedHandlersToRootHandlers(config.handlers(), namedHandlers, handlers, (ErrorManager)errorManager);
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setBuildTimeHandlers(handlers.toArray(LogContextInitializer.NO_HANDLERS));
    }

    private boolean shouldCreateNamedHandlers(LogRuntimeConfig logRuntimeConfig, List<RuntimeValue<Map<String, Handler>>> additionalNamedHandlers) {
        if (!logRuntimeConfig.categories().isEmpty()) {
            return true;
        }
        if (logRuntimeConfig.handlers().isPresent()) {
            return !logRuntimeConfig.handlers().get().isEmpty();
        }
        return !additionalNamedHandlers.isEmpty();
    }

    public static <T> Level getLogLevel(String categoryName, Map<String, T> categories, Function<T, InheritableLevel> levelExtractor, Map<String, InheritableLevel> categoryDefaults, Level rootMinLevel) {
        InheritableLevel inheritableLevel;
        while ((inheritableLevel = LoggingSetupRecorder.getLogLevelNoInheritance(categoryName, categories, levelExtractor, categoryDefaults)).isInherited()) {
            int lastDotIndex = categoryName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                return rootMinLevel;
            }
            categoryName = categoryName.substring(0, lastDotIndex);
        }
        return inheritableLevel.getLevel();
    }

    public static <T> InheritableLevel getLogLevelNoInheritance(String categoryName, Map<String, T> categories, Function<T, InheritableLevel> levelExtractor, Map<String, InheritableLevel> categoryDefaults) {
        T categoryConfig = categories.get(categoryName);
        InheritableLevel inheritableLevel = null;
        if (categoryConfig != null) {
            inheritableLevel = levelExtractor.apply(categoryConfig);
        }
        if (inheritableLevel == null) {
            inheritableLevel = categoryDefaults.get(categoryName);
        }
        if (inheritableLevel == null) {
            inheritableLevel = InheritableLevel.Inherited.INSTANCE;
        }
        return inheritableLevel;
    }

    private static Map<String, Handler> createNamedHandlers(LogRuntimeConfig config, ConsoleRuntimeConfig consoleRuntimeConfig, List<RuntimeValue<Map<String, Handler>>> additionalNamedHandlers, List<RuntimeValue<Optional<Formatter>>> possibleConsoleFormatters, List<RuntimeValue<Optional<Formatter>>> possibleFileFormatters, List<RuntimeValue<Optional<Formatter>>> possibleSyslogFormatters, List<RuntimeValue<Optional<Formatter>>> possibleSocketFormatters, ErrorManager errorManager, LogCleanupFilter cleanupFilter, Map<String, Filter> namedFilters, LaunchMode launchMode, ShutdownNotifier shutdownHandler, boolean includeFilters) {
        Map<String, Handler> additionalNamedHandlersMap;
        HashMap<String, Handler> namedHandlers = new HashMap<String, Handler>();
        for (Map.Entry<String, LogRuntimeConfig.ConsoleConfig> entry : config.consoleHandlers().entrySet()) {
            LogRuntimeConfig.ConsoleConfig namedConsoleConfig = entry.getValue();
            if (!namedConsoleConfig.enable()) continue;
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(namedConsoleConfig, consoleRuntimeConfig, errorManager, cleanupFilter, namedFilters, possibleConsoleFormatters, null, launchMode, includeFilters);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, consoleHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.fileHandlers().entrySet()) {
            LogRuntimeConfig.FileConfig namedFileConfig = (LogRuntimeConfig.FileConfig)entry.getValue();
            if (!namedFileConfig.enable()) continue;
            Handler fileHandler = LoggingSetupRecorder.configureFileHandler(namedFileConfig, errorManager, cleanupFilter, namedFilters, possibleFileFormatters, includeFilters);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, fileHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.syslogHandlers().entrySet()) {
            Handler syslogHandler;
            LogRuntimeConfig.SyslogConfig namedSyslogConfig = (LogRuntimeConfig.SyslogConfig)entry.getValue();
            if (!namedSyslogConfig.enable() || (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(namedSyslogConfig, errorManager, cleanupFilter, namedFilters, possibleSyslogFormatters, includeFilters)) == null) continue;
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, syslogHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.socketHandlers().entrySet()) {
            Handler socketHandler;
            LogRuntimeConfig.SocketConfig namedSocketConfig = (LogRuntimeConfig.SocketConfig)entry.getValue();
            if (!namedSocketConfig.enable() || (socketHandler = LoggingSetupRecorder.configureSocketHandler(namedSocketConfig, errorManager, cleanupFilter, namedFilters, possibleSocketFormatters, includeFilters)) == null) continue;
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, socketHandler, entry.getKey());
        }
        if (additionalNamedHandlers.isEmpty()) {
            additionalNamedHandlersMap = Collections.emptyMap();
        } else {
            additionalNamedHandlersMap = new HashMap();
            for (RuntimeValue<Map<String, Handler>> runtimeValue : additionalNamedHandlers) {
                runtimeValue.getValue().forEach(new AdditionalNamedHandlersConsumer(additionalNamedHandlersMap, errorManager, cleanupFilter.filterElements.values(), shutdownHandler));
            }
        }
        namedHandlers.putAll(additionalNamedHandlersMap);
        return namedHandlers;
    }

    private static void addToNamedHandlers(Map<String, Handler> namedHandlers, final Handler handler, String handlerName) {
        if (namedHandlers.containsKey(handlerName)) {
            throw new RuntimeException(String.format("Only one handler can be configured with the same name '%s'", handlerName));
        }
        namedHandlers.put(handlerName, handler);
        InitialConfigurator.DELAYED_HANDLER.addLoggingCloseTask(new Runnable(){

            @Override
            public void run() {
                handler.close();
            }
        });
    }

    private static void addNamedHandlersToCategory(LogRuntimeConfig.CategoryConfig categoryConfig, Map<String, Handler> namedHandlers, final Logger categoryLogger, ErrorManager errorManager, boolean checkHandlerLinks) {
        for (String categoryNamedHandler : categoryConfig.handlers().get()) {
            final Handler handler = namedHandlers.get(categoryNamedHandler);
            if (handler != null) {
                categoryLogger.addHandler(handler);
                InitialConfigurator.DELAYED_HANDLER.addLoggingCloseTask(new Runnable(){

                    @Override
                    public void run() {
                        categoryLogger.removeHandler(handler);
                    }
                });
                continue;
            }
            if (!checkHandlerLinks) continue;
            errorManager.error(String.format("Handler with name '%s' is linked to a category but not configured.", categoryNamedHandler), null, 0);
        }
    }

    private static void setUpCategoryLoggers(LogBuildTimeConfig buildConfig, Map<String, InheritableLevel> categoryDefaultMinLevels, Map<String, LogRuntimeConfig.CategoryConfig> categories, LogContext logContext, ErrorManager errorManager, Map<String, Handler> namedHandlers, boolean checkHandlerLinks) {
        for (Map.Entry<String, LogRuntimeConfig.CategoryConfig> entry : categories.entrySet()) {
            String categoryName = entry.getKey();
            LogRuntimeConfig.CategoryConfig categoryConfig = entry.getValue();
            InheritableLevel categoryLevel = categoryConfig.level();
            Level logLevel = LoggingSetupRecorder.getLogLevel(categoryName, categories, LogRuntimeConfig.CategoryConfig::level, Collections.emptyMap(), buildConfig.minLevel());
            Level minLogLevel = LoggingSetupRecorder.getLogLevel(categoryName, buildConfig.categories(), LogBuildTimeConfig.CategoryBuildTimeConfig::minLevel, categoryDefaultMinLevels, buildConfig.minLevel());
            if (logLevel.intValue() < minLogLevel.intValue()) {
                String category = entry.getKey();
                log.warnf("Log level %s for category '%s' set below minimum logging level %s, promoting it to %s. Set the build time configuration property 'quarkus.log.category.\"%s\".min-level' to '%s' to avoid this warning", new Object[]{logLevel, category, minLogLevel, minLogLevel, category, logLevel});
                categoryLevel = InheritableLevel.of(minLogLevel.toString());
            }
            Logger categoryLogger = logContext.getLogger(categoryName);
            if (!categoryLevel.isInherited()) {
                categoryLogger.setLevel(categoryLevel.getLevel());
            }
            categoryLogger.setUseParentHandlers(categoryConfig.useParentHandlers());
            if (!categoryConfig.handlers().isPresent()) continue;
            LoggingSetupRecorder.addNamedHandlersToCategory(categoryConfig, namedHandlers, categoryLogger, errorManager, checkHandlerLinks);
        }
    }

    private static void addNamedHandlersToRootHandlers(Optional<List<String>> handlerNames, Map<String, Handler> namedHandlers, ArrayList<Handler> effectiveHandlers, ErrorManager errorManager) {
        if (handlerNames.isEmpty()) {
            return;
        }
        if (handlerNames.get().isEmpty()) {
            return;
        }
        for (String namedHandler : handlerNames.get()) {
            Handler handler = namedHandlers.get(namedHandler);
            if (handler != null) {
                effectiveHandlers.add(handler);
                continue;
            }
            errorManager.error(String.format("Handler with name '%s' is linked to a category but not configured.", namedHandler), null, 0);
        }
    }

    public void initializeLoggingForImageBuild() {
        if (ImageMode.current() == ImageMode.NATIVE_BUILD) {
            ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }

    private static Handler configureConsoleHandler(LogRuntimeConfig.ConsoleConfig config, ConsoleRuntimeConfig consoleRuntimeConfig, ErrorManager defaultErrorManager, LogCleanupFilter cleanupFilter, Map<String, Filter> namedFilters, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier, LaunchMode launchMode, boolean includeFilters) {
        Object handler;
        Formatter formatter = null;
        boolean formatterWarning = false;
        for (RuntimeValue<Optional<Formatter>> value : possibleFormatters) {
            Optional<Formatter> val;
            if (formatter != null) {
                formatterWarning = true;
            }
            if (!(val = value.getValue()).isPresent()) continue;
            formatter = val.get();
        }
        boolean color = false;
        if (formatter == null) {
            Supplier<String> bannerSupplier = null;
            if (possibleBannerSupplier != null && possibleBannerSupplier.getValue().isPresent()) {
                bannerSupplier = possibleBannerSupplier.getValue().get();
            }
            if (LoggingSetupRecorder.isColorEnabled(consoleRuntimeConfig, config)) {
                formatter = new ColorPatternFormatter(config.darken(), config.format());
                color = true;
            } else {
                formatter = new PatternFormatter(config.format());
            }
            if (bannerSupplier != null) {
                formatter = new TextBannerFormatter(bannerSupplier, ExtFormatter.wrap((Formatter)formatter, (boolean)false));
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(config.stderr() ? ConsoleHandler.Target.SYSTEM_ERR : ConsoleHandler.Target.SYSTEM_OUT, formatter);
        consoleHandler.setLevel(config.level());
        consoleHandler.setErrorManager(defaultErrorManager);
        LoggingSetupRecorder.applyFilter(includeFilters, defaultErrorManager, cleanupFilter, config.filter(), namedFilters, (Handler)consoleHandler);
        Object object = handler = config.async().enable() ? LoggingSetupRecorder.createAsyncHandler(config.async(), config.level(), (Handler)consoleHandler) : consoleHandler;
        if (color && launchMode.isDevOrTest() && !config.async().enable()) {
            ConsoleHandler delegate = handler;
            handler = new ExtHandler((Handler)delegate){
                final /* synthetic */ Handler val$delegate;
                {
                    this.val$delegate = handler;
                }

                protected void doPublish(ExtLogRecord record) {
                    BiConsumer formatter = CurrentAppExceptionHighlighter.THROWABLE_FORMATTER;
                    if (formatter != null) {
                        formatter.accept(record, this.val$delegate::publish);
                    } else {
                        this.val$delegate.publish((LogRecord)record);
                    }
                }

                public void flush() {
                    this.val$delegate.flush();
                }

                public void close() throws SecurityException {
                    this.val$delegate.close();
                }
            };
        }
        if (formatterWarning) {
            handler.getErrorManager().error("Multiple console formatters were activated", null, 0);
        }
        return handler;
    }

    private static Handler configureFileHandler(LogRuntimeConfig.FileConfig config, ErrorManager errorManager, LogCleanupFilter cleanupFilter, Map<String, Filter> namedFilters, List<RuntimeValue<Optional<Formatter>>> possibleFileFormatters, boolean includeFilters) {
        SizeRotatingFileHandler handler;
        LogRuntimeConfig.FileConfig.RotationConfig rotationConfig = config.rotation();
        if (rotationConfig.fileSuffix().isPresent()) {
            PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler = new PeriodicSizeRotatingFileHandler();
            periodicSizeRotatingFileHandler.setSuffix(rotationConfig.fileSuffix().get());
            periodicSizeRotatingFileHandler.setRotateSize(rotationConfig.maxFileSize().asLongValue());
            periodicSizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot());
            periodicSizeRotatingFileHandler.setMaxBackupIndex(rotationConfig.maxBackupIndex());
            handler = periodicSizeRotatingFileHandler;
        } else {
            SizeRotatingFileHandler sizeRotatingFileHandler = new SizeRotatingFileHandler(rotationConfig.maxFileSize().asLongValue(), rotationConfig.maxBackupIndex());
            sizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot());
            handler = sizeRotatingFileHandler;
        }
        Object formatter = null;
        boolean formatterWarning = false;
        for (RuntimeValue<Optional<Formatter>> value : possibleFileFormatters) {
            Optional<Formatter> val;
            if (formatter != null) {
                formatterWarning = true;
            }
            if (!(val = value.getValue()).isPresent()) continue;
            formatter = val.get();
        }
        if (formatter == null) {
            formatter = new PatternFormatter(config.format());
        }
        handler.setFormatter(formatter);
        handler.setAppend(true);
        try {
            handler.setFile(config.path());
        }
        catch (FileNotFoundException e) {
            errorManager.error("Failed to set log file", e, 4);
        }
        handler.setErrorManager(errorManager);
        handler.setLevel(config.level());
        handler.setFilter((Filter)cleanupFilter);
        if (config.encoding().isPresent()) {
            try {
                handler.setEncoding(config.encoding().get().name());
            }
            catch (UnsupportedEncodingException e) {
                errorManager.error("Failed to set character encoding", e, 0);
            }
        }
        LoggingSetupRecorder.applyFilter(includeFilters, errorManager, cleanupFilter, config.filter(), namedFilters, (Handler)handler);
        if (formatterWarning) {
            handler.getErrorManager().error("Multiple file formatters were activated", null, 0);
        }
        if (config.async().enable()) {
            return LoggingSetupRecorder.createAsyncHandler(config.async(), config.level(), (Handler)handler);
        }
        return handler;
    }

    private static void applyFilter(boolean includeFilters, ErrorManager errorManager, LogCleanupFilter cleanupFilter, Optional<String> filterName, Map<String, Filter> namedFilters, Handler handler) {
        if (filterName.isEmpty() || !includeFilters) {
            handler.setFilter(cleanupFilter);
        } else {
            String name = filterName.get();
            Filter filter = namedFilters.get(name);
            if (filter == null) {
                errorManager.error("Unable to find named filter '" + name + "'", null, 0);
                handler.setFilter(cleanupFilter);
            } else {
                handler.setFilter((Filter)new AllFilter(List.of(cleanupFilter, filter)));
            }
        }
    }

    private static Handler configureSyslogHandler(LogRuntimeConfig.SyslogConfig config, ErrorManager errorManager, LogCleanupFilter logCleanupFilter, Map<String, Filter> namedFilters, List<RuntimeValue<Optional<Formatter>>> possibleSyslogFormatters, boolean includeFilters) {
        try {
            SyslogHandler handler = new SyslogHandler(config.endpoint().getHostString(), config.endpoint().getPort());
            handler.setAppName(config.appName().orElse(Process.getProcessName()));
            handler.setHostname(config.hostname().orElse(HostName.getQualifiedHostName()));
            handler.setFacility(config.facility());
            handler.setSyslogType(config.syslogType());
            handler.setProtocol(config.protocol());
            handler.setBlockOnReconnect(config.blockOnReconnect());
            handler.setTruncate(config.truncate());
            handler.setUseCountingFraming(config.useCountingFraming());
            handler.setLevel(config.level());
            if (config.maxLength().isPresent()) {
                BigInteger maxLen = config.maxLength().get().asBigInteger();
                if (maxLen.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                    errorManager.error("Using 2GB as the value of maxLength for SyslogHandler as it is the maximum allowed value", null, 0);
                    maxLen = BigInteger.valueOf(Integer.MAX_VALUE);
                } else {
                    BigInteger minimumAllowedMaxLength = BigInteger.valueOf(128L);
                    if (maxLen.compareTo(minimumAllowedMaxLength) < 0) {
                        errorManager.error("Using 128 as the value of maxLength for SyslogHandler as using a smaller value is not allowed", null, 0);
                        maxLen = minimumAllowedMaxLength;
                    }
                }
                handler.setMaxLength(maxLen.intValue());
            }
            Object formatter = null;
            boolean formatterWarning = false;
            for (RuntimeValue<Optional<Formatter>> value : possibleSyslogFormatters) {
                Optional<Formatter> val;
                if (formatter != null) {
                    formatterWarning = true;
                }
                if (!(val = value.getValue()).isPresent()) continue;
                formatter = val.get();
            }
            if (formatter == null) {
                formatter = new PatternFormatter(config.format());
            }
            handler.setFormatter(formatter);
            handler.setErrorManager(errorManager);
            handler.setFilter((Filter)logCleanupFilter);
            LoggingSetupRecorder.applyFilter(includeFilters, errorManager, logCleanupFilter, config.filter(), namedFilters, (Handler)handler);
            if (formatterWarning) {
                handler.getErrorManager().error("Multiple syslog formatters were activated", null, 0);
            }
            if (config.async().enable()) {
                return LoggingSetupRecorder.createAsyncHandler(config.async(), config.level(), (Handler)handler);
            }
            return handler;
        }
        catch (IOException e) {
            errorManager.error("Failed to create syslog handler", e, 4);
            return null;
        }
    }

    private static Handler configureSocketHandler(LogRuntimeConfig.SocketConfig config, ErrorManager errorManager, LogCleanupFilter logCleanupFilter, Map<String, Filter> namedFilters, List<RuntimeValue<Optional<Formatter>>> possibleSocketFormatters, boolean includeFilters) {
        try {
            SocketHandler handler = new SocketHandler(config.endpoint().getHostString(), config.endpoint().getPort());
            handler.setProtocol(config.protocol());
            handler.setBlockOnReconnect(config.blockOnReconnect());
            handler.setLevel(config.level());
            Object formatter = null;
            boolean formatterWarning = false;
            for (RuntimeValue<Optional<Formatter>> value : possibleSocketFormatters) {
                Optional<Formatter> val;
                if (formatter != null) {
                    formatterWarning = true;
                }
                if (!(val = value.getValue()).isPresent()) continue;
                formatter = val.get();
            }
            if (formatter == null) {
                formatter = new PatternFormatter(config.format());
            }
            handler.setFormatter(formatter);
            handler.setErrorManager(errorManager);
            handler.setFilter((Filter)logCleanupFilter);
            LoggingSetupRecorder.applyFilter(includeFilters, errorManager, logCleanupFilter, config.filter(), namedFilters, (Handler)handler);
            if (formatterWarning) {
                handler.getErrorManager().error("Multiple socket formatters were activated", null, 0);
            }
            if (config.async().enable()) {
                return LoggingSetupRecorder.createAsyncHandler(config.async(), config.level(), (Handler)handler);
            }
            return handler;
        }
        catch (IOException e) {
            errorManager.error("Failed to create socket handler", e, 4);
            return null;
        }
    }

    private static AsyncHandler createAsyncHandler(LogRuntimeConfig.AsyncConfig asyncConfig, Level level, Handler handler) {
        AsyncHandler asyncHandler = new AsyncHandler(asyncConfig.queueLength());
        asyncHandler.setOverflowAction(asyncConfig.overflow());
        asyncHandler.addHandler(handler);
        asyncHandler.setLevel(level);
        return asyncHandler;
    }

    private static boolean isColorEnabled(ConsoleRuntimeConfig consoleConfig, LogRuntimeConfig.ConsoleConfig logConfig) {
        if (consoleConfig.color().isPresent()) {
            return consoleConfig.color().get();
        }
        if (logConfig.color().isPresent()) {
            return logConfig.color().get();
        }
        return QuarkusConsole.hasColorSupport();
    }

    public static class ShutdownNotifier
    implements ShutdownListener {
        volatile boolean shutdown;

        @Override
        public void shutdown(ShutdownListener.ShutdownNotification notification) {
            this.shutdown = true;
            notification.done();
        }
    }

    private static class AdditionalNamedHandlersConsumer
    implements BiConsumer<String, Handler> {
        private final Map<String, Handler> additionalNamedHandlersMap;
        private final ErrorManager errorManager;
        private final Collection<LogCleanupFilterElement> filterElements;
        private final ShutdownNotifier shutdownNotifier;

        public AdditionalNamedHandlersConsumer(Map<String, Handler> additionalNamedHandlersMap, ErrorManager errorManager, Collection<LogCleanupFilterElement> filterElements, ShutdownNotifier shutdownNotifier) {
            this.additionalNamedHandlersMap = additionalNamedHandlersMap;
            this.errorManager = errorManager;
            this.filterElements = filterElements;
            this.shutdownNotifier = shutdownNotifier;
        }

        @Override
        public void accept(String name, Handler handler) {
            Handler previous = this.additionalNamedHandlersMap.putIfAbsent(name, handler);
            if (previous != null) {
                throw new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", name, previous, handler));
            }
            handler.setErrorManager(this.errorManager);
            handler.setFilter(new LogCleanupFilter(this.filterElements, this.shutdownNotifier));
        }
    }
}

