/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.BasicConsole;
import io.quarkus.dev.console.InputHandler;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.function.Predicate;

public abstract class QuarkusConsole {
    public static final String FORCE_COLOR_SUPPORT = "io.quarkus.force-color-support";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    public static final boolean IS_CON_EMU_ANSI = IS_WINDOWS && "ON".equals(System.getenv("ConEmuANSI"));
    public static final boolean IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
    public static final boolean IS_MINGW_XTERM = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));
    protected final ArrayDeque<InputHolder> inputHandlers = new ArrayDeque();
    public static volatile QuarkusConsole INSTANCE = new BasicConsole(false, false, System.out);
    public static volatile boolean installed;
    protected volatile Predicate<String> outputFilter;
    private volatile boolean started = false;

    public static boolean hasColorSupport() {
        if (Boolean.getBoolean(FORCE_COLOR_SUPPORT)) {
            return true;
        }
        if (IS_WINDOWS) {
            return IS_CON_EMU_ANSI || IS_CYGWIN || IS_MINGW_XTERM;
        }
        return System.console() != null;
    }

    public synchronized void pushInputHandler(InputHandler inputHandler) {
        InputHolder holder = this.inputHandlers.peek();
        if (holder != null) {
            holder.setEnabled(false);
        }
        holder = this.createHolder(inputHandler);
        if (this.started) {
            holder.setEnabled(true);
        }
        this.inputHandlers.push(holder);
        inputHandler.promptHandler(holder);
    }

    public synchronized void popInputHandler() {
        InputHolder holder = this.inputHandlers.pop();
        holder.setEnabled(false);
        holder = this.inputHandlers.peek();
        if (holder != null) {
            holder.setEnabled(true);
        }
    }

    public static void start() {
        INSTANCE.startInternal();
    }

    private synchronized void startInternal() {
        if (this.started) {
            return;
        }
        this.started = true;
        InputHolder holder = this.inputHandlers.peek();
        if (holder != null) {
            holder.setEnabled(true);
        }
    }

    public abstract InputHolder createHolder(InputHandler var1);

    public abstract void write(String var1);

    public abstract void write(byte[] var1, int var2, int var3);

    protected String stripAnsiCodes(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\u001B\\[(.*?)[a-zA-Z]", "");
        return s;
    }

    public void setOutputFilter(Predicate<String> logHandler) {
        this.outputFilter = logHandler;
    }

    protected static abstract class InputHolder
    implements InputHandler.ConsoleStatus {
        public final InputHandler handler;
        volatile boolean enabled;
        String prompt;
        String status;
        String results;
        String compileError;

        protected InputHolder(InputHandler handler) {
            this.handler = handler;
        }

        public InputHolder setEnabled(boolean enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.setStatus(this.status);
                this.setPrompt(this.prompt);
                this.setResults(this.results);
                this.setCompileError(this.compileError);
            }
            return this;
        }

        @Override
        public void setPrompt(String prompt) {
            this.prompt = prompt;
            if (this.enabled) {
                this.setPromptMessage(prompt);
            }
        }

        @Override
        public void setStatus(String status) {
            this.status = status;
            if (this.enabled) {
                this.setStatusMessage(status);
            }
        }

        @Override
        public void setResults(String results) {
            this.results = results;
            if (this.enabled) {
                this.setResultsMessage(results);
            }
        }

        @Override
        public void setCompileError(String compileError) {
            this.compileError = compileError;
            if (this.enabled) {
                this.setCompileErrorMessage(compileError);
            }
        }

        protected abstract void setStatusMessage(String var1);

        protected abstract void setPromptMessage(String var1);

        protected abstract void setResultsMessage(String var1);

        protected abstract void setCompileErrorMessage(String var1);
    }
}

