/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.testcontainers.containers.MariaDBContainer;
import org.testcontainers.utility.DockerImageName;

public class MariaDBDevServicesProcessor {
    public static final String TAG = "10.5.9";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMariaDB() {
        return new DevServicesDatasourceProviderBuildItem("mariadb", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties) {
                final MariaDBContainer container = new MariaDBContainer(DockerImageName.parse((String)imageName.orElse(MariaDBContainer.IMAGE + ":" + MariaDBDevServicesProcessor.TAG)).asCompatibleSubstituteFor(DockerImageName.parse((String)MariaDBContainer.IMAGE))).withPassword(password.orElse("quarkus")).withUsername(username.orElse("quarkus")).withDatabaseName(datasourceName.orElse("default"));
                additionalProperties.forEach((arg_0, arg_1) -> ((MariaDBContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                    }
                });
            }
        });
    }
}

