/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.devtools.codestarts.CodestartInputBuilder;
import io.quarkus.devtools.codestarts.CodestartResourceLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class CodestartInput {
    private final CodestartResourceLoader resourceLoader;
    private final Collection<AppArtifactKey> extensions;
    private final boolean includeExamples;
    private final Map<String, Object> data;
    private final Collection<String> codestarts;

    CodestartInput(CodestartResourceLoader resourceLoader, Collection<AppArtifactKey> extensions, Collection<String> codestarts, boolean includeExamples, Map<String, Object> data) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader, "resourceLoader is required");
        this.extensions = Objects.requireNonNull(extensions, "extensions is required");
        this.codestarts = Objects.requireNonNull(codestarts, "codestarts is required");
        this.includeExamples = Objects.requireNonNull(Boolean.valueOf(includeExamples), "includeExamples is required");
        this.data = Objects.requireNonNull(data, "data is required");
    }

    public static CodestartInputBuilder builder(CodestartResourceLoader resourceLoader) {
        return new CodestartInputBuilder(resourceLoader, Collections.emptyMap());
    }

    public static CodestartInputBuilder builder(CodestartResourceLoader resourceLoader, Map<AppArtifactKey, String> extensionCodestartMapping) {
        return new CodestartInputBuilder(resourceLoader, extensionCodestartMapping);
    }

    public CodestartResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Collection<String> getCodestarts() {
        return this.codestarts;
    }

    public Collection<AppArtifactKey> getExtensions() {
        return this.extensions;
    }

    public boolean includeExamples() {
        return this.includeExamples;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

