/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands.file;

import io.quarkus.cli.commands.Printer;
import io.quarkus.cli.commands.writer.ProjectWriter;
import io.quarkus.dependencies.Extension;
import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.maven.utilities.QuarkusDependencyPredicate;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;

public abstract class BuildFile {
    protected static final Printer PRINTER = new Printer();
    private final ProjectWriter writer;

    public BuildFile(ProjectWriter writer) {
        this.writer = writer;
    }

    protected void write(String fileName, String content) throws IOException {
        this.writer.write(fileName, content);
    }

    public abstract void write() throws IOException;

    public boolean addDependency(List<Dependency> dependenciesFromBom, Extension extension) {
        if (!this.hasDependency(extension)) {
            PRINTER.ok(" Adding extension " + extension.managementKey());
            this.addDependencyInBuildFile(extension.toDependency(this.containsBOM() && this.isDefinedInBom(dependenciesFromBom, extension)));
            return true;
        }
        PRINTER.noop(" Skipping already present extension " + extension.managementKey());
        return false;
    }

    protected abstract void addDependencyInBuildFile(Dependency var1);

    protected abstract boolean hasDependency(Extension var1);

    public boolean addExtensionAsGAV(String query) {
        Dependency parsed = MojoUtils.parse(query.trim().toLowerCase());
        boolean alreadyThere = this.getDependencies().stream().anyMatch(d -> d.getManagementKey().equalsIgnoreCase(parsed.getManagementKey()));
        if (!alreadyThere) {
            PRINTER.ok(" Adding dependency " + parsed.getManagementKey());
            this.addDependencyInBuildFile(parsed);
            return true;
        }
        PRINTER.noop(" Skipping already present dependency " + parsed.getManagementKey());
        return false;
    }

    protected boolean isDefinedInBom(List<Dependency> dependencies, Extension extension) {
        return dependencies.stream().anyMatch(dependency -> dependency.getGroupId().equalsIgnoreCase(extension.getGroupId()) && dependency.getArtifactId().equalsIgnoreCase(extension.getArtifactId()));
    }

    protected abstract boolean containsBOM();

    public abstract List<Dependency> getDependencies();

    public Map<String, Dependency> findInstalled() {
        return this.mapDependencies(this.getDependencies(), this.loadManaged());
    }

    private Map<String, Dependency> loadManaged() {
        List<Dependency> managedDependencies = this.getManagedDependencies();
        return managedDependencies.isEmpty() ? Collections.emptyMap() : this.mapDependencies(managedDependencies, Collections.emptyMap());
    }

    protected Map<String, Dependency> mapDependencies(List<Dependency> dependencies, Map<String, Dependency> managed) {
        TreeMap<String, Dependency> map = new TreeMap<String, Dependency>();
        if (dependencies != null) {
            List<Dependency> listed = dependencies.stream().filter(new QuarkusDependencyPredicate()).collect(Collectors.toList());
            listed.forEach(d -> {
                String version;
                Dependency managedDep;
                if (d.getVersion() == null && (managedDep = (Dependency)managed.get(MojoUtils.credentials(d))) != null && (version = managedDep.getVersion()) != null) {
                    d.setVersion(version);
                }
                map.put(MojoUtils.credentials(d), (Dependency)d);
            });
        }
        return map;
    }

    public abstract String getProperty(String var1);

    protected abstract List<Dependency> getManagedDependencies();
}

